/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.stubs.jaxws;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@XmlRootElement(namespace="http://gcube-system.org", name="stacktrace")
public class ExceptionProxy {
    private static JAXBContext context;
    private static final DocumentBuilderFactory domFactory;
    @XmlAttribute
    public String name;
    @XmlAttribute
    public String msg;
    @XmlElement
    public List<StackTraceElementProxy> el = new ArrayList<StackTraceElementProxy>();
    @XmlElement
    public ExceptionProxy c;

    static {
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{ExceptionProxy.class});
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
        domFactory = DocumentBuilderFactory.newInstance();
    }

    public static ExceptionProxy newInstance(Element e) throws Exception {
        return (ExceptionProxy)context.createUnmarshaller().unmarshal((Node)e);
    }

    public static ExceptionProxy newInstance(Throwable t) {
        ExceptionProxy p = new ExceptionProxy();
        p.msg = t.getMessage();
        p.name = t.getClass().getCanonicalName();
        StackTraceElement[] stackTraceElementArray = t.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            StackTraceElementProxy ep = new StackTraceElementProxy();
            ep.cn = e.getClassName();
            ep.mn = e.getMethodName();
            ep.fn = e.getFileName();
            ep.ln = e.getLineNumber();
            p.el.add(ep);
            ++n2;
        }
        if (t.getCause() != null) {
            p.c = ExceptionProxy.newInstance(t.getCause());
        }
        return p;
    }

    public Throwable toThrowable() {
        String msg = "remote cause: (" + (this.msg == null ? this.name : this.msg) + ")";
        Throwable t = this.c == null ? new Throwable(msg) : new Throwable(msg, this.c.toThrowable());
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
        for (StackTraceElementProxy ep : this.el) {
            elements.add(new StackTraceElement(ep.cn, ep.mn, ep.fn, ep.ln));
        }
        t.setStackTrace(elements.toArray(new StackTraceElement[0]));
        return t;
    }

    public Element toElement() throws Exception {
        Document d = domFactory.newDocumentBuilder().newDocument();
        context.createMarshaller().marshal((Object)this, (Node)d);
        return d.getDocumentElement();
    }

    @XmlType(name="e")
    static class StackTraceElementProxy {
        @XmlAttribute
        public String cn;
        @XmlAttribute
        public String mn;
        @XmlAttribute
        public String fn;
        @XmlAttribute
        public int ln;

        StackTraceElementProxy() {
        }
    }
}

