/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.stubs.jaxws.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.gcube.common.clients.stubs.jaxws.handlers.CallHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerRegistry {
    private static final Logger log = LoggerFactory.getLogger(HandlerRegistry.class);
    private static final List<CallHandler> handlers = new ArrayList<CallHandler>();

    static {
        ServiceLoader<CallHandler> loader = ServiceLoader.load(CallHandler.class);
        Iterator<CallHandler> it = loader.iterator();
        while (it.hasNext()) {
            try {
                CallHandler handler = it.next();
                log.info("loaded call handler {}", (Object)handler);
                handlers.add(handler);
            }
            catch (Error e) {
                log.error("could not load call handler", (Throwable)e);
            }
        }
    }

    public static List<CallHandler> handlers() {
        return handlers;
    }
}

