/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import com.google.common.primitives.Longs;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PreHashedDecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.MurmurHash;
import org.apache.cassandra.utils.ObjectSizes;

public class Murmur3Partitioner
implements IPartitioner {
    public static final LongToken MINIMUM = new LongToken(Long.MIN_VALUE);
    public static final long MAXIMUM = Long.MAX_VALUE;
    private static final int HEAP_SIZE = (int)ObjectSizes.measureDeep(MINIMUM);
    public static final Murmur3Partitioner instance = new Murmur3Partitioner();
    private final Token.TokenFactory tokenFactory = new Token.TokenFactory(){

        @Override
        public ByteBuffer toByteArray(Token token) {
            LongToken longToken = (LongToken)token;
            return ByteBufferUtil.bytes(longToken.token);
        }

        @Override
        public Token fromByteArray(ByteBuffer bytes) {
            return new LongToken(ByteBufferUtil.toLong(bytes));
        }

        @Override
        public String toString(Token token) {
            return token.toString();
        }

        @Override
        public void validate(String token) throws ConfigurationException {
            try {
                Long.valueOf(token);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(e.getMessage());
            }
        }

        @Override
        public Token fromString(String string) {
            try {
                return new LongToken(Long.parseLong(string));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Invalid token for Murmur3Partitioner. Got %s but expected a long value (unsigned 8 bytes integer).", string));
            }
        }
    };

    @Override
    public DecoratedKey decorateKey(ByteBuffer key) {
        long[] hash = this.getHash(key);
        return new PreHashedDecoratedKey(this.getToken(key, hash), key, hash[0], hash[1]);
    }

    @Override
    public Token midpoint(Token lToken, Token rToken) {
        BigInteger midpoint;
        BigInteger r;
        BigInteger l = BigInteger.valueOf(((LongToken)lToken).token);
        if (l.compareTo(r = BigInteger.valueOf(((LongToken)rToken).token)) < 0) {
            BigInteger sum = l.add(r);
            midpoint = sum.shiftRight(1);
        } else {
            BigInteger min;
            BigInteger max = BigInteger.valueOf(Long.MAX_VALUE);
            midpoint = max.subtract(min = BigInteger.valueOf(Murmur3Partitioner.MINIMUM.token)).add(l).add(r).shiftRight(1);
            if (midpoint.compareTo(max) > 0) {
                midpoint = min.add(midpoint.subtract(max));
            }
        }
        return new LongToken(midpoint.longValue());
    }

    @Override
    public LongToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public LongToken getToken(ByteBuffer key) {
        return this.getToken(key, this.getHash(key));
    }

    private LongToken getToken(ByteBuffer key, long[] hash) {
        if (key.remaining() == 0) {
            return MINIMUM;
        }
        return new LongToken(this.normalize(hash[0]));
    }

    private long[] getHash(ByteBuffer key) {
        long[] hash = new long[2];
        MurmurHash.hash3_x64_128(key, key.position(), key.remaining(), 0L, hash);
        return hash;
    }

    @Override
    public LongToken getRandomToken() {
        return new LongToken(this.normalize(ThreadLocalRandom.current().nextLong()));
    }

    private long normalize(long v) {
        return v == Long.MIN_VALUE ? Long.MAX_VALUE : v;
    }

    @Override
    public boolean preservesOrder() {
        return false;
    }

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        HashMap<Token, Float> ownerships = new HashMap<Token, Float>();
        Iterator<Token> i = sortedTokens.iterator();
        if (!i.hasNext()) {
            throw new RuntimeException("No nodes present in the cluster. Has this node finished starting up?");
        }
        if (sortedTokens.size() == 1) {
            ownerships.put(i.next(), new Float(1.0));
        } else {
            BigInteger ti;
            BigInteger ri = BigInteger.valueOf(Long.MAX_VALUE).subtract(BigInteger.valueOf(Murmur3Partitioner.MINIMUM.token + 1L));
            BigDecimal r = new BigDecimal(ri);
            Token start = i.next();
            BigInteger tim1 = ti = BigInteger.valueOf(((LongToken)start).token);
            while (i.hasNext()) {
                Token t = i.next();
                ti = BigInteger.valueOf(((LongToken)t).token);
                float age = new BigDecimal(ti.subtract(tim1).add(ri).mod(ri)).divide(r, 6, 6).floatValue();
                ownerships.put(t, Float.valueOf(age));
                tim1 = ti;
            }
            float x = new BigDecimal(BigInteger.valueOf(((LongToken)start).token).subtract(ti).add(ri).mod(ri)).divide(r, 6, 6).floatValue();
            ownerships.put(start, Float.valueOf(x));
        }
        return ownerships;
    }

    @Override
    public Token.TokenFactory getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public AbstractType<?> getTokenValidator() {
        return LongType.instance;
    }

    public static class LongToken
    extends Token {
        static final long serialVersionUID = -5833580143318243006L;
        final long token;

        public LongToken(long token) {
            this.token = token;
        }

        public String toString() {
            return Long.toString(this.token);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.token == ((LongToken)obj).token;
        }

        public int hashCode() {
            return Longs.hashCode((long)this.token);
        }

        @Override
        public int compareTo(Token o) {
            return Long.compare(this.token, ((LongToken)o).token);
        }

        @Override
        public IPartitioner getPartitioner() {
            return instance;
        }

        @Override
        public long getHeapSize() {
            return HEAP_SIZE;
        }

        @Override
        public Object getTokenValue() {
            return this.token;
        }
    }
}

