/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.nio.ByteBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.MemtableBufferAllocator;

public final class ContextAllocator
extends AbstractAllocator {
    private final OpOrder.Group opGroup;
    private final MemtableBufferAllocator allocator;

    public ContextAllocator(OpOrder.Group opGroup, MemtableBufferAllocator allocator) {
        this.opGroup = opGroup;
        this.allocator = allocator;
    }

    @Override
    public ByteBuffer clone(ByteBuffer buffer) {
        assert (buffer != null);
        if (buffer.remaining() == 0) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer cloned = this.allocate(buffer.remaining());
        cloned.mark();
        cloned.put(buffer.duplicate());
        cloned.reset();
        return cloned;
    }

    @Override
    public ByteBuffer allocate(int size) {
        return this.allocator.allocate(size, this.opGroup);
    }
}

