/*
 * Decompiled with CFR 0.152.
 */
package org.jfile.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jfile.model.MatchAware;
import org.jfile.util.MatcherFactory;
import org.jfile.util.Parser;

public class Matcher<M> {
    private ThreadLocalMap<M> matcherMap = new ThreadLocalMap();
    private ThreadLocalParser<M> parser = new ThreadLocalParser();

    public Matcher(Class<M> type) throws Exception {
        this.parser.set(MatcherFactory.getParser(type));
        this.matcherMap.set(((Parser)this.parser.get()).parse());
    }

    public Matcher(Class<M> type, File file) throws Exception {
        this.parser.set(MatcherFactory.getParser(type));
        this.matcherMap.set(((Parser)this.parser.get()).parse(file));
    }

    public Parser<M> getParser() {
        return (Parser)this.parser.get();
    }

    public <O> List<M> match(O objectToMatch, int startingPrio, int endingPrio, boolean keepGoing) throws IOException {
        ArrayList<MatchAware> results = new ArrayList<MatchAware>();
        ThreadLocalMap<M> mm = this.matcherMap;
        Set keys = ((TreeMap)mm.get()).descendingKeySet();
        block0: for (Integer key : keys) {
            if (key > startingPrio || key < endingPrio) continue;
            List matchers = (List)((TreeMap)mm.get()).get(key);
            for (MatchAware matcher : matchers) {
                if (!matcher.match(objectToMatch)) continue;
                results.add(matcher);
                if (keepGoing) continue block0;
                return results;
            }
        }
        return results;
    }

    private static class ThreadLocalMap<M>
    extends ThreadLocal<TreeMap<Integer, List<M>>> {
        private ThreadLocalMap() {
        }

        @Override
        protected TreeMap<Integer, List<M>> initialValue() {
            return new TreeMap<Integer, List<M>>();
        }
    }

    private static class ThreadLocalParser<M>
    extends ThreadLocal<Parser<M>> {
        private ThreadLocalParser() {
        }

        @Override
        protected Parser<M> initialValue() {
            return null;
        }
    }
}

