/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.taglib.aui.NavBarTag;
import com.liferay.taglib.aui.base.BaseNavTag;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class NavTag
extends BaseNavTag {
    private boolean _calledCollapsibleSetter;
    private String _namespacedId;

    @Override
    public int doStartTag() throws JspException {
        NavBarTag navBarTag = (NavBarTag)NavTag.findAncestorWithClass((Tag)this, NavBarTag.class);
        if (navBarTag != null && (!this._calledCollapsibleSetter || this.getCollapsible())) {
            this.setCollapsible(true);
            ThemeDisplay themeDisplay = (ThemeDisplay)this.pageContext.getAttribute("themeDisplay");
            StringBundler sb = navBarTag.getResponsiveButtonsSB();
            sb.append("<a class=\"btn btn-navbar\" id=\"");
            sb.append(this._getNamespacedId());
            sb.append("NavbarBtn\" ");
            sb.append("data-navId=\"");
            sb.append(this._getNamespacedId());
            sb.append("\" tabindex=\"0\">");
            String icon = this.getIcon();
            if (Validator.isNull((String)icon)) {
                sb.append("<span class=\"icon-bar\"></span>");
                sb.append("<span class=\"icon-bar\"></span>");
                sb.append("<span class=\"icon-bar\"></span>");
            } else if (icon.equals("user") && themeDisplay.isSignedIn()) {
                try {
                    User user = themeDisplay.getUser();
                    sb.append("<img alt=\"");
                    sb.append(LanguageUtil.get((PageContext)this.pageContext, (String)"my-account"));
                    sb.append("\" class=\"user-avatar-image\" ");
                    sb.append("src=\"");
                    sb.append(user.getPortraitURL(themeDisplay));
                    sb.append("\">");
                }
                catch (Exception e) {
                    throw new JspException((Throwable)e);
                }
            } else {
                sb.append("<i class=\"icon-");
                sb.append(icon);
                sb.append("\"></i>");
            }
            sb.append("</a>");
        }
        return super.doStartTag();
    }

    @Override
    public void setCollapsible(boolean collapsible) {
        super.setCollapsible(collapsible);
        this._calledCollapsibleSetter = true;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._calledCollapsibleSetter = false;
        this._namespacedId = null;
    }

    @Override
    protected void setAttributes(HttpServletRequest request) {
        super.setAttributes(request);
        this.setNamespacedAttribute(request, "id", this._getNamespacedId());
    }

    private String _getNamespacedId() {
        HttpServletRequest request;
        PortletResponse portletResponse;
        if (Validator.isNotNull((String)this._namespacedId)) {
            return this._namespacedId;
        }
        this._namespacedId = this.getId();
        if (Validator.isNull((String)this._namespacedId)) {
            this._namespacedId = StringUtil.randomId();
        }
        if ((portletResponse = (PortletResponse)(request = (HttpServletRequest)this.pageContext.getRequest()).getAttribute("javax.portlet.response")) != null && this.getUseNamespace()) {
            this._namespacedId = String.valueOf(portletResponse.getNamespace()) + this._namespacedId;
        }
        return this._namespacedId;
    }
}

