/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.providers;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.MessageRouter;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.util.Provider;

public class MsgJavaProvider
implements Provider {
    private DeploymentDescriptor dd;
    private Envelope envelope;
    private Call call;
    private String methodName;
    private String targetObjectURI;
    private HttpServlet servlet;
    private HttpSession session;
    private Object targetObject;

    public void invoke(SOAPContext sOAPContext, SOAPContext sOAPContext2) throws SOAPException {
        try {
            MessageRouter.invoke(this.dd, this.envelope, this.targetObject, this.methodName, sOAPContext, sOAPContext2);
        }
        catch (Exception exception) {
            if (exception instanceof SOAPException) {
                throw (SOAPException)exception;
            }
            exception.printStackTrace(System.err);
            throw new SOAPException(Constants.FAULT_CODE_SERVER, exception.toString());
        }
    }

    public void locate(DeploymentDescriptor deploymentDescriptor, Envelope envelope, Call call, String string, String string2, SOAPContext sOAPContext) throws SOAPException {
        HttpServlet httpServlet = (HttpServlet)sOAPContext.getProperty(Constants.BAG_HTTPSERVLET);
        HttpSession httpSession = (HttpSession)sOAPContext.getProperty(Constants.BAG_HTTPSESSION);
        this.dd = deploymentDescriptor;
        this.envelope = envelope;
        this.call = call;
        this.methodName = string;
        this.targetObjectURI = string2;
        this.servlet = httpServlet;
        this.session = httpSession;
        ServletConfig servletConfig = httpServlet.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext(servletContext);
        if (!MessageRouter.validMessage(deploymentDescriptor, string)) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Method '" + string + "' is not supported.");
        }
        this.targetObject = ServerHTTPUtils.getTargetObject(serviceManager, deploymentDescriptor, string2, httpServlet, httpSession, sOAPContext, servletContext);
    }
}

