/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.sql.Clob;
import java.sql.SQLException;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.ArraysUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConverter
implements TypeConverter<String> {
    @Override
    public String convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        Class<?> type = value.getClass();
        if (type == Class.class) {
            return ((Class)value).getName();
        }
        if (type.isArray()) {
            if (type == char[].class) {
                char[] charArray = (char[])value;
                return new String(charArray);
            }
            if (type == int[].class) {
                return ArraysUtil.toString((int[])((int[])value));
            }
            if (type == long[].class) {
                return ArraysUtil.toString((long[])((long[])value));
            }
            if (type == byte[].class) {
                return ArraysUtil.toString((byte[])((byte[])value));
            }
            if (type == float[].class) {
                return ArraysUtil.toString((float[])((float[])value));
            }
            if (type == double[].class) {
                return ArraysUtil.toString((double[])((double[])value));
            }
            if (type == short[].class) {
                return ArraysUtil.toString((short[])((short[])value));
            }
            if (type == boolean[].class) {
                return ArraysUtil.toString((boolean[])((boolean[])value));
            }
            return ArraysUtil.toString((Object[])((Object[])value));
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            try {
                long length = clob.length();
                if (length > Integer.MAX_VALUE) {
                    throw new TypeConversionException("Clob is too big.");
                }
                return clob.getSubString(1L, (int)length);
            }
            catch (SQLException sex) {
                throw new TypeConversionException(value, (Throwable)sex);
            }
        }
        return value.toString();
    }
}

