/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.IArityNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZSuperNode
extends Node
implements IArityNode,
BlockAcceptingNode {
    private Node iterNode;
    private CallSite callSite = MethodIndex.getSuperCallSite();

    public ZSuperNode(ISourcePosition position) {
        super(position);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ZSUPERNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitZSuperNode(this);
    }

    @Override
    public Arity getArity() {
        return Arity.optional();
    }

    @Override
    public List<Node> childNodes() {
        return this.iterNode != null ? ZSuperNode.createList(this.iterNode) : EMPTY_LIST;
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        return this;
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        Block block = ASTInterpreter.getBlock(runtime2, context, self, aBlock, this.iterNode);
        if (block == null || !block.isGiven()) {
            block = context.getFrameBlock();
        }
        return this.callSite.callVarargs(context, self, self, context.getCurrentScope().getArgValues(), block);
    }

    @Override
    public ByteList definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        String name2 = context.getFrameName();
        RubyModule klazz = context.getFrameKlazz();
        if (name2 != null && klazz != null && RuntimeHelpers.findImplementerIfNecessary(self.getMetaClass(), klazz).getSuperClass().isMethodBound(name2, false)) {
            return SUPER_BYTELIST;
        }
        return null;
    }
}

