/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2IntMap;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFloat2IntMap
implements Float2IntMap,
Serializable {
    protected int defRetValue;

    protected AbstractFloat2IntMap() {
    }

    @Override
    public void defaultReturnValue(int rv) {
        this.defRetValue = rv;
    }

    @Override
    public int defaultReturnValue() {
        return this.defRetValue;
    }

    @Override
    public int put(float key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remove(float key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer get(Object ok) {
        float k = ((Float)ok).floatValue();
        return this.containsKey(k) ? Integer.valueOf(this.get(k)) : null;
    }

    @Override
    public Integer put(Float ok, Integer ov) {
        float k = ok.floatValue();
        int v = this.put(k, (int)ov);
        return this.containsKey(k) ? Integer.valueOf(v) : null;
    }

    @Override
    public Integer remove(Object ok) {
        float k = ((Float)ok).floatValue();
        int v = this.remove(k);
        return this.containsKey(k) ? Integer.valueOf(v) : null;
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue((Integer)ov);
    }

    @Override
    public boolean containsKey(Object ok) {
        return this.containsKey(((Float)ok).floatValue());
    }

    @Override
    public boolean containsValue(int v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(float k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Integer> m) {
        int n = m.size();
        Iterator<Map.Entry<? extends Float, ? extends Integer>> i = m.entrySet().iterator();
        if (m instanceof Float2IntMap) {
            while (n-- != 0) {
                Float2IntMap.Entry e = (Float2IntMap.Entry)i.next();
                this.put(e.getFloatKey(), e.getIntValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Float, ? extends Integer> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet keySet() {
        return new AbstractFloatSet(){

            public boolean contains(float k) {
                return AbstractFloat2IntMap.this.containsKey(k);
            }

            public int size() {
                return AbstractFloat2IntMap.this.size();
            }

            public void clear() {
                AbstractFloat2IntMap.this.clear();
            }

            public FloatIterator iterator() {
                return new AbstractFloatIterator(){
                    final ObjectIterator<Map.Entry<Float, Integer>> i;
                    {
                        this.i = AbstractFloat2IntMap.this.entrySet().iterator();
                    }

                    public float nextFloat() {
                        return ((Float2IntMap.Entry)this.i.next()).getFloatKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public IntCollection values() {
        return new AbstractIntCollection(){

            public boolean contains(int k) {
                return AbstractFloat2IntMap.this.containsValue(k);
            }

            public int size() {
                return AbstractFloat2IntMap.this.size();
            }

            public void clear() {
                AbstractFloat2IntMap.this.clear();
            }

            public IntIterator iterator() {
                return new AbstractIntIterator(){
                    final ObjectIterator<Map.Entry<Float, Integer>> i;
                    {
                        this.i = AbstractFloat2IntMap.this.entrySet().iterator();
                    }

                    public int nextInt() {
                        return ((Float2IntMap.Entry)this.i.next()).getIntValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Map.Entry<Float, Integer>> i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)((Map.Entry)i.next())).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Map.Entry<Float, Integer>> i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Float2IntMap.Entry e = (Float2IntMap.Entry)i.next();
            s.append(String.valueOf(e.getFloatKey()));
            s.append("=>");
            s.append(String.valueOf(e.getIntValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Float2IntMap.Entry {
        protected float key;
        protected int value;

        public BasicEntry(Float key, Integer value) {
            this.key = key.floatValue();
            this.value = value;
        }

        public BasicEntry(float key, int value) {
            this.key = key;
            this.value = value;
        }

        public Float getKey() {
            return Float.valueOf(this.key);
        }

        public float getFloatKey() {
            return this.key;
        }

        public Integer getValue() {
            return this.value;
        }

        public int getIntValue() {
            return this.value;
        }

        public int setValue(int value) {
            throw new UnsupportedOperationException();
        }

        public Integer setValue(Integer value) {
            return this.setValue((int)value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == ((Float)e.getKey()).floatValue() && this.value == (Integer)e.getValue();
        }

        public int hashCode() {
            return HashCommon.float2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

