/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloat2CharSortedMap;
import it.unimi.dsi.fastutil.floats.AbstractFloatSortedSet;
import it.unimi.dsi.fastutil.floats.Float2CharMap;
import it.unimi.dsi.fastutil.floats.Float2CharSortedMap;
import it.unimi.dsi.fastutil.floats.FloatBidirectionalIterator;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Float2CharLinkedOpenHashMap
extends AbstractFloat2CharSortedMap
implements Serializable,
Cloneable,
Hash {
    protected transient float[] key;
    protected transient char[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSortedSet<Map.Entry<Float, Character>> entries;
    protected volatile transient FloatSortedSet keys;
    protected volatile transient CharCollection values;
    protected transient int growthFactor = 16;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Float2CharLinkedOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new float[this.free];
        this.value = new char[this.free];
        this.state = new byte[this.free];
        this.link = new int[this.free];
    }

    public Float2CharLinkedOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Float2CharLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Float2CharLinkedOpenHashMap(Map<? extends Float, ? extends Character> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Float2CharLinkedOpenHashMap(Map<? extends Float, ? extends Character> m) {
        this(m, 0.75f);
    }

    public Float2CharLinkedOpenHashMap(Float2CharMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Float2CharLinkedOpenHashMap(Float2CharMap m) {
        this(m, 0.75f);
    }

    public Float2CharLinkedOpenHashMap(float[] k, char[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Float2CharLinkedOpenHashMap(float[] k, char[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(float k) {
        float[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.float2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(float k) {
        float[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.float2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    @Override
    public char put(float k, char v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            char oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    @Override
    public Character put(Float ok, Character ov) {
        char v = ov.charValue();
        float k = ok.floatValue();
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            char oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return Character.valueOf(oldValue);
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    @Override
    public boolean containsValue(char v) {
        char[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        this.last = -1;
        this.first = -1;
    }

    private void fixPointers(int i) {
        int next;
        if (this.count == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    @Override
    public float firstFloatKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public float lastFloatKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public FloatComparator comparator() {
        return null;
    }

    @Override
    public Float2CharSortedMap tailMap(float from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float2CharSortedMap headMap(float to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float2CharSortedMap subMap(float from, float to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(float k) {
        return this.findKey(k) >= 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public char get(float k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    @Override
    public char remove(float k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.fixPointers(i);
        return this.value[i];
    }

    public Character get(Float ok) {
        int i = this.findKey(ok.floatValue());
        return i < 0 ? null : Character.valueOf(this.value[i]);
    }

    @Override
    public Character remove(Object ok) {
        int i = this.findKey(((Float)ok).floatValue());
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        this.fixPointers(i);
        return Character.valueOf(this.value[i]);
    }

    @Override
    public ObjectSortedSet<Map.Entry<Float, Character>> entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSortedSet<Map.Entry<Float, Character>>(){

                @Override
                public ObjectBidirectionalIterator<Map.Entry<Float, Character>> iterator() {
                    return new EntryIterator();
                }

                @Override
                public Comparator<? super Map.Entry<Float, Character>> comparator() {
                    return null;
                }

                @Override
                public ObjectSortedSet<Map.Entry<Float, Character>> subSet(Map.Entry<Float, Character> fromElement, Map.Entry<Float, Character> toElement) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ObjectSortedSet<Map.Entry<Float, Character>> headSet(Map.Entry<Float, Character> toElement) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ObjectSortedSet<Map.Entry<Float, Character>> tailSet(Map.Entry<Float, Character> fromElement) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Map.Entry<Float, Character> first() {
                    if (Float2CharLinkedOpenHashMap.this.count == 0) {
                        throw new NoSuchElementException();
                    }
                    return new MapEntry(Float2CharLinkedOpenHashMap.this.first);
                }

                @Override
                public Map.Entry<Float, Character> last() {
                    if (Float2CharLinkedOpenHashMap.this.count == 0) {
                        throw new NoSuchElementException();
                    }
                    return new MapEntry(Float2CharLinkedOpenHashMap.this.last);
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Float2CharLinkedOpenHashMap.this.findKey(((Float)e.getKey()).floatValue());
                    return i >= 0 && Float2CharLinkedOpenHashMap.this.value[i] == ((Character)e.getValue()).charValue();
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Float2CharLinkedOpenHashMap.this.findKey(((Float)e.getKey()).floatValue());
                    if (i >= 0) {
                        Float2CharLinkedOpenHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                @Override
                public int size() {
                    return Float2CharLinkedOpenHashMap.this.count;
                }

                @Override
                public void clear() {
                    Float2CharLinkedOpenHashMap.this.clear();
                }

                @Override
                public ObjectBidirectionalIterator<Map.Entry<Float, Character>> iterator(Map.Entry<Float, Character> from) {
                    return new EntryIterator(from.getKey().floatValue());
                }
            };
        }
        return this.entries;
    }

    @Override
    public FloatSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public CharCollection values() {
        if (this.values == null) {
            this.values = new AbstractCharCollection(){

                public CharIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Float2CharLinkedOpenHashMap.this.count;
                }

                public boolean contains(char v) {
                    return Float2CharLinkedOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Float2CharLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = this.first;
        int j = this.count;
        int prev = -1;
        int newPrev = -1;
        int newN = PRIMES[newP];
        float[] key = this.key;
        float[] newKey = new float[newN];
        char[] value = this.value;
        char[] newValue = new char[newN];
        byte[] state = this.state;
        byte[] newState = new byte[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            float k = key[i];
            char v = value[i];
            int k2i = HashCommon.float2int(k) & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            int t = i;
            i = link[i] ^ prev;
            prev = t;
            if (this.first != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ h1;
                newLink[h1] = newPrev;
                newPrev = h1;
                continue;
            }
            newPrev = this.first = h1;
            newLink[h1] = -1;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Object clone() {
        Float2CharLinkedOpenHashMap c;
        try {
            c = (Float2CharLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (float[])this.key.clone();
        c.value = (char[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            t = HashCommon.float2int(this.key[i]);
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        float[] key = this.key;
        char[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeFloat(key[e]);
            s.writeChar(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new float[n];
        float[] key = this.key;
        this.value = new char[n];
        char[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        this.link = new int[n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.count;
        while (i-- != 0) {
            float k = s.readFloat();
            char v = s.readChar();
            int k2i = HashCommon.float2int(k) & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
            if (this.first != -1) {
                int n2 = prev;
                link[n2] = link[n2] ^ h1;
                link[h1] = prev;
                prev = h1;
                continue;
            }
            prev = this.first = h1;
            link[h1] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n3 = prev;
            link[n3] = ~link[n3];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements CharListIterator {
        public char previousChar() {
            return Float2CharLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public Character previous() {
            return Character.valueOf(Float2CharLinkedOpenHashMap.this.value[this.previousEntry()]);
        }

        public void set(Character ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Character ok) {
            throw new UnsupportedOperationException();
        }

        public void set(char v) {
            throw new UnsupportedOperationException();
        }

        public void add(char v) {
            throw new UnsupportedOperationException();
        }

        public char nextChar() {
            return Float2CharLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        public Character next() {
            return Character.valueOf(Float2CharLinkedOpenHashMap.this.value[this.nextEntry()]);
        }
    }

    private final class KeySet
    extends AbstractFloatSortedSet {
        private KeySet() {
        }

        public FloatBidirectionalIterator iterator(float from) {
            return new KeyIterator(from);
        }

        public FloatBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Float2CharLinkedOpenHashMap.this.count;
        }

        public boolean contains(float k) {
            return Float2CharLinkedOpenHashMap.this.containsKey(k);
        }

        public boolean remove(float k) {
            int oldCount = Float2CharLinkedOpenHashMap.this.count;
            Float2CharLinkedOpenHashMap.this.remove(k);
            return Float2CharLinkedOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Float2CharLinkedOpenHashMap.this.clear();
        }

        public float firstFloat() {
            if (Float2CharLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Float2CharLinkedOpenHashMap.this.key[Float2CharLinkedOpenHashMap.this.first];
        }

        public float lastFloat() {
            if (Float2CharLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Float2CharLinkedOpenHashMap.this.key[Float2CharLinkedOpenHashMap.this.last];
        }

        public FloatComparator comparator() {
            return null;
        }

        public final FloatSortedSet tailSet(float from) {
            throw new UnsupportedOperationException();
        }

        public final FloatSortedSet headSet(float to) {
            throw new UnsupportedOperationException();
        }

        public final FloatSortedSet subSet(float from, float to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements FloatListIterator {
        public KeyIterator(float k) {
            super(k);
        }

        public float previousFloat() {
            return Float2CharLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public void set(float k) {
            throw new UnsupportedOperationException();
        }

        public void add(float k) {
            throw new UnsupportedOperationException();
        }

        public Float previous() {
            return Float.valueOf(Float2CharLinkedOpenHashMap.this.key[this.previousEntry()]);
        }

        public void set(Float ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Float ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        public float nextFloat() {
            return Float2CharLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        public Float next() {
            return Float.valueOf(Float2CharLinkedOpenHashMap.this.key[this.nextEntry()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Map.Entry<Float, Character>> {
        public EntryIterator() {
        }

        public EntryIterator(float from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Map.Entry<Float, Character> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Map.Entry<Float, Character> ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        MapIterator() {
            this.next = Float2CharLinkedOpenHashMap.this.first;
        }

        MapIterator(float from) {
            if (Float2CharLinkedOpenHashMap.this.key[Float2CharLinkedOpenHashMap.this.last] == from) {
                this.prev = Float2CharLinkedOpenHashMap.this.last;
                this.index = Float2CharLinkedOpenHashMap.this.count;
            } else {
                int e;
                if (!Float2CharLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Float2CharLinkedOpenHashMap.this.first;
                while (Float2CharLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Float2CharLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Float2CharLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Float2CharLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            Float2CharLinkedOpenHashMap.this.state[this.curr] = 1;
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Float2CharLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Float2CharLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Float2CharLinkedOpenHashMap.this.count;
            if (this.prev == -1) {
                Float2CharLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Float2CharLinkedOpenHashMap.this.link[n] = Float2CharLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Float2CharLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Float2CharLinkedOpenHashMap.this.link[n] = Float2CharLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Float2CharMap.Entry,
    Map.Entry<Float, Character> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Float getKey() {
            return Float.valueOf(Float2CharLinkedOpenHashMap.this.key[this.index]);
        }

        @Override
        public float getFloatKey() {
            return Float2CharLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Character getValue() {
            return Character.valueOf(Float2CharLinkedOpenHashMap.this.value[this.index]);
        }

        @Override
        public char getCharValue() {
            return Float2CharLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public char setValue(char v) {
            char oldValue = Float2CharLinkedOpenHashMap.this.value[this.index];
            Float2CharLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Character setValue(Character v) {
            return Character.valueOf(this.setValue(v.charValue()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Float2CharLinkedOpenHashMap.this.key[this.index] == ((Float)e.getKey()).floatValue() && Float2CharLinkedOpenHashMap.this.value[this.index] == ((Character)e.getValue()).charValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(Float2CharLinkedOpenHashMap.this.key[this.index]) ^ Float2CharLinkedOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Float2CharLinkedOpenHashMap.this.key[this.index] + "->" + Float2CharLinkedOpenHashMap.this.value[this.index];
        }
    }
}

