/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.main;

import aQute.bnd.build.Project;
import aQute.bnd.differ.DiffImpl;
import aQute.bnd.differ.Element;
import aQute.bnd.differ.RepositoryElement;
import aQute.bnd.header.Attrs;
import aQute.bnd.main.DiffCommand;
import aQute.bnd.main.bnd;
import aQute.bnd.maven.support.MavenRemoteRepository;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Diff;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.lib.collections.MultiMap;
import aQute.lib.collections.SortedList;
import aQute.lib.deployer.FileRepo;
import aQute.lib.getopt.Arguments;
import aQute.lib.getopt.Description;
import aQute.lib.getopt.OptionArgument;
import aQute.lib.getopt.Options;
import aQute.lib.io.IO;
import aQute.lib.json.JSONCodec;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class RepoCommand {
    static final JSONCodec codec = new JSONCodec();
    final bnd bnd;
    final repoOptions opts;
    final RepositoryPlugin writable;
    final List<RepositoryPlugin> repos = new ArrayList<RepositoryPlugin>();

    public RepoCommand(bnd bnd2, repoOptions opts) throws Exception {
        this.opts = opts;
        this.bnd = bnd2;
        if (opts.maven()) {
            bnd2.trace("maven", new Object[0]);
            MavenRemoteRepository maven = new MavenRemoteRepository();
            maven.setProperties(new Attrs(new Attrs[0]));
            maven.setReporter(bnd2);
            this.repos.add(maven);
        }
        if (opts.repo() != null) {
            for (String r : opts.repo()) {
                bnd2.trace("file repo " + r, new Object[0]);
                FileRepo repo = new FileRepo();
                repo.setReporter(bnd2);
                File location = bnd2.getFile(r);
                repo.setLocation(location.getAbsolutePath());
                this.repos.add(repo);
            }
        }
        if (this.repos.isEmpty()) {
            bnd2.trace("getting project repos", new Object[0]);
            Project p = bnd2.getProject(opts.project());
            if (p != null) {
                this.repos.addAll(p.getWorkspace().getRepositories());
            }
        }
        bnd2.trace("repos " + this.repos, new Object[0]);
        RepositoryPlugin w = null;
        Iterator<RepositoryPlugin> rp = this.repos.iterator();
        while (rp.hasNext()) {
            RepositoryPlugin rpp = rp.next();
            if (!opts.cache() && rpp.getName().equals("cache")) {
                rp.remove();
            }
            if (w != null || !rpp.canWrite()) continue;
            w = rpp;
        }
        this.writable = w;
        bnd2.trace("writable " + w, new Object[0]);
        List<String> args = opts._();
        if (args.size() == 0) {
            this._repos(null);
        } else {
            String cmd = args.remove(0);
            String help = opts._command().execute(this, cmd, args);
            if (help != null) {
                bnd2.out.print(help);
            }
        }
    }

    @Description(value="List the current repositories")
    public void _repos(reposOptions opts) {
        int n = 1;
        for (RepositoryPlugin repo : this.repos) {
            String location = "";
            try {
                location = repo.getLocation();
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.bnd.out.printf("%03d: %-20s %4s %-20s %s%n", n++, repo.getName(), repo.canWrite() ? "r/w" : "r/o", Descriptors.getShortName(repo.getClass().getName()), location);
        }
    }

    @Description(value="List all artifacts from the current repositories with their versions")
    public void _list(listOptions opts) throws Exception {
        this.bnd.trace("list", new Object[0]);
        HashSet<String> bsns = new HashSet<String>();
        Instruction from = opts.from();
        if (from == null) {
            from = new Instruction("*");
        }
        for (RepositoryPlugin repo : this.repos) {
            if (!from.matches(repo.getName())) continue;
            bsns.addAll(repo.list(opts.query()));
        }
        this.bnd.trace("list " + bsns, new Object[0]);
        for (String bsn : new SortedList((Collection<Comparable<?>>)bsns)) {
            if (!opts.noversions()) {
                TreeSet<Version> versions = new TreeSet<Version>();
                for (RepositoryPlugin repo : this.repos) {
                    SortedSet<Version> result;
                    this.bnd.trace("get " + bsn + " from " + repo, new Object[0]);
                    if (!from.matches(repo.getName()) || (result = repo.versions(bsn)) == null) continue;
                    versions.addAll(result);
                }
                this.bnd.out.printf("%-40s %s%n", bsn, versions);
                continue;
            }
            this.bnd.out.printf("%s%n", bsn);
        }
    }

    @Description(value="Get an artifact from a repository.")
    public void _get(getOptions opts) throws Exception {
        List<String> args;
        Instruction from = opts.from();
        if (from == null) {
            from = new Instruction("*");
        }
        if ((args = opts._()).isEmpty()) {
            this.bnd.error("Get needs at least a bsn", new Object[0]);
            return;
        }
        String bsn = args.remove(0);
        String range = null;
        if (!args.isEmpty()) {
            range = args.remove(0);
            if (!args.isEmpty()) {
                this.bnd.error("Extra args %s", args);
            }
        }
        VersionRange r = new VersionRange(range == null ? "0" : range);
        HashMap<Version, RepositoryPlugin> index = new HashMap<Version, RepositoryPlugin>();
        for (RepositoryPlugin repo : this.repos) {
            SortedSet<Version> versions;
            if (!from.matches(repo.getName()) || (versions = repo.versions(bsn)) == null) continue;
            for (Version v : versions) {
                if (!r.includes(v)) continue;
                index.put(v, repo);
            }
        }
        SortedList l = new SortedList(index.keySet());
        if (l.isEmpty()) {
            this.bnd.out.printf("No versions found for %s%n", bsn);
            return;
        }
        Version v = opts.lowest() ? (Version)l.first() : (Version)l.last();
        RepositoryPlugin repo = (RepositoryPlugin)index.get(v);
        File file = repo.get(bsn, v, null, new RepositoryPlugin.DownloadListener[0]);
        File dir = this.bnd.getBase();
        String name = file.getName();
        if (opts.output() != null) {
            File f = this.bnd.getFile(opts.output());
            if (f.isDirectory()) {
                dir = f;
            } else {
                dir = f.getParentFile();
                name = f.getName();
            }
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Could not create directory " + dir);
        }
        IO.copy(file, new File(dir, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="Put an artifact into the repository after it has been verified.")
    public void _put(putOptions opts) throws Exception {
        if (this.writable == null) {
            this.bnd.error("No writable repository in %s", this.repos);
            return;
        }
        List<String> args = opts._();
        if (args.isEmpty()) {
            this.bnd.out.println("Writable repo is " + this.writable.getName() + " (" + this.writable.getLocation() + ")");
            return;
        }
        while (args.size() > 0) {
            File file = this.bnd.getFile(args.remove(0));
            if (!file.isFile()) {
                this.bnd.error("No such file %s", file);
                continue;
            }
            this.bnd.trace("put %s", file);
            Jar jar = new Jar(file);
            try {
                String bsn = jar.getBsn();
                if (bsn == null) {
                    this.bnd.error("File %s is not a bundle (it has no bsn) ", file);
                    return;
                }
                this.bnd.trace("bsn %s version %s", bsn, jar.getVersion());
                if (!opts.force()) {
                    Verifier v = new Verifier(jar);
                    v.setTrace(true);
                    v.setExceptions(true);
                    v.verify();
                    this.bnd.getInfo(v);
                }
                if (!this.bnd.isOk()) continue;
                RepositoryPlugin.PutResult r = this.writable.put(new BufferedInputStream(new FileInputStream(file)), new RepositoryPlugin.PutOptions());
                this.bnd.trace("put %s in %s (%s) into %s", file, this.writable.getName(), this.writable.getLocation(), r.artifact);
            }
            finally {
                jar.close();
            }
        }
    }

    @Description(value="Diff jars (or show tree)")
    public void _diff(diffOptions options) throws UnsupportedEncodingException, IOException, Exception {
        RepositoryPlugin rolder;
        List<String> _ = options._();
        String newer = _.remove(0);
        String older = _.size() > 0 ? _.remove(0) : null;
        RepositoryPlugin rnewer = this.findRepo(newer);
        RepositoryPlugin repositoryPlugin = rolder = older == null ? null : this.findRepo(older);
        if (rnewer == null) {
            this.bnd.messages.NoSuchRepository_(newer);
            return;
        }
        if (older != null && rolder == null) {
            this.bnd.messages.NoSuchRepository_(newer);
            return;
        }
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)this.bnd.out, "UTF-8"));
        Element tNewer = RepositoryElement.getTree(rnewer);
        if (rolder == null) {
            if (options.json()) {
                codec.enc().to(new OutputStreamWriter((OutputStream)this.bnd.out, "UTF-8")).put(tNewer.serialize()).flush();
            } else {
                DiffCommand.show(pw, tNewer, 0);
            }
        } else {
            Element tOlder = RepositoryElement.getTree(rolder);
            DiffImpl diff = new DiffImpl(tNewer, tOlder);
            MultiMap<String, String> map = new MultiMap<String, String>();
            for (Diff diff2 : diff.getChildren()) {
                for (Diff diff3 : diff2.getChildren()) {
                    if (diff3.getDelta() == Delta.UNCHANGED || !(!options.remove() && !options.added() || options.remove() && diff3.getDelta() == Delta.REMOVED) && (!options.added() || diff3.getDelta() != Delta.ADDED)) continue;
                    map.add(diff2.getName(), diff3.getName());
                }
            }
            if (options.json()) {
                codec.enc().to(new OutputStreamWriter((OutputStream)this.bnd.out, "UTF-8")).put(map).flush();
            } else if (!options.diff()) {
                this.bnd.printMultiMap(map);
            } else {
                DiffCommand.show(pw, diff, 0, !options.full());
            }
        }
        pw.flush();
    }

    private RepositoryPlugin findRepo(String name) {
        for (RepositoryPlugin repo : this.repos) {
            if (!repo.getName().equals(name)) continue;
            return repo;
        }
        return null;
    }

    @Description(value="Refresh refreshable repositories")
    public void _refresh(RefreshOptions opts) throws Exception {
        for (RepositoryPlugin o : this.repos) {
            if (!(o instanceof Refreshable)) continue;
            this.bnd.trace("refresh %s", o);
            ((Refreshable)((Object)o)).refresh();
        }
    }

    @Description(value="Displays a list of versions for a given bsn that can be found in the current repositories.")
    public void _versions(VersionsOptions opts) throws Exception {
        TreeSet<Version> versions = new TreeSet<Version>();
        String bsn = opts._().remove(0);
        for (RepositoryPlugin repo : this.repos) {
            versions.addAll(repo.versions(bsn));
        }
        this.bnd.out.println(versions);
    }

    @Description(value="Displays a sorted set of versions for a given bsn that can be found in the current repositories.")
    @Arguments(arg={"bsn"})
    static interface VersionsOptions
    extends Options {
    }

    @Description(value="Refresh refreshable repositories")
    @Arguments(arg={})
    static interface RefreshOptions
    extends Options {
    }

    @Arguments(arg={"newer repo", "[older repo]"})
    @Description(value="Show the diff tree of a single repo or compare 2  repos. A diff tree is a detailed tree of all aspects of a bundle, including its packages, types, methods, fields, and modifiers.")
    static interface diffOptions
    extends Options {
        @Description(value="Serialize to JSON")
        public boolean json();

        @Description(value="Show full diff tree (also wen entries are equal)")
        public boolean full();

        @Description(value="Formatted like diff")
        public boolean diff();

        @Description(value="Both add and removes")
        public boolean all();

        @Description(value="Just removes (no additions)")
        public boolean remove();

        @Description(value="Just additions (no removes)")
        public boolean added();
    }

    @Description(value="Put an artifact into the repository after it has been verified.")
    @Arguments(arg={"<jar>..."})
    static interface putOptions
    extends Options {
        @Description(value="Put in repository even if verification fails (actually, no verification is done).")
        public boolean force();
    }

    @Description(value="Get an artifact from a repository.")
    @Arguments(arg={"bsn", "[range]"})
    static interface getOptions
    extends Options {
        @Description(value="Where to store the artifact")
        public String output();

        @Description(value="")
        public boolean lowest();

        public Instruction from();
    }

    @Description(value="List all artifacts from the current repositories with their versions")
    @Arguments(arg={})
    static interface listOptions
    extends Options {
        @Description(value="Do not list the versions, just the bsns")
        public boolean noversions();

        @Description(value="Optional search term for the list of bsns (given to the repo)")
        public String query();

        @Description(value="A glob expression on the source repo, default is all repos")
        public Instruction from();
    }

    @Arguments(arg={})
    @Description(value="List the current repositories")
    static interface reposOptions
    extends Options {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Description(value="Access to the repositories. Provides a number of sub commands to manipulate the repository (see repo help) that provide access to the installed repos for the current project.")
    @Arguments(arg={"sub-cmd", "..."})
    static interface repoOptions
    extends Options {
        @Description(value="Add a File Repository")
        public Collection<String> repo();

        @Description(value="Include the maven repository")
        public boolean maven();

        @Description(value="Specify a project")
        @OptionArgument(value="<path>")
        public String project();

        @Description(value="Include the cache repository")
        public boolean cache();
    }
}

