/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.main;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectTester;
import aQute.bnd.build.Workspace;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.help.Syntax;
import aQute.bnd.main.BaselineCommands;
import aQute.bnd.main.BndMessages;
import aQute.bnd.main.DiffCommand;
import aQute.bnd.main.PatchCommand;
import aQute.bnd.main.RepoCommand;
import aQute.bnd.maven.MavenCommand;
import aQute.bnd.maven.PomFromManifest;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Constants;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.Packages;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.osgi.eclipse.EclipseClasspath;
import aQute.bnd.service.action.Action;
import aQute.bnd.version.Version;
import aQute.configurable.Config;
import aQute.lib.base64.Base64;
import aQute.lib.collections.ExtList;
import aQute.lib.collections.MultiMap;
import aQute.lib.collections.SortedList;
import aQute.lib.filter.Filter;
import aQute.lib.getopt.Arguments;
import aQute.lib.getopt.CommandLine;
import aQute.lib.getopt.Description;
import aQute.lib.getopt.Options;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.lib.justif.Justif;
import aQute.lib.settings.Settings;
import aQute.lib.tag.Tag;
import aQute.libg.classdump.ClassDumper;
import aQute.libg.cryptography.MD5;
import aQute.libg.cryptography.SHA1;
import aQute.libg.generics.Create;
import aQute.libg.glob.Glob;
import aQute.libg.qtokens.QuotedTokenizer;
import aQute.libg.reporter.ReporterAdapter;
import aQute.libg.reporter.ReporterMessages;
import aQute.libg.sed.Sed;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class bnd
extends Processor {
    static Pattern ASSIGNMENT = Pattern.compile("\\s*([-\\w\\d_.]+)\\s*(?:=\\s*([^\\s]+)\\s*)?");
    Settings settings = new Settings();
    final PrintStream err = System.err;
    public final PrintStream out = System.out;
    Justif justif = new Justif(80, 40, 42, 70);
    BndMessages messages = ReporterMessages.base(this, BndMessages.class);
    static Pattern JARCOMMANDS = Pattern.compile("(cv?0?(m|M)?f?)|(uv?0?M?f?)|(xv?f?)|(tv?f?)|(i)");
    static Pattern COMMAND = Pattern.compile("\\w[\\w\\d]+");
    static final int BUILD_SOURCES = 1;
    static final int BUILD_POM = 2;
    static final int BUILD_FORCE = 4;
    static final int VERIFY = 1;
    static final int MANIFEST = 2;
    static final int LIST = 4;
    static final int IMPEXP = 16;
    static final int USES = 32;
    static final int USEDBY = 64;
    static final int COMPONENT = 128;
    static final int METATYPE = 256;
    static final int API = 512;
    static final int HEX = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        bnd main = new bnd();
        try {
            main.start(args);
        }
        finally {
            main.close();
        }
    }

    public void start(String[] args) throws Exception {
        CommandLine cl = new CommandLine(this);
        String help = cl.execute(this, "bnd", new ExtList<String>(args));
        this.check(new String[0]);
        if (help != null) {
            this.err.println(help);
        }
    }

    private void rewrite(List<String> args) throws Exception {
        Action a;
        if (args.isEmpty()) {
            return;
        }
        String arg = args.get(0);
        if (arg.equals("maven")) {
            args.add(0, "maven");
            return;
        }
        Matcher m = JARCOMMANDS.matcher(arg);
        if (m.matches()) {
            this.rewriteJarCmd(args);
            return;
        }
        Project project = this.getProject();
        if (project != null && (a = project.getActions().get(arg)) != null) {
            args.add(0, "project");
        }
        if (!(m = COMMAND.matcher(args.get(0))).matches()) {
            args.add(0, "do");
        }
    }

    private void rewriteJarCmd(List<String> args) {
        String jarcmd = args.remove(0);
        char cmd = jarcmd.charAt(0);
        switch (cmd) {
            case 'c': {
                args.add(0, "create");
                break;
            }
            case 'u': {
                args.add(0, "update");
                break;
            }
            case 'x': {
                args.add(0, "extract");
                break;
            }
            case 't': {
                args.add(0, "type");
                break;
            }
            case 'i': {
                args.add(0, "index");
            }
        }
        int start = 1;
        block14: for (int i = 1; i < jarcmd.length(); ++i) {
            switch (jarcmd.charAt(i)) {
                case 'v': {
                    args.add(start++, "--verbose");
                    continue block14;
                }
                case '0': {
                    args.add(start++, "--nocompression");
                    continue block14;
                }
                case 'm': {
                    args.add(start++, "--manifest");
                    ++start;
                    continue block14;
                }
                case 'M': {
                    args.add(start++, "--nomanifest");
                    continue block14;
                }
                case 'f': {
                    args.add(start++, "--file");
                }
            }
        }
    }

    @Description(value="The swiss army tool for OSGi")
    public void _bnd(bndOptions options) throws Exception {
        try {
            this.set("-failok", options.failok() + "");
            this.setExceptions(options.exceptions());
            this.setTrace(options.trace());
            this.setPedantic(options.pedantic());
            if (options.base() != null) {
                this.setBase(bnd.getFile(this.getBase(), options.base()));
            }
            for (Map.Entry<String, String> entry : options._properties().entrySet()) {
                this.setProperty(entry.getKey(), entry.getValue());
            }
            CommandLine handler = options._command();
            List<String> arguments = options._();
            this.rewrite(arguments);
            this.trace("rewritten %s", arguments);
            if (arguments.isEmpty()) {
                Justif f = new Justif(80, 20, 22, 72);
                handler.help(f.formatter(), this);
                this.err.append(f.wrap());
            } else {
                String cmd = arguments.remove(0);
                String help = handler.execute(this, cmd, arguments);
                if (help != null) {
                    this.err.println(help);
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            this.exception(t, "%s", t.getMessage());
        }
        this.out.flush();
        this.err.flush();
        if (!this.check(options.ignore())) {
            System.err.flush();
            System.err.flush();
            Thread.sleep(1000L);
            System.exit(this.getErrors().size());
        }
    }

    @Description(value="Create jar, used to support backward compatible java jar commands")
    public void _create(createOptions options) throws Exception {
        Jar jar = new Jar("dot");
        File dir = this.getBase().getAbsoluteFile();
        String sdir = options.Cdir();
        if (sdir != null) {
            dir = this.getFile(sdir);
        }
        if (options._().isEmpty()) {
            this.add(jar, dir, ".", options.verbose());
        } else {
            for (String f : options._()) {
                f = f.replace(File.separatorChar, '/');
                this.add(jar, dir, f, options.verbose());
            }
        }
        String manifest = options.manifest();
        if (manifest != null) {
            if (options.verbose()) {
                this.err.printf("Adding manifest from %s\n", manifest);
            }
            jar.setManifest(this.getFile(manifest));
        }
        if (options.Manifest()) {
            jar.setManifest((Manifest)null);
        } else if (options.wrap()) {
            Analyzer w = new Analyzer(this);
            this.addClose(w);
            w.setBase(this.getBase());
            w.use(this);
            w.setDefaults(options.bsn(), options.version());
            w.calcManifest();
            this.getInfo(w);
            w.setJar((Jar)null);
            w.close();
        }
        if (options.nocompression()) {
            jar.setCompression(Jar.Compression.STORE);
        }
        if (this.isOk()) {
            String jarFile = options.file();
            if (jarFile == null) {
                jar.write(System.out);
            } else {
                jar.write(jarFile);
            }
        }
        jar.close();
    }

    private void add(Jar jar, File base, String path, boolean report) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        File f = path.equals(".") ? base : bnd.getFile(base, path);
        this.err.printf("Adding: %s\n", path);
        if (f.isFile()) {
            jar.putResource(path, new FileResource(f));
        } else if (f.isDirectory()) {
            String[] subs;
            path = path.equals(".") ? "" : path + "/";
            for (String sub : subs = f.list()) {
                this.add(jar, base, path + sub, report);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="Extract files from a JAR file, equivalent jar command x[vf] (syntax supported)")
    public void _extract(extractOptions opts) throws Exception {
        Jar jar;
        if (opts.file() != null) {
            File f = this.getFile(opts.file());
            if (!f.isFile()) {
                this.messages.NoSuchFile_(f);
                return;
            }
            jar = new Jar(f);
        } else {
            jar = new Jar("cin", System.in);
        }
        try {
            Instructions instructions = new Instructions(opts._());
            Collection<String> selected = instructions.select(jar.getResources().keySet(), true);
            File store = this.getBase();
            if (opts.CDir() != null) {
                store = this.getFile(opts.CDir());
            }
            if (!store.exists() && !store.mkdirs()) {
                throw new IOException("Could not create directory " + store);
            }
            Jar.Compression compression = jar.hasCompression();
            for (String path : selected) {
                File f;
                File pf;
                if (opts.verbose()) {
                    System.err.printf("%8s: %s\n", ((Object)((Object)compression)).toString().toLowerCase(), path);
                }
                if (!(pf = (f = bnd.getFile(store, path)).getParentFile()).exists() && !pf.mkdirs()) {
                    throw new IOException("Could not create directory " + pf);
                }
                Resource r = jar.getResource(path);
                IO.copy(r.openInputStream(), f);
            }
        }
        finally {
            jar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="List files int a JAR file, equivalent jar command t[vf] (syntax supported)")
    public void _type(typeOptions opts) throws Exception {
        Jar jar;
        if (opts.file() != null) {
            File f = this.getFile(opts.file());
            if (!f.isFile()) {
                this.messages.NoSuchFile_(f);
                return;
            }
            jar = new Jar(f);
        } else {
            jar = new Jar("cin", System.in);
        }
        try {
            Instructions instructions = new Instructions(opts._());
            Collection<String> selected = instructions.select(jar.getResources().keySet(), true);
            for (String path : selected) {
                if (opts.verbose()) {
                    Resource r = jar.getResource(path);
                    this.err.printf("%8s %-32s %s\n", r.size(), new Date(r.lastModified()), path);
                    continue;
                }
                this.err.printf("%s\n", path);
            }
        }
        finally {
            jar.close();
        }
    }

    @Description(value="Execute a file based on its extension. Supported extensions are: bnd (build), bndrun (run), and jar (print)")
    public void _do(dooptions options) throws Exception {
        for (String path : options._()) {
            if (path.endsWith(".bnd")) {
                Builder b = new Builder();
                b.setTrace(this.isTrace());
                b.setPedantic(this.isPedantic());
                File f = this.getFile(path);
                b.setProperties(f);
                b.build();
                File out = b.getOutputFile(options.output());
                this.getInfo(b, f.getName() + ": ");
                if (this.isOk()) {
                    b.save(out, options.force());
                }
                this.getInfo(b, f.getName() + ": ");
                if (!this.isOk()) {
                    out.delete();
                }
                b.close();
                continue;
            }
            if (path.endsWith(".jar") || path.endsWith(".bar")) {
                Jar jar = this.getJar(path);
                this.doPrint(jar, 2, null);
                continue;
            }
            if (path.endsWith(".bndrun")) {
                this.doRun(path);
                continue;
            }
            this.messages.UnrecognizedFileType_(path);
        }
    }

    @Description(value="Execute a Project action, or if no parms given, show information about the project")
    public void _project(projectOptions options) throws Exception {
        Project project = this.getProject(options.project());
        if (project == null) {
            this.messages.NoProject();
            return;
        }
        ArrayList<String> l = new ArrayList<String>(options._());
        if (l.isEmpty()) {
            this.err.printf("Name         %s\n", project.getName());
            this.err.printf("Actions      %s\n", project.getActions().keySet());
            this.err.printf("Directory    %s\n", project.getBase());
            this.err.printf("Depends on   %s\n", project.getDependson());
            this.err.printf("Sub builders %s\n", project.getSubBuilders());
            return;
        }
        String cmd = null;
        String arg = null;
        if (!l.isEmpty()) {
            cmd = (String)l.remove(0);
        }
        if (!l.isEmpty()) {
            arg = (String)l.remove(0);
        }
        if (!l.isEmpty()) {
            this.messages.MoreArgumentsThanNeeded_(options._());
            return;
        }
        if (cmd == null) {
            this.messages.NoCommandForProject(project);
            return;
        }
        Action a = project.getActions().get(cmd);
        if (a != null) {
            a.execute(project, arg);
            this.getInfo(project);
            return;
        }
    }

    @Description(value="Bumps the version of a project")
    public void _bump(bumpoptions options) throws Exception {
        Project project = this.getProject(options.project());
        if (project == null) {
            this.messages.NoProject();
            return;
        }
        String mask = null;
        if (!options._().isEmpty()) {
            mask = options._().get(0);
            if (mask.equalsIgnoreCase("major")) {
                mask = "+00";
            } else if (mask.equalsIgnoreCase("minor")) {
                mask = "=+0";
            } else if (mask.equalsIgnoreCase("micro")) {
                mask = "==+";
            } else if (!mask.matches("[+=0]{1,3}")) {
                this.messages.InvalidBumpMask_(mask);
                return;
            }
        }
        if (mask == null) {
            project.bump();
        } else {
            project.bump(mask);
        }
        this.getInfo(project);
        this.err.println(project.getProperty("Bundle-Version", "No version found"));
    }

    @Description(value="Build a project. This will create the jars defined in the bnd.bnd and sub-builders.")
    public void _build(buildoptions opts) throws Exception {
        Project project = this.getProject(opts.project());
        if (project == null) {
            this.messages.NoProject();
            return;
        }
        project.build(opts.test());
    }

    @Description(value="Test a project according to an OSGi test")
    public void _test(testOptions opts) throws Exception {
        Project project = this.getProject(opts.project());
        if (project == null) {
            this.messages.NoProject();
            return;
        }
        project.test();
    }

    @Description(value="Run a project in the OSGi launcher")
    public void _run(runOptions opts) throws Exception {
        Project project = this.getProject(opts.project());
        if (project == null) {
            this.messages.NoProject();
            return;
        }
        project.run();
    }

    @Description(value="Clean a project")
    public void _clean(cleanOptions opts) throws Exception {
        Project project = this.getProject(opts.project());
        if (project == null) {
            this.messages.NoProject();
            return;
        }
        project.clean();
    }

    @Description(value="Access the internal bnd database of keywords and options")
    public void _syntax(syntaxOptions opts) throws Exception {
        int w = opts.width() < 80 ? 120 : opts.width();
        Justif justif = new Justif(w, opts.width(), 40, 42, w - 10);
        List<String> args = opts._();
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        for (String s : args) {
            f.format(" \n[%s]\n", s);
            Syntax sx = Syntax.HELP.get(s);
            if (s == null) {
                f.format("Unknown", new Object[0]);
                continue;
            }
            this.print(f, sx, "  ");
        }
        f.flush();
        justif.wrap(sb);
        this.err.println(sb);
    }

    private void print(Formatter f, Syntax sx, String indent) {
        if (sx == null) {
            return;
        }
        f.format("%s%s\n\n", indent, sx.getLead());
        if (sx.getValues() != null) {
            f.format("%sValues\t1:\t2%s\n", indent, sx.getValues());
        }
        if (sx.getPattern() != null) {
            f.format("%sPattern  \t1:\t2%s\n", indent, sx.getPattern());
        }
        if (sx.getExample() != null) {
            f.format("%sExample  \t1:\t2%s\n", indent, sx.getExample());
        }
        if (sx.getChildren() != null) {
            for (Syntax child : sx.getChildren()) {
                f.format("\n%s[%s]\t1:\t2", indent, child.getHeader());
                this.print(f, child, indent + "  ");
            }
        }
    }

    private void doRun(String path) throws Exception {
        File file = this.getFile(path);
        if (!file.isFile()) {
            throw new FileNotFoundException(path);
        }
        File projectDir = file.getParentFile();
        File workspaceDir = projectDir.getParentFile();
        if (workspaceDir == null) {
            workspaceDir = new File(System.getProperty("user.home") + File.separator + ".bnd");
        }
        Workspace ws = Workspace.getWorkspace(workspaceDir);
        Project project = new Project(ws, projectDir, file);
        project.setTrace(this.isTrace());
        project.setPedantic(this.isPedantic());
        try {
            project.run();
        }
        catch (Exception e) {
            this.messages.Project_RunFailed_(project, e);
        }
        this.getInfo(project);
    }

    @Description(value="Package a bnd or bndrun file into a single jar that executes with java -jar <>.jar")
    public void _package(packageOptions opts) throws Exception {
        String profile;
        Project project = this.getProject();
        if (project == null) {
            this.error("Packaging only works inside a project directory (needs bnd.bnd file)", new Object[0]);
            return;
        }
        List<String> cmdline = opts._();
        File output = null;
        output = opts.output() != null ? this.getFile(opts.output()) : this.getBase();
        if (opts._().size() > 1) {
            if (!output.exists() && !output.mkdirs()) {
                throw new IOException("Could not create directory " + output);
            }
        } else {
            File pf = output.getParentFile();
            if (!pf.exists() && !pf.mkdirs()) {
                throw new IOException("Could not create directory " + pf);
            }
        }
        String string = profile = opts.profile() == null ? "exec" : opts.profile();
        if (opts.jpm()) {
            project.setProperty("-package", "jpm");
        }
        project.build();
        if (cmdline.isEmpty()) {
            cmdline.add("bnd.bnd");
        }
        for (String path : cmdline) {
            File file = this.getFile(path);
            if (!file.isFile()) {
                this.messages.NoSuchFile_(file);
                continue;
            }
            Workspace ws = project.getWorkspace();
            project = new Project(ws, this.getBase(), file);
            project.setProperty("-profile", profile);
            project.use(this);
            if (opts.jpm()) {
                project.setProperty("-package", "jpm");
            }
            try {
                Jar jar = project.pack(profile);
                path = path.replaceAll(".bnd(run)?$", "") + ".jar";
                File out = output;
                if (output.isDirectory()) {
                    out = new File(output, path);
                }
                jar.write(out);
                jar.close();
            }
            catch (Exception e) {
                this.messages.ForProject_File_FailedToCreateExecutableException_(project, path, e);
            }
            this.getInfo(project);
        }
    }

    @Description(value="Show all deliverables from this workspace. with their current version and path.")
    public void _deliverables(deliverableOptions options) throws Exception {
        Project project = this.getProject(options.project());
        if (project == null) {
            this.messages.NoProject();
            return;
        }
        Collection<Project> projects = options.limit() ? Arrays.asList(project) : project.getWorkspace().getAllProjects();
        ArrayList<Container> containers = new ArrayList<Container>();
        for (Project p : projects) {
            containers.addAll(p.getDeliverables());
        }
        for (Container c : containers) {
            Version v = new Version(c.getVersion());
            this.err.printf("%-40s %8s  %s\n", c.getBundleSymbolicName(), v.getWithoutQualifier(), c.getFile());
        }
        this.getInfo(project);
    }

    @Description(value="Show macro value")
    public void _macro(macroOptions options) throws Exception {
        Project project = this.getProject(options.project());
        if (project == null) {
            this.messages.NoProject();
            return;
        }
        StringBuilder sb = new StringBuilder();
        Macro r = project.getReplacer();
        this.getInfo(project);
        String del = "";
        for (String s : options._()) {
            if (!s.startsWith("${")) {
                s = "${" + s;
            }
            if (!s.endsWith("}")) {
                s = s + "}";
            }
            s = s.replace(':', ';');
            String p = r.process(s);
            sb.append(del);
            sb.append(p);
            del = " ";
        }
        this.getInfo(project);
        this.err.println(sb);
    }

    @Description(value="Release this project")
    public void _release(releaseOptions options) throws Exception {
        Project project = this.getProject(options.project());
        if (project == null) {
            return;
        }
        project.release(options.test());
        this.getInfo(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="Show a cross references for all classes in a set of jars.")
    public void _xref(xrefOptions options) throws IOException, Exception {
        Analyzer analyzer = new Analyzer();
        MultiMap<Descriptors.TypeRef, Descriptors.TypeRef> table = new MultiMap<Descriptors.TypeRef, Descriptors.TypeRef>();
        MultiMap<Descriptors.PackageRef, Descriptors.PackageRef> packages = new MultiMap<Descriptors.PackageRef, Descriptors.PackageRef>();
        Set set = Create.set();
        Instructions filter = new Instructions(options.match());
        for (String arg : options._()) {
            try {
                File file = new File(arg);
                Jar jar = new Jar(file.getName(), file);
                try {
                    for (Map.Entry<String, Resource> entry : jar.getResources().entrySet()) {
                        Descriptors.TypeRef ref;
                        String key = entry.getKey();
                        Resource r = entry.getValue();
                        if (!key.endsWith(".class") || !filter.matches((ref = analyzer.getTypeRefFromPath(key)).toString())) continue;
                        set.add(ref);
                        InputStream in = r.openInputStream();
                        Clazz clazz = new Clazz(analyzer, key, r);
                        Set<Descriptors.TypeRef> s = clazz.parseClassFile();
                        Iterator<Descriptors.TypeRef> t = s.iterator();
                        while (t.hasNext()) {
                            Descriptors.TypeRef tr = t.next();
                            if (tr.isJava() || tr.isPrimitive()) {
                                t.remove();
                                continue;
                            }
                            packages.add(ref.getPackageRef(), tr.getPackageRef());
                        }
                        table.addAll(ref, s);
                        set.addAll(s);
                        in.close();
                    }
                }
                finally {
                    jar.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean to = options.to();
        boolean from = options.from();
        if (!to && !from) {
            from = true;
            to = true;
        }
        if (options.classes()) {
            if (to) {
                this.printxref(table, ">");
            }
            if (from) {
                this.printxref(table.transpose(), "<");
            }
        } else {
            if (to) {
                this.printxref(packages, ">");
            }
            if (from) {
                this.printxref(packages.transpose(), "<");
            }
        }
    }

    private void printxref(MultiMap<?, ?> map, String direction) {
        SortedList labels = new SortedList(map.keySet());
        for (Object element : labels) {
            List e = (List)map.get(element);
            if (e == null) continue;
            HashSet set = new HashSet(e);
            set.remove(element);
            Iterator row = set.iterator();
            String first = "";
            if (row.hasNext()) {
                first = row.next().toString();
            }
            this.err.printf("%50s %s %s\n", element, direction, first);
            while (row.hasNext()) {
                this.err.printf("%50s   %s\n", "", row.next());
            }
        }
    }

    @Description(value="Show info about the current directory's eclipse project")
    public void _eclipse(eclipseOptions options) throws Exception {
        File dir = this.getBase();
        if (options.dir() != null) {
            dir = this.getFile(options.dir());
        }
        if (!dir.isDirectory()) {
            this.error("Eclipse requires a path to a directory: " + dir.getAbsolutePath(), new Object[0]);
        }
        if (options._().size() != 0) {
            this.error("Unnecessary arguments %s", options._());
        }
        if (!this.isOk()) {
            return;
        }
        File cp = new File(dir, ".classpath");
        if (!cp.exists()) {
            this.error("Cannot find .classpath in project directory: " + dir.getAbsolutePath(), new Object[0]);
        } else {
            EclipseClasspath eclipse = new EclipseClasspath(this, dir.getParentFile(), dir);
            this.err.println("Classpath    " + eclipse.getClasspath());
            this.err.println("Dependents   " + eclipse.getDependents());
            this.err.println("Sourcepath   " + eclipse.getSourcepath());
            this.err.println("Output       " + eclipse.getOutput());
            this.err.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="Build project, is deprecated but here for backward compatibility")
    public void _buildx(buildxOptions options) throws Exception {
        ArrayList<Builder> builders = new ArrayList<Builder>();
        ArrayList<String> order = new ArrayList<String>();
        ArrayList<String> active = new ArrayList<String>();
        for (String s : options._()) {
            this.prebuild(active, order, builders, s);
        }
        for (Builder b : builders) {
            if (options.classpath() != null) {
                for (String f : options.classpath()) {
                    b.addClasspath(this.getFile(f));
                }
            }
            if (options.sourcepath() != null) {
                for (String f : options.sourcepath()) {
                    b.addSourcepath(this.getFile(f));
                }
            }
            if (options.sources()) {
                b.setSources(true);
            }
            if (options.eclipse()) {
                EclipseClasspath ep = new EclipseClasspath(this, this.getBase().getParentFile(), this.getBase());
                b.addClasspath(ep.getClasspath());
                b.addClasspath(ep.getBootclasspath());
                b.addSourcepath(ep.getSourcepath());
            }
            Jar jar = b.build();
            File outputFile = b.getOutputFile(options.output());
            if (options.pom()) {
                PomFromManifest r = new PomFromManifest(jar.getManifest());
                jar.putResource("pom.xml", r);
                String path = outputFile.getName().replaceAll("\\.jar$", ".pom");
                if (path.equals(outputFile.getName())) {
                    path = outputFile.getName() + ".pom";
                }
                File pom = new File(outputFile.getParentFile(), path);
                FileOutputStream out = new FileOutputStream(pom);
                try {
                    r.write(out);
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            this.getInfo(b, b.getPropertiesFile().getName());
            if (this.isOk()) {
                b.save(outputFile, options.force());
            }
            b.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prebuild(List<String> set, List<String> order, List<Builder> builders, String s) throws IOException {
        if (order.contains(s)) {
            return;
        }
        if (set.contains(s)) {
            this.error("Cyclic -prebuild dependency %s from %s", s, set);
        }
        Builder b = new Builder(this);
        b.setProperties(this.getFile(s));
        String prebuild = b.get("prebuild");
        if (prebuild != null) {
            set.add(s);
            try {
                Collection<String> parts = bnd.split(prebuild);
                for (String p : parts) {
                    this.prebuild(set, order, builders, p);
                }
            }
            finally {
                set.remove(s);
            }
        }
        order.add(s);
        builders.add(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="View a resource from a JAR file.")
    public void _view(viewOptions options) throws Exception {
        String charset = "UTF-8";
        if (options.charset() != null) {
            charset = options.charset();
        }
        if (options._().isEmpty()) {
            this.error("Need a jarfile as source", new Object[0]);
            return;
        }
        List<String> args = options._();
        File file = this.getFile(args.remove(0));
        if (!file.isFile()) {
            this.error("File does not exist %s", file);
            return;
        }
        Jar jar = new Jar(file);
        try {
            if (args.isEmpty()) {
                args.add("*");
            }
            Instructions instructions = new Instructions(args);
            Collection<String> selected = instructions.select(jar.getResources().keySet(), true);
            for (String selection : selected) {
                Resource r = jar.getResource(selection);
                if (selection.endsWith(".MF")) {
                    Manifest m = new Manifest(r.openInputStream());
                    this.printManifest(m);
                    continue;
                }
                if (selection.endsWith(".class")) {
                    ClassDumper clsd = new ClassDumper(selection, r.openInputStream());
                    clsd.dump(this.err);
                    continue;
                }
                InputStreamReader isr = new InputStreamReader(r.openInputStream(), charset);
                IO.copy((Reader)isr, (OutputStream)this.err);
            }
        }
        finally {
            jar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="Wrap a jar")
    public void _wrap(wrapOptions options) throws Exception {
        List<File> classpath = Create.list();
        File properties = this.getBase();
        if (options.properties() != null) {
            properties = this.getFile(options.properties());
        }
        if (options.classpath() != null) {
            for (String cp : options.classpath()) {
                classpath.add(this.getFile(cp));
            }
        }
        for (String j : options._()) {
            File file = this.getFile(j);
            if (!file.isFile()) {
                this.error("File does not exist %s", file);
                continue;
            }
            Analyzer wrapper = new Analyzer(this);
            try {
                File p;
                wrapper.use(this);
                this.addClose(wrapper);
                for (File f : classpath) {
                    wrapper.addClasspath(f);
                }
                wrapper.setJar(file);
                File outputFile = wrapper.getOutputFile(options.output());
                if (((Object)outputFile.getCanonicalFile()).equals(file.getCanonicalFile())) {
                    this.error("Output file %s and source file %s are the same file, they must be different", outputFile, file);
                    return;
                }
                outputFile.delete();
                String stem = file.getName();
                if (stem.endsWith(".jar")) {
                    stem = stem.substring(0, stem.length() - 4) + ".bnd";
                }
                if ((p = this.getPropertiesFile(properties, file, stem)) == null) {
                    wrapper.setImportPackage("*;resolution:=optional");
                    wrapper.setExportPackage("*");
                    this.warning("Using defaults for wrap, which means no export versions", new Object[0]);
                } else if (p.isFile()) {
                    wrapper.setProperties(p);
                } else {
                    this.error("No valid property file: %s", p);
                }
                if (options.bsn() != null) {
                    wrapper.setBundleSymbolicName(options.bsn());
                }
                if (options.version() != null) {
                    wrapper.setBundleVersion(options.version());
                }
                Manifest m = wrapper.calcManifest();
                if (wrapper.isOk()) {
                    wrapper.getJar().setManifest(m);
                    wrapper.save(outputFile, options.force());
                }
                this.getInfo(wrapper, ((Object)file).toString());
            }
            finally {
                wrapper.close();
            }
        }
    }

    private File getPropertiesFile(File properties, File file, String stem) {
        if (properties.isFile()) {
            return properties;
        }
        File p = bnd.getFile(file.getParentFile(), stem);
        if (p.isFile()) {
            return p;
        }
        if (properties.isDirectory() && (p = bnd.getFile(properties, stem)).isFile()) {
            return p;
        }
        return null;
    }

    @Description(value="Show a lot of info about the project you're in")
    public void _debug(debugOptions options) throws Exception {
        MultiMap<String, Object> table;
        Project project = this.getProject(options.project());
        Processor target = project;
        if (project != null) {
            this.getInfo(project.getWorkspace());
            table = new MultiMap<String, Object>();
            table.add("Workspace", project.getWorkspace().toString());
            table.addAll("Plugins", project.getPlugins(Object.class));
            table.addAll("Repos", project.getWorkspace().getRepositories());
            this.printxref(table, "|");
        } else {
            this.err.println("No project");
        }
        target = this;
        table = new MultiMap();
        for (String key : target) {
            String s = target.get(key);
            Collection<String> set = bnd.split(s);
            table.addAll(key, set);
        }
        this.printxref(table, "|");
    }

    @Description(value="Manage the repositories")
    public void _repo(RepoCommand.repoOptions opts) throws Exception {
        new RepoCommand(this, opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="Printout the JAR")
    public void _print(printOptions options) throws Exception {
        for (String s : options._()) {
            int opts = 0;
            if (options.verify()) {
                opts |= 1;
            }
            if (options.manifest()) {
                opts |= 2;
            }
            if (options.api()) {
                opts |= 0x200;
            }
            if (options.list()) {
                opts |= 4;
            }
            if (options.impexp()) {
                opts |= 0x10;
            }
            if (options.uses()) {
                opts |= 0x20;
            }
            if (options.by()) {
                opts |= 0x40;
            }
            if (options.component()) {
                opts |= 0x80;
            }
            if (options.typemeta()) {
                opts |= 0x100;
            }
            if (opts == 0) {
                opts = 18;
            }
            Jar jar = this.getJar(s);
            try {
                this.doPrint(jar, opts, options);
            }
            finally {
                jar.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPrint(Jar jar, int options, printOptions po) throws ZipException, IOException, Exception {
        block34: {
            try {
                Map<String, Attrs> exports;
                if ((options & 1) != 0) {
                    Verifier verifier = new Verifier(jar);
                    verifier.setPedantic(this.isPedantic());
                    verifier.verify();
                    this.getInfo(verifier);
                }
                if ((options & 2) != 0) {
                    Manifest manifest = jar.getManifest();
                    if (manifest == null) {
                        this.warning("JAR has no manifest " + jar, new Object[0]);
                    } else {
                        this.err.println("[MANIFEST " + jar.getName() + "]");
                        this.printManifest(manifest);
                    }
                    this.out.println();
                }
                if ((options & 0x10) != 0) {
                    this.out.println("[IMPEXP]");
                    Manifest m = jar.getManifest();
                    Domain domain = Domain.domain(m);
                    if (m != null) {
                        Parameters imports = domain.getImportPackage();
                        exports = domain.getExportPackage();
                        for (String p : ((Parameters)exports).keySet()) {
                            Attrs attrs;
                            if (!imports.containsKey(p) || !(attrs = imports.get(p)).containsKey("version")) continue;
                            ((Parameters)exports).get(p).put("imported-as", attrs.get("version"));
                        }
                        this.print("Import-Package", new TreeMap<String, Attrs>(imports));
                        this.print("Export-Package", new TreeMap<String, Attrs>(exports));
                    } else {
                        this.warning("File has no manifest", new Object[0]);
                    }
                }
                if ((options & 0x260) != 0) {
                    this.out.println();
                    Analyzer analyzer = new Analyzer();
                    try {
                        String s;
                        analyzer.setPedantic(this.isPedantic());
                        analyzer.setJar(jar);
                        Manifest m = jar.getManifest();
                        if (m != null && (s = m.getMainAttributes().getValue("Export-Package")) != null) {
                            analyzer.setExportPackage(s);
                        }
                        analyzer.analyze();
                        boolean java = po.java();
                        exports = analyzer.getExports();
                        if ((options & 0x200) != 0) {
                            Map<Descriptors.PackageRef, List<Descriptors.PackageRef>> apiUses = analyzer.cleanupUses(analyzer.getAPIUses(), !po.java());
                            if (!po.xport()) {
                                if (((Packages)exports).isEmpty()) {
                                    this.warning("Not filtering on exported only since exports are empty", new Object[0]);
                                } else {
                                    apiUses.keySet().retainAll(analyzer.getExports().keySet());
                                }
                            }
                            this.out.println("[API USES]");
                            this.printMultiMap(apiUses);
                            Set<Descriptors.PackageRef> privates = analyzer.getPrivates();
                            for (Descriptors.PackageRef export : ((Packages)exports).keySet()) {
                                Map<Clazz.Def, List<Descriptors.TypeRef>> xRef = analyzer.getXRef(export, privates, 5);
                                if (xRef.isEmpty()) continue;
                                this.out.println();
                                this.out.printf("%s refers to private Packages (not good)\n\n", export);
                                for (Map.Entry<Clazz.Def, List<Descriptors.TypeRef>> e : xRef.entrySet()) {
                                    TreeSet<Descriptors.PackageRef> refs = new TreeSet<Descriptors.PackageRef>();
                                    for (Descriptors.TypeRef ref : e.getValue()) {
                                        refs.add(ref.getPackageRef());
                                    }
                                    refs.retainAll(privates);
                                    this.out.printf("%60s %-40s %s\n", e.getKey().getOwnerType().getFQN(), e.getKey().getName(), refs);
                                }
                                this.out.println();
                            }
                            this.out.println();
                        }
                        Map<Descriptors.PackageRef, List<Descriptors.PackageRef>> uses = analyzer.cleanupUses(analyzer.getUses(), !po.java());
                        if ((options & 0x20) != 0) {
                            this.out.println("[USES]");
                            this.printMultiMap(uses);
                            this.out.println();
                        }
                        if ((options & 0x40) != 0) {
                            this.out.println("[USEDBY]");
                            MultiMap<Descriptors.PackageRef, Descriptors.PackageRef> usedBy = new MultiMap<Descriptors.PackageRef, Descriptors.PackageRef>(uses).transpose();
                            this.printMultiMap(usedBy);
                        }
                    }
                    finally {
                        analyzer.close();
                    }
                }
                if ((options & 0x80) != 0) {
                    this.printComponents(this.out, jar);
                }
                if ((options & 0x100) != 0) {
                    this.printMetatype(this.out, jar);
                }
                if ((options & 4) == 0) break block34;
                this.out.println("[LIST]");
                for (Map.Entry<String, Map<String, Resource>> entry : jar.getDirectories().entrySet()) {
                    String name = entry.getKey();
                    Map<String, Resource> contents = entry.getValue();
                    this.out.println(name);
                    if (contents != null) {
                        for (String element : contents.keySet()) {
                            String extra;
                            Resource r;
                            int n = element.lastIndexOf(47);
                            if (n > 0) {
                                element = element.substring(n + 1);
                            }
                            this.out.print("  ");
                            this.out.print(element);
                            String path = element;
                            if (name.length() != 0) {
                                path = name + "/" + element;
                            }
                            if ((r = contents.get(path)) != null && (extra = r.getExtra()) != null) {
                                this.out.print(" extra='" + this.escapeUnicode(extra) + "'");
                            }
                            this.out.println();
                        }
                        continue;
                    }
                    this.out.println(name + " <no contents>");
                }
                this.out.println();
            }
            finally {
                jar.close();
            }
        }
    }

    void printManifest(Manifest manifest) {
        TreeSet<String> sorted = new TreeSet<String>();
        for (Object element : manifest.getMainAttributes().keySet()) {
            sorted.add(element.toString());
        }
        for (String key : sorted) {
            String value = manifest.getMainAttributes().getValue(key);
            this.out.printf("%-40s %-40s\n", key, value);
        }
    }

    private final char nibble(int i) {
        return "0123456789ABCDEF".charAt(i & 0xF);
    }

    private final String escapeUnicode(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c <= '~' && c != '\\') {
                sb.append(c);
                continue;
            }
            sb.append("\\u");
            sb.append(this.nibble(c >> 12));
            sb.append(this.nibble(c >> 8));
            sb.append(this.nibble(c >> 4));
            sb.append(this.nibble(c));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printComponents(PrintStream out, Jar jar) throws Exception {
        out.println("[COMPONENTS]");
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            out.println("No manifest");
            return;
        }
        String componentHeader = manifest.getMainAttributes().getValue("Service-Component");
        Parameters clauses = new Parameters(componentHeader);
        for (String path : clauses.keySet()) {
            out.println(path);
            Resource r = jar.getResource(path);
            if (r != null) {
                InputStreamReader ir = new InputStreamReader(r.openInputStream(), Constants.DEFAULT_CHARSET);
                OutputStreamWriter or = new OutputStreamWriter((OutputStream)out, Constants.DEFAULT_CHARSET);
                try {
                    IO.copy((Reader)ir, (Writer)or);
                    continue;
                }
                finally {
                    or.flush();
                    ir.close();
                    continue;
                }
            }
            out.println("  - no resource");
            this.warning("No Resource found for service component: " + path, new Object[0]);
        }
        out.println();
    }

    private void printMetatype(PrintStream out, Jar jar) throws Exception {
        out.println("[METATYPE]");
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            out.println("No manifest");
            return;
        }
        Map<String, Resource> map = jar.getDirectories().get("OSGI-INF/metatype");
        if (map != null) {
            for (Map.Entry<String, Resource> entry : map.entrySet()) {
                out.println(entry.getKey());
                IO.copy(entry.getValue().openInputStream(), (OutputStream)out);
                out.println();
            }
            out.println();
        }
    }

    <T extends Comparable<?>> void printMultiMap(Map<T, ? extends Collection<?>> map) {
        SortedList keys = new SortedList((Collection<Comparable<?>>)map.keySet());
        for (Object key : keys) {
            String name = key.toString();
            SortedList<Object> values = new SortedList<Object>(new Object[]{map.get(key)});
            String list = this.vertical(40, values);
            this.out.printf("%-40s %s\n", name, list);
        }
    }

    String vertical(int padding, Collection<?> used) {
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (Object s : used) {
            String name = s.toString();
            sb.append(del);
            sb.append(name);
            sb.append("\r\n");
            del = this.pad(padding);
        }
        if (sb.length() == 0) {
            sb.append("\r\n");
        }
        return sb.toString();
    }

    String pad(int i) {
        StringBuilder sb = new StringBuilder();
        while (i-- > 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private void print(String msg, Map<?, ? extends Map<?, ?>> ports) {
        if (ports.isEmpty()) {
            return;
        }
        this.out.println(msg);
        for (Map.Entry<?, Map<?, ?>> entry : ports.entrySet()) {
            Object key = entry.getKey();
            Map<?, ?> clause = Create.copy(entry.getValue());
            clause.remove("uses:");
            this.out.printf("  %-38s %s\n", key.toString().trim(), clause.isEmpty() ? "" : clause.toString());
        }
    }

    public void patch(patchOptions opts) throws Exception {
        PatchCommand pcmd = new PatchCommand(this);
        List<String> args = opts._();
        opts._command().execute(pcmd, args.remove(0), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="Run OSGi tests and create report")
    public void _runtests(runtestsOptions opts) throws Exception {
        int errors = 0;
        File cwd = new File("").getAbsoluteFile();
        Workspace ws = new Workspace(cwd);
        try {
            File reportDir = this.getFile("reports");
            IO.delete(reportDir);
            Tag summary = new Tag("summary", new Object[0]);
            summary.addAttribute("date", new Date());
            summary.addAttribute("ws", ws.getBase());
            if (opts.reportdir() != null) {
                reportDir = this.getFile(opts.reportdir());
            }
            if (!reportDir.exists() && !reportDir.mkdirs()) {
                throw new IOException("Could not create directory " + reportDir);
            }
            if (!reportDir.isDirectory()) {
                this.error("reportdir must be a directory %s (tried to create it ...)", reportDir);
            }
            if (opts.title() != null) {
                summary.addAttribute("title", opts.title());
            }
            if (opts.dir() != null) {
                cwd = this.getFile(opts.dir());
            }
            if (opts.workspace() != null) {
                ws.close();
                ws = Workspace.getWorkspace(this.getFile(opts.workspace()));
            }
            boolean hadOne = false;
            try {
                for (String arg : opts._()) {
                    this.trace("will run test %s", arg);
                    File f = this.getFile(arg);
                    errors += this.runtTest(f, ws, reportDir, summary);
                    hadOne = true;
                }
                if (!hadOne) {
                    File[] files;
                    for (File f : files = cwd.listFiles()) {
                        if (!f.getName().endsWith(".bnd")) continue;
                        errors += this.runtTest(f, ws, reportDir, summary);
                    }
                }
            }
            catch (Throwable e) {
                if (this.isExceptions()) {
                    e.printStackTrace();
                }
                this.error("FAILURE IN RUNTESTS", e, new Object[0]);
                ++errors;
            }
            if (errors > 0) {
                summary.addAttribute("errors", errors);
            }
            for (String error : this.getErrors()) {
                Tag e = new Tag("error", new Object[0]);
                e.addContent(error);
            }
            for (String warning : this.getWarnings()) {
                Tag e = new Tag("warning", new Object[0]);
                e.addContent(warning);
            }
            File r = bnd.getFile(reportDir, "summary.xml");
            FileOutputStream out = new FileOutputStream(r);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            try {
                summary.print(0, pw);
            }
            finally {
                pw.close();
                out.close();
            }
            if (errors != 0) {
                this.error("Errors found %s", errors);
            }
        }
        finally {
            ws.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runtTest(File testFile, Workspace ws, File reportDir, Tag summary) throws Exception {
        File tmpDir = new File(reportDir, "tmp");
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new IOException("Could not create directory " + tmpDir);
        }
        tmpDir.deleteOnExit();
        Tag test = new Tag(summary, "test", new Object[0]);
        test.addAttribute("path", testFile.getAbsolutePath());
        if (!testFile.isFile()) {
            this.error("No bnd file: %s", testFile);
            test.addAttribute("exception", "No bnd file found");
            this.error("No bnd file found for %s", testFile.getAbsolutePath());
            return 1;
        }
        Project project = new Project(ws, testFile.getAbsoluteFile().getParentFile(), testFile.getAbsoluteFile());
        project.setTrace(this.isTrace());
        project.setProperty("-nobundles", "true");
        ProjectTester tester = project.getProjectTester();
        if (!project.isOk()) {
            this.getInfo(project, project.toString() + ": " + testFile.getName() + ":");
            return 1;
        }
        tester.setContinuous(false);
        tester.setReportDir(tmpDir);
        test.addAttribute("title", project.toString());
        long start = System.currentTimeMillis();
        try {
            int errors = tester.test();
            Collection<File> reports = tester.getReports();
            for (File report : reports) {
                Tag bundle = new Tag(test, "bundle", new Object[0]);
                File dest = new File(reportDir, report.getName());
                report.renameTo(dest);
                bundle.addAttribute("file", dest.getAbsolutePath());
                this.doPerReport(bundle, dest);
            }
            switch (errors) {
                case 0: {
                    int i$ = 0;
                    return i$;
                }
                case -5: {
                    test.addAttribute("failed", "canceled");
                    int i$ = 1;
                    return i$;
                }
                case -6: {
                    test.addAttribute("failed", "duplicate bundle");
                    int i$ = 1;
                    return i$;
                }
                case -2: {
                    test.addAttribute("failed", "unknown reason");
                    int i$ = 1;
                    return i$;
                }
                case -7: {
                    test.addAttribute("failed", "resolve error");
                    int i$ = 1;
                    return i$;
                }
                case -3: {
                    test.addAttribute("failed", "timed out");
                    int i$ = 1;
                    return i$;
                }
                case -1: {
                    test.addAttribute("warning", "true");
                    int i$ = 1;
                    return i$;
                }
                case -8: {
                    test.addAttribute("failed", "activator error");
                    int i$ = 1;
                    return i$;
                }
            }
            if (errors > 0) {
                test.addAttribute("errors", errors);
                int i$ = errors;
                return i$;
            }
            test.addAttribute("failed", "unknown reason");
            int i$ = errors;
            return i$;
        }
        catch (Exception e) {
            test.addAttribute("failed", e);
            this.error("Exception in run %s", e, new Object[0]);
            int n = 1;
            return n;
        }
        finally {
            long duration = System.currentTimeMillis() - start;
            test.addAttribute("duration", (duration + 500L) / 1000L);
            this.getInfo(project, project.toString() + ": ");
        }
    }

    private void doPerReport(Tag report, File file) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            this.doCoverage(report, doc, xpath);
            this.doHtmlReport(report, file, doc, xpath);
        }
        catch (Exception e) {
            report.addAttribute("coverage-failed", e.getMessage());
        }
    }

    private void doCoverage(Tag report, Document doc, XPath xpath) throws XPathExpressionException {
        int bad = Integer.parseInt(xpath.evaluate("count(//method[count(ref)<2])", doc));
        int all = Integer.parseInt(xpath.evaluate("count(//method)", doc));
        report.addAttribute("coverage-bad", bad);
        report.addAttribute("coverage-all", all);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHtmlReport(Tag report, File file, Document doc, XPath xpath) throws Exception {
        String path = file.getAbsolutePath();
        if (path.endsWith(".xml")) {
            path = path.substring(0, path.length() - 4);
        }
        path = path + ".html";
        File html = new File(path);
        this.trace("Creating html report: %s", html);
        TransformerFactory fact = TransformerFactory.newInstance();
        InputStream in = this.getClass().getResourceAsStream("testreport.xsl");
        if (in == null) {
            this.warning("Resource not found: test-report.xsl, no html report", new Object[0]);
        } else {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(html), "UTF-8");
            try {
                Transformer transformer = fact.newTransformer(new StreamSource(in));
                transformer.transform(new DOMSource(doc), new StreamResult(out));
                this.trace("Transformed", new Object[0]);
            }
            finally {
                in.close();
                out.close();
            }
        }
    }

    @Description(value="Verify jars")
    public void _verify(verifyOptions opts) throws Exception {
        for (String path : opts._()) {
            File f = this.getFile(path);
            if (!f.isFile()) {
                this.error("No such file: %ss", f);
                continue;
            }
            Jar jar = new Jar(f);
            if (jar.getManifest() == null || jar.getBsn() == null) {
                this.error("Not a bundle %s", f);
            } else {
                Verifier v = new Verifier(jar);
                this.getInfo(v, f.getName());
                v.close();
            }
            jar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="Merge a binary jar with its sources. It is possible to specify  source path")
    public void _source(sourceOptions opts) throws Exception {
        List<String> arguments = opts._();
        File jarFile = this.getFile(arguments.remove(0));
        if (!jarFile.exists()) {
            this.error("File %s does not exist ", jarFile);
            return;
        }
        File sourceFile = this.getFile(arguments.remove(0));
        if (!sourceFile.exists()) {
            this.error("Source file %s does not exist ", sourceFile);
            return;
        }
        File output = jarFile;
        if (opts.output() != null) {
            output = this.getFile(opts.output());
        }
        Jar bin = new Jar(jarFile);
        File tmp = File.createTempFile("tmp", ".jar", jarFile.getParentFile());
        tmp.deleteOnExit();
        try {
            Jar src = new Jar(sourceFile);
            try {
                for (String path : src.getResources().keySet()) {
                    bin.putResource("OSGI-OPT/src/" + path, src.getResource(path));
                }
                bin.write(tmp);
            }
            finally {
                src.close();
            }
        }
        finally {
            bin.close();
        }
        tmp.renameTo(output);
    }

    @Description(value="Diff jars")
    public void _diff(DiffCommand.diffOptions opts) throws Exception {
        DiffCommand diff = new DiffCommand(this);
        diff.diff(opts);
    }

    @Description(value="Compare a newer bundle to a baselined bundle and provide versioning advice")
    public void _baseline(BaselineCommands.baseLineOptions opts) throws Exception {
        BaselineCommands baseliner = new BaselineCommands(this);
        baseliner._baseline(opts);
    }

    @Description(value="Highly specialized function to create an overview of package deltas in ees")
    public void _schema(BaselineCommands.schemaOptions opts) throws Exception {
        BaselineCommands baseliner = new BaselineCommands(this);
        baseliner._schema(opts);
    }

    public Project getProject() throws Exception {
        return this.getProject(null);
    }

    public Project getProject(String where) throws Exception {
        File projectDir;
        File workspaceDir;
        Workspace ws;
        Project project;
        File f;
        if (where == null || where.equals(".")) {
            where = "bnd.bnd";
        }
        if ((f = this.getFile(where)).isDirectory()) {
            f = new File(f, "bnd.bnd");
        }
        if (f.isFile() && (project = (ws = Workspace.getWorkspace(workspaceDir = (projectDir = f.getParentFile()).getParentFile())).getProject(projectDir.getName())).isValid()) {
            project.setTrace(this.isTrace());
            project.setPedantic(this.isPedantic());
            return project;
        }
        if (where.equals("bnd.bnd")) {
            return null;
        }
        this.error("Project not found: " + f, new Object[0]);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="Converter to different formats")
    public void _convert(convertOptions opts) throws IOException {
        File from = this.getFile(opts._().get(0));
        File to = this.getFile(opts._().get(1));
        if (opts.m2p()) {
            FileInputStream in = new FileInputStream(from);
            try {
                Properties p = new Properties();
                Manifest m = new Manifest(in);
                Attributes attrs = m.getMainAttributes();
                for (Map.Entry<Object, Object> i : attrs.entrySet()) {
                    p.put(i.getKey().toString(), i.getValue().toString());
                }
                FileOutputStream fout = new FileOutputStream(to);
                try {
                    if (opts.xml()) {
                        p.storeToXML(fout, "converted from " + from);
                    } else {
                        p.store(fout, "converted from " + from);
                    }
                }
                finally {
                    fout.close();
                }
            }
            finally {
                in.close();
            }
            return;
        }
        this.error("no conversion specified", new Object[0]);
    }

    @Description(value="Helps finding information in a set of JARs by filtering on manifest data and printing out selected information.")
    public void _select(selectOptions opts) throws Exception {
        PrintStream out = this.out;
        Filter filter = null;
        if (opts.where() != null) {
            String w = opts.where();
            if (!w.startsWith("(")) {
                w = "(" + w + ")";
            }
            filter = new Filter(w);
        }
        Instructions instructions = new Instructions(opts.header());
        for (String s : opts._()) {
            Jar jar = this.getJar(s);
            if (jar == null) {
                this.err.println("no file " + s);
                continue;
            }
            Domain domain = Domain.domain(jar.getManifest());
            Hashtable<String, Object> ht = new Hashtable<String, Object>();
            Iterator<String> i = domain.iterator();
            HashSet<String> realNames = new HashSet<String>();
            while (i.hasNext()) {
                String key = i.next();
                String value = domain.get(key).trim();
                ht.put(key.trim().toLowerCase(), value);
                realNames.add(key);
            }
            ht.put("resources", jar.getResources().keySet());
            realNames.add("resources");
            if (filter != null && !filter.match(ht)) continue;
            HashSet<Instruction> unused = new HashSet<Instruction>();
            Collection select = instructions.select(realNames, unused, true);
            for (String h : select) {
                if (opts.path()) {
                    out.print(jar.getSource().getAbsolutePath() + ":");
                }
                if (opts.name()) {
                    out.print(jar.getSource().getName() + ":");
                }
                if (opts.key()) {
                    out.print(h + ":");
                }
                out.println(ht.get(h.toLowerCase()));
            }
            for (Instruction ins : unused) {
                String literal = ins.getLiteral();
                if (literal.equals("name")) {
                    out.println(jar.getSource().getName());
                    continue;
                }
                if (literal.equals("path")) {
                    out.println(jar.getSource().getAbsolutePath());
                    continue;
                }
                if (literal.equals("size") || literal.equals("length")) {
                    out.println(jar.getSource().length());
                    continue;
                }
                if (!literal.equals("modified")) continue;
                out.println(new Date(jar.getSource().lastModified()));
            }
        }
    }

    Jar getJar(String s) {
        File f = this.getFile(s);
        if (f.isFile()) {
            try {
                return new Jar(f);
            }
            catch (ZipException e) {
                this.error("Not a jar/zip file: %s", f);
            }
            catch (Exception e) {
                this.error("Opening file: %s", e, f);
            }
            return null;
        }
        try {
            URL url = new URL(s);
            return new Jar(s, url.openStream());
        }
        catch (Exception exception) {
            this.error("Not a file or proper url: %s", f);
            return null;
        }
    }

    @Description(value="Show version information about bnd")
    public void _version(versionOptions o) throws IOException {
        if (!o.xtra()) {
            Analyzer a = new Analyzer();
            this.out.println(a.getBndVersion());
            a.close();
            return;
        }
        Enumeration<URL> e = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (e.hasMoreElements()) {
            URL u = e.nextElement();
            Manifest m = new Manifest(u.openStream());
            String bsn = m.getMainAttributes().getValue("Bundle-SymbolicName");
            if (bsn == null || !bsn.equals("biz.aQute.bnd")) continue;
            Attributes attrs = m.getMainAttributes();
            long lastModified = 0L;
            try {
                lastModified = Long.parseLong(attrs.getValue("Bnd-LastModified"));
            }
            catch (Exception ee) {
                // empty catch block
            }
            this.out.printf("%-40s %s\n", "Version", attrs.getValue("Bundle-Version"));
            if (lastModified > 0L) {
                this.out.printf("%-40s %s\n", "From", new Date(lastModified));
            }
            Parameters p = OSGiHeader.parseHeader(attrs.getValue("Bundle-License"));
            for (String l : p.keySet()) {
                this.out.printf("%-40s %s\n", "License", p.get(l).get("description"));
            }
            this.out.printf("%-40s %s\n", "Copyright", attrs.getValue("Bundle-Copyright"));
            this.out.printf("%-40s %s\n", "Git-SHA", attrs.getValue("Git-SHA"));
            this.out.printf("%-40s %s\n", "Git-Descriptor", attrs.getValue("Git-Descriptor"));
            this.out.printf("%-40s %s\n", "Sources", attrs.getValue("Bundle-SCM"));
            return;
        }
        this.error("Could not locate version", new Object[0]);
    }

    @Description(value="Show key project variables")
    public void _info(infoOptions options) throws Exception {
        Project p = this.getProject(options.project());
        if (p == null) {
            this.messages.NoProject();
            return;
        }
        boolean any = options.runbundles() || options.buildpath() || options.classpath() || options.dependsOn() || options.vmpath();
        MultiMap<String, Object> table = new MultiMap<String, Object>();
        if (any || options.runbundles()) {
            table.addAll("Run", p.getRunbundles());
        }
        if (any || options.buildpath()) {
            table.addAll("Build", p.getBuildpath());
        }
        if (any || options.buildpath()) {
            table.addAll("Depends on", p.getDependson());
        }
        if (any || options.sourcepath()) {
            table.addAll("Source", p.getSourcePath());
        }
        if (any || options.classpath()) {
            table.addAll("Class path", p.getClasspath());
        }
        if (any || options.vmpath()) {
            table.addAll("Run path", p.getRunpath());
        }
        this.printMultiMap(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="Grep the manifest of bundles/jar files. ")
    public void _grep(grepOptions opts) throws Exception {
        Set<String> headers;
        List<String> args = opts._();
        String s = args.remove(0);
        Pattern pattern = Glob.toPattern(s);
        if (pattern == null) {
            this.messages.InvalidGlobPattern_(s);
            return;
        }
        if (args.isEmpty()) {
            args = new ExtList<String>(this.getBase().list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            }));
        }
        if ((headers = opts.headers()) == null) {
            headers = new TreeSet<String>();
        }
        if (opts.exports()) {
            headers.add("Export-Package");
        }
        if (opts.bsn()) {
            headers.add("Bundle-SymbolicName");
        }
        if (opts.imports()) {
            headers.add("Import-Package");
        }
        Instructions instructions = new Instructions(headers);
        for (String fileName : args) {
            File file = this.getFile(fileName);
            if (!file.isFile()) {
                this.messages.NoSuchFile_(file);
                continue;
            }
            JarInputStream in = new JarInputStream(new FileInputStream(file));
            try {
                Manifest m = in.getManifest();
                for (Object header : m.getMainAttributes().keySet()) {
                    Attributes.Name name = (Attributes.Name)header;
                    if (!instructions.isEmpty() && !instructions.matches(((Object)name).toString())) continue;
                    String h = m.getMainAttributes().getValue(name);
                    QuotedTokenizer qt = new QuotedTokenizer(h, ",;=");
                    for (String value : qt.getTokenSet()) {
                        Matcher matcher = pattern.matcher(value);
                        while (matcher.find()) {
                            int end;
                            int start = matcher.start() - 8;
                            if (start < 0) {
                                start = 0;
                            }
                            if ((end = matcher.end() + 8) > value.length()) {
                                end = value.length();
                            }
                            this.out.printf("%40s : %20s ...%s[%s]%s...\n", fileName, name, value.substring(start, matcher.start()), value.substring(matcher.start(), matcher.end()), value.substring(matcher.end(), end));
                        }
                    }
                }
            }
            finally {
                in.close();
            }
        }
    }

    @Description(value="Set bnd/jpm global variables")
    public void _settings(settingOptions opts) throws Exception {
        try {
            this.trace("settings %s", opts.clear());
            List<String> rest = opts._();
            if (opts.clear()) {
                this.settings.clear();
                this.trace("clear %s", this.settings.entrySet());
            }
            if (opts.publicKey()) {
                this.out.println(this.tos(opts.hex(), this.settings.getPublicKey()));
                return;
            }
            if (opts.secretKey()) {
                this.out.println(this.tos(opts.hex(), this.settings.getPrivateKey()));
                return;
            }
            if (opts.mac()) {
                for (String s : rest) {
                    byte[] data = s.getBytes("UTF-8");
                    byte[] signature = this.settings.sign(data);
                    this.out.printf("%s\n", this.tos(opts.hex(), signature));
                }
                return;
            }
            if (rest.isEmpty()) {
                this.list(null, this.settings);
            } else {
                boolean set = false;
                for (String s : rest) {
                    Matcher m = ASSIGNMENT.matcher(s);
                    this.trace("try %s", s);
                    if (m.matches()) {
                        this.trace("matches %s %s %s", s, m.group(1), m.group(2));
                        String key = m.group(1);
                        Instructions instr = new Instructions(key);
                        Collection<String> select = instr.select(this.settings.keySet(), true);
                        String value = m.group(2);
                        if (value == null) {
                            this.trace("list wildcard " + instr + " " + select + " " + this.settings.keySet(), new Object[0]);
                            this.list(select, this.settings);
                            continue;
                        }
                        this.trace("assignment \t", new Object[0]);
                        this.settings.put(key, value);
                        set = true;
                        continue;
                    }
                    this.err.printf("Cannot assign %s\n", s);
                }
                if (set) {
                    this.trace("saving", new Object[0]);
                    this.settings.save();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String tos(boolean hex, byte[] data) {
        return hex ? Hex.toHexString(data) : Base64.encodeBase64(data);
    }

    private void list(Collection<String> keys, Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            if (keys != null && !keys.contains(e.getKey())) continue;
            this.out.printf("%-40s = %s\n", e.getKey(), e.getValue());
        }
    }

    @Description(value="Digests a number of files")
    public void _digest(hashOptions o) throws NoSuchAlgorithmException, Exception {
        long start = System.currentTimeMillis();
        long total = 0L;
        List<Alg> algs = o.algorithm();
        if (algs == null) {
            algs = Arrays.asList(Alg.SHA1);
        }
        for (String s : o._()) {
            File f = this.getFile(s);
            if (f.isFile()) {
                block6: for (Alg alg : algs) {
                    byte[] digest;
                    long now = System.currentTimeMillis();
                    switch (alg) {
                        default: {
                            this.error("no such algorithm %s", new Object[]{alg});
                            continue block6;
                        }
                        case SHA1: {
                            digest = SHA1.digest(f).digest();
                            break;
                        }
                        case MD5: {
                            digest = MD5.digest(f).digest();
                            break;
                        }
                        case TIMELESS: {
                            Jar j = new Jar(f);
                            digest = j.getTimelessDigest();
                        }
                    }
                    StringBuilder sb = new StringBuilder();
                    String del = "";
                    if (o.hex() || !o.b64()) {
                        sb.append(del).append(Hex.toHexString(digest));
                        del = " ";
                    }
                    if (o.b64()) {
                        sb.append(del).append(Base64.encodeBase64(digest));
                        del = " ";
                    }
                    if (o.name()) {
                        sb.append(del).append(f.getAbsolutePath());
                        del = " ";
                    }
                    if (o.process()) {
                        sb.append(del).append(System.currentTimeMillis() - now).append(" ms ").append(f.length() / 1000L).append(" Kb");
                        total += f.length();
                    }
                    this.out.println(sb);
                }
                continue;
            }
            this.error("file does not exist %s", f);
        }
        if (o.process()) {
            long time = System.currentTimeMillis() - start;
            float mb = total / 1000000L;
            this.out.format("Total %s Mb, %s ms, %s Mb/sec %s files\n", Float.valueOf(mb), time, total / time / 1024L, o._().size());
        }
    }

    @Description(value="Maven bundle command")
    public void _maven(Options options) throws Exception {
        MavenCommand mc = new MavenCommand(this);
        mc.setTrace(this.isTrace());
        mc.setExceptions(this.isExceptions());
        mc.setPedantic(this.isPedantic());
        mc.run(options._().toArray(new String[0]), 1);
        this.getInfo(mc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="Generate autocompletion file for bash")
    public void _generate(Options options) throws Exception {
        File tmp = File.createTempFile("bnd-completion", ".tmp");
        tmp.deleteOnExit();
        try {
            IO.copy(this.getClass().getResource("bnd-completion.bash"), tmp);
            Sed sed = new Sed(tmp);
            sed.setBackup(false);
            ReporterAdapter r = new ReporterAdapter();
            CommandLine c = new CommandLine(r);
            Map<String, Method> commands = c.getCommands(this);
            StringBuilder sb = new StringBuilder();
            for (String commandName : commands.keySet()) {
                sb.append(" " + commandName);
            }
            sb.append(" help");
            sed.replace("%listCommands%", sb.toString().substring(1));
            sed.doIt();
            IO.copy(tmp, (OutputStream)this.out);
        }
        finally {
            tmp.delete();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Description(value="Digest a number of files")
    @Arguments(arg={"file..."})
    static interface hashOptions
    extends Options {
        @Description(value="Show hex output (default)")
        public boolean hex();

        @Description(value="Show base64 output")
        public boolean b64();

        @Description(value="Show process info")
        public boolean process();

        @Description(value="Show the file name")
        public boolean name();

        @Description(value="Specify the algorithms")
        public List<Alg> algorithm();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Alg {
        SHA1,
        MD5,
        TIMELESS;

    }

    @Description(value="Set bnd/jpm global variables. The key can be wildcard.")
    @Arguments(arg={"<key>[=<value>]..."})
    static interface settingOptions
    extends Options {
        @Description(value="Clear all the settings, including the public and private key")
        public boolean clear();

        @Description(value="Show the public key")
        public boolean publicKey();

        @Description(value="Show the private secret key")
        public boolean secretKey();

        @Description(value="Sign the strings on the commandline")
        public boolean mac();

        @Description(value="Show key in hex")
        public boolean hex();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Arguments(arg={"pattern", "file..."})
    @Description(value="Grep the manifest of bundles/jar files. ")
    static interface grepOptions
    extends Options {
        @Description(value="Search in exports")
        public boolean exports();

        @Description(value="Search in imports")
        public boolean imports();

        @Description(value="Search in bsn")
        public boolean bsn();

        @Description(value="Set header(s) to search, can be wildcarded. The default is all headers (*).")
        public Set<String> headers();
    }

    @Arguments(arg={})
    @Description(value="Show key project variables")
    static interface infoOptions
    extends Options {
        public boolean runbundles();

        public boolean buildpath();

        public boolean dependsOn();

        public boolean sourcepath();

        public boolean classpath();

        public boolean vmpath();

        public String project();
    }

    @Description(value="Show version information about bnd")
    @Arguments(arg={})
    public static interface versionOptions
    extends Options {
        @Description(value="Show licensing, copyright, sha, scm, etc")
        public boolean xtra();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Description(value="Helps finding information in a set of JARs by filtering on manifest data and printing out selected information.")
    @Arguments(arg={"<jar-path>", "[...]"})
    static interface selectOptions
    extends Options {
        @Description(value="A simple assertion on a manifest header (e.g. Bundle-Version=1.0.1) or an OSGi filter that is asserted on all manifest headers. Comparisons are case insensitive. The key 'resources' holds the pathnames of all resources and can also be asserted to check for the presence of a header.")
        public String where();

        @Description(value="A manifest header to print or: path, name, size, length, modified for information about the file, wildcards are allowed to print multiple headers. ")
        public Collection<String> header();

        @Description(value="Print the key before the value")
        public boolean key();

        @Description(value="Print the file name before the value")
        public boolean name();

        @Description(value="Print the file path before the value")
        public boolean path();
    }

    @Description(value="Converter to different formats")
    @Arguments(arg={"from", "to"})
    static interface convertOptions
    extends Options {
        @Config(description="Convert a manifest to a properties files")
        public boolean m2p();

        @Config(description="Save as xml")
        public boolean xml();
    }

    @Description(value="Merge a binary jar with its sources. It is possible to specify  source path")
    @Arguments(arg={"<jar path>", "<source path>"})
    static interface sourceOptions
    extends Options {
        @Description(value="The output file")
        public String output();
    }

    @Description(value="Verify jars")
    @Arguments(arg={"<jar path>", "[...]"})
    static interface verifyOptions
    extends Options {
    }

    @Description(value="Run OSGi tests and create report")
    static interface runtestsOptions
    extends Options {
        @Description(value="Report directory")
        public String reportdir();

        @Description(value="Title in the report")
        public String title();

        @Description(value="Path to work directory")
        public String dir();

        @Description(value="Path to workspace")
        public String workspace();
    }

    static interface patchOptions
    extends Options {
    }

    @Arguments(arg={"jar-file..."})
    @Description(value="Provides detailed view of the bundle. It will analyze the bundle and then show its contents from different perspectives. If no options are specified, prints the manifest.")
    static interface printOptions
    extends Options {
        @Description(value="Print the api usage. This shows the usage constraints on exported packages when only public API is used.")
        public boolean api();

        @Description(value="Before printing, verify that the bundle is correct.")
        public boolean verify();

        @Description(value="Print the manifest.")
        public boolean manifest();

        @Description(value="List the resources")
        public boolean list();

        @Description(value="List the imports exports, versions and ranges")
        public boolean impexp();

        @Description(value="Show for each contained package, what other package it uses. Is either an private, exported, or imported package")
        public boolean uses();

        @Description(value="Transposed uses. Will show for each known package who it is used by.")
        public boolean by();

        @Description(value="Show components in detail")
        public boolean component();

        @Description(value="Show any metatype data")
        public boolean typemeta();

        @Description(value="Keep references to java in --api, --uses, and --usedby.")
        public boolean java();

        @Description(value="Show all packages, not just exported, in the API view")
        public boolean xport();
    }

    @Description(value="Show a lot of info about the project you're in")
    static interface debugOptions
    extends Options {
        @Description(value="Path to a project, default is current directory")
        public String project();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Description(value="Wrap a jar into a bundle. This is a poor man's facility to quickly turn a non-OSGi JAR into an OSGi bundle. It is usually better to write a bnd file and use the bnd <file>.bnd command because that has greater control. Even better is to wrap in bndtools.")
    @Arguments(arg={"<jar-file>", "[...]"})
    static interface wrapOptions
    extends Options {
        @Description(value="Path to the output, default the name of the input jar with the '.bar' extension. If this is a directory, the output is place there.")
        public String output();

        @Description(value="A file with properties in bnd format.")
        public String properties();

        @Description(value="A classpath specification")
        public List<String> classpath();

        @Description(value="Allow override of an existing file")
        public boolean force();

        @Description(value="Set the bundle symbolic name to use")
        public String bsn();

        @Description(value="Set the version to use")
        public Version version();
    }

    @Description(value="View a resource from a JAR file. Manifest will be pretty printed and class files are shown disassembled.")
    @Arguments(arg={"<jar-file>", "<resource>", "[...]"})
    static interface viewOptions
    extends Options {
        @Description(value="Character set to use for viewing")
        public String charset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Description(value="Build project, is deprecated but here for backward compatibility. If you use it, you should know how to use it so no more info is provided.")
    static interface buildxOptions
    extends Options {
        public String output();

        public List<String> classpath();

        public List<String> sourcepath();

        public boolean eclipse();

        public boolean noeclipse();

        public boolean sources();

        public boolean pom();

        public boolean force();
    }

    @Description(value="Show info about the current directory's eclipse project")
    @Arguments(arg={})
    static interface eclipseOptions
    extends Options {
        @Description(value="Path to the project")
        public String dir();
    }

    public static class All {
        public Map<Descriptors.TypeRef, List<Descriptors.TypeRef>> classes = new HashMap<Descriptors.TypeRef, List<Descriptors.TypeRef>>();
        public Map<Descriptors.PackageRef, List<Descriptors.PackageRef>> packages = new HashMap<Descriptors.PackageRef, List<Descriptors.PackageRef>>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Description(value="Show a cross references for all classes in a set of jars.")
    @Arguments(arg={"<jar path>", "[...]"})
    static interface xrefOptions
    extends Options {
        @Description(value="Show classes instead of packages")
        public boolean classes();

        @Description(value="Show references to other classes/packages (>)")
        public boolean to();

        @Description(value="Show references from other classes/packages (<)")
        public boolean from();

        @Description(value="Filter for class names, a globbing expression")
        public List<String> match();
    }

    @Description(value="Release this project")
    static interface releaseOptions
    extends Options {
        @Description(value="Path to project, default is current project")
        public String project();

        @Description(value="Release with test build")
        public boolean test();
    }

    @Description(value="Show macro value. Macro can contain the ${ and } parentheses but it is also ok without. You can use the ':' instead of the ';' in a macro")
    @Arguments(arg={"<macro>", "[...]"})
    static interface macroOptions
    extends Options {
        @Description(value="Path to project, default current directory")
        public String project();
    }

    @Description(value="Show all deliverables from this workspace. with their current version and path.")
    @Arguments(arg={})
    static interface deliverableOptions
    extends Options {
        @Description(value="Path to project, default current directory")
        public String project();

        @Description(value="Only provide deliverables of this project")
        public boolean limit();
    }

    @Description(value="Package a bnd or bndrun file into a single jar that executes with java -jar <>.jar. The JAR contains all dependencies, including the framework and the launcher. A profile can be specified which will be used to find properties. If a property is not found, a property with the name [<profile>]NAME will be looked up. This allows you to make different profiles for testing and runtime.")
    @Arguments(arg={"<bnd|bndrun>", "[...]"})
    static interface packageOptions
    extends Options {
        @Description(value="Where to store the resulting file. Default the name of the bnd file with a .jar extension.")
        public String output();

        @Description(value="Profile name. Default no profile")
        public String profile();

        @Description(value="Use JPM to deliver the -runbundles and -runpath. This will include the SHAs of the jars in the manifest. When JPM installs such a JAR it will automatically fetchs these jars and place them in the proper place. The filepaths to these artifacts will contain a ${JPMREPO} macro that points at the directory where the sha based named files are stored.")
        public boolean jpm();
    }

    @Description(value="Access the internal bnd database of keywords and options")
    @Arguments(arg={"header|instruction", "..."})
    static interface syntaxOptions
    extends Options {
        @Description(value="The width of the printout")
        public int width();
    }

    @Description(value="Clean a project")
    static interface cleanOptions
    extends Options {
        @Description(value="Path to another project than the current project")
        public String project();
    }

    @Description(value="Run a project in the OSGi launcher")
    static interface runOptions
    extends Options {
        @Description(value="Path to another project than the current project")
        public String project();
    }

    @Description(value="Test a project according to an OSGi test")
    @Arguments(arg={})
    static interface testOptions
    extends Options {
        @Description(value="Path to another project than the current project")
        public String project();
    }

    @Description(value="Build a project. This will create the jars defined in the bnd.bnd and sub-builders.")
    @Arguments(arg={})
    static interface buildoptions
    extends Options {
        @Description(value="Path to another project than the current project")
        public String project();

        @Description(value="Build for test")
        public boolean test();
    }

    @Description(value="Bumps the version of a project. Will take the current version and then increment with a major, minor, or micro increment. The default bump is minor.")
    @Arguments(arg={"<major|minor|micro>"})
    static interface bumpoptions
    extends Options {
        @Description(value="Path to another project than the current project")
        public String project();
    }

    @Description(value="Execute a Project action, or if no parms given, show information about the project")
    @Arguments(arg={""})
    static interface projectOptions
    extends Options {
        @Description(value="Identify another project")
        public String project();
    }

    @Description(value="Execute a file based on its extension. Supported extensions are: bnd (build), bndrun (run), and jar (print)")
    static interface dooptions
    extends Options {
        @Description(value="The output file")
        public String output();

        @Description(value="Force even when there are errors")
        public boolean force();
    }

    @Description(value="List files int a JAR file, equivalent jar command t[vf] (syntax supported)")
    static interface typeOptions
    extends Options {
        @Description(value="Verbose (v option)")
        public boolean verbose();

        @Description(value="Jar file (f option)")
        public String file();
    }

    @Description(value="Extract files from a JAR file, equivalent jar command x[vf] (syntax supported)")
    static interface extractOptions
    extends Options {
        @Description(value="Verbose (v option)")
        public boolean verbose();

        @Description(value="Jar file (f option)")
        public String file();

        @Description(value="Directory where to store")
        public String CDir();
    }

    @Description(value="Equivalent jar command c[v0mf] command (supports the jar tool's syntax). Will wrap the bundle unless --wrapnot is specified")
    static interface createOptions
    extends Options {
        @Description(value="Verbose (v option)")
        public boolean verbose();

        @Description(value="No compression (0 option)")
        public boolean nocompression();

        @Description(value="No manifest (M option)")
        public boolean Manifest();

        @Description(value="Use manifest (m option)")
        public String manifest();

        @Description(value="Jar file (f option)")
        public String file();

        @Description(value="Directory (-C option)")
        public String Cdir();

        @Description(value="Wrap")
        public boolean wrap();

        @Description(value="Properties for wrapping")
        public String properties();

        @Description(value="Bundle Symbolic Name for wrap")
        public String bsn();

        @Description(value="Bundle Version for wrap")
        public Version version();

        @Description(value="Force write event if there are errors")
        public boolean force();
    }

    @Description(value="OSGi Bundle Tool")
    static interface bndOptions
    extends Options {
        @Description(value="Turns errors into warnings so command always succeeds")
        public boolean failok();

        @Description(value="Report errors pedantically")
        public boolean pedantic();

        @Description(value="Print out stack traces when there is an unexpected exception")
        public boolean exceptions();

        @Description(value="Redirect output")
        public File output();

        @Description(value="Use as base directory")
        public String base();

        @Description(value="Trace progress")
        public boolean trace();

        @Description(value="Error/Warning ignore patterns")
        public String[] ignore();
    }
}

