/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.backgroundtask.messaging;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.service.BackgroundTaskLocalService;
import com.liferay.portal.service.LockLocalServiceUtil;

public class BackgroundTaskQueuingMessageListener
extends BaseMessageListener {
    @BeanReference(type=BackgroundTaskLocalService.class)
    private BackgroundTaskLocalService _backgroundTaskLocalService;

    protected void doReceive(Message message) throws Exception {
        boolean locked;
        String taskExecutorClassName = (String)message.get("taskExecutorClassName");
        if (Validator.isNull((String)taskExecutorClassName)) {
            return;
        }
        int status = (Integer)message.get("status");
        if (status == 5 || status == 2 || status == 3) {
            this.executeQueuedBackgroundTasks(taskExecutorClassName);
        } else if (status == 4 && !(locked = LockLocalServiceUtil.isLocked((String)BackgroundTaskExecutor.class.getName(), (String)taskExecutorClassName))) {
            this.executeQueuedBackgroundTasks(taskExecutorClassName);
        }
    }

    private void executeQueuedBackgroundTasks(String taskExecutorClassName) throws SystemException {
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.fetchFirstBackgroundTask(taskExecutorClassName, 4);
        if (backgroundTask == null) {
            return;
        }
        this._backgroundTaskLocalService.resumeBackgroundTask(backgroundTask.getBackgroundTaskId());
    }
}

