/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bean;

import com.liferay.portal.util.ClassLoaderUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class VelocityBeanHandler
implements InvocationHandler {
    private Object _bean;
    private ClassLoader _classLoader;

    public VelocityBeanHandler(Object bean, ClassLoader classLoader) {
        this._bean = bean;
        this._classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            if (this._classLoader != null && this._classLoader != contextClassLoader) {
                ClassLoaderUtil.setContextClassLoader(this._classLoader);
            }
            Object object = method.invoke(this._bean, arguments);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        finally {
            if (this._classLoader != null && this._classLoader != contextClassLoader) {
                ClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
        }
    }
}

