/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memcached;

import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.MemcachedClientIF;

public class MemcachePortalCache<V>
implements PortalCache<String, V> {
    private static Log _log = LogFactoryUtil.getLog(MemcachePortalCache.class);
    private MemcachedClientIF _memcachedClient;
    private String _name;
    private int _timeout;
    private TimeUnit _timeoutTimeUnit;
    private int _timeToLive;

    public MemcachePortalCache(String name, MemcachedClientIF memcachedClient, int timeout, TimeUnit timeoutTimeUnit) {
        this._name = name;
        this._memcachedClient = memcachedClient;
        this._timeout = timeout;
        this._timeoutTimeUnit = timeoutTimeUnit;
    }

    public void destroy() {
        this._memcachedClient.shutdown();
    }

    public Collection<V> get(Collection<String> keys) {
        ArrayList<String> processedKeys = new ArrayList<String>(keys.size());
        for (String key : keys) {
            String processedKey = this._name.concat(key);
            processedKeys.add(processedKey);
        }
        Future future = null;
        try {
            future = this._memcachedClient.asyncGetBulk(processedKeys);
        }
        catch (IllegalArgumentException iae) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Error retrieving with keys " + keys), (Throwable)iae);
            }
            return null;
        }
        Map values = null;
        try {
            values = (Map)future.get(this._timeout, this._timeoutTimeUnit);
        }
        catch (Throwable t) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Memcache operation error", t);
            }
            future.cancel(true);
        }
        if (values != null) {
            return values.values();
        }
        return null;
    }

    public V get(String key) {
        String processedKey = this._name.concat(key);
        Future future = null;
        try {
            future = this._memcachedClient.asyncGet(processedKey);
        }
        catch (IllegalArgumentException iae) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Error retrieving with key " + key), (Throwable)iae);
            }
            return null;
        }
        V value = null;
        try {
            value = future.get(this._timeout, this._timeoutTimeUnit);
        }
        catch (Throwable t) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Memcache operation error", t);
            }
            future.cancel(true);
        }
        return value;
    }

    public List<String> getKeys() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this._name;
    }

    public void put(String key, V value) {
        this.put(key, value, this._timeToLive);
    }

    public void put(String key, V value, int timeToLive) {
        block2: {
            String processedKey = this._name.concat(key);
            try {
                this._memcachedClient.set(processedKey, timeToLive, value);
            }
            catch (IllegalArgumentException iae) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Error storing value with key " + key), (Throwable)iae);
            }
        }
    }

    public void registerCacheListener(CacheListener<String, V> cacheListener) {
        this.registerCacheListener(cacheListener, CacheListenerScope.ALL);
    }

    public void registerCacheListener(CacheListener<String, V> cacheListener, CacheListenerScope cacheListenerScope) {
        throw new UnsupportedOperationException();
    }

    public void remove(String key) {
        block2: {
            String processedKey = this._name.concat(key);
            try {
                this._memcachedClient.delete(processedKey);
            }
            catch (IllegalArgumentException iae) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Error removing value with key " + key), (Throwable)iae);
            }
        }
    }

    public void removeAll() {
        this._memcachedClient.flush();
    }

    public void setTimeToLive(int timeToLive) {
        this._timeToLive = timeToLive;
    }

    public void unregisterCacheListener(CacheListener<String, V> cacheListener) {
    }

    public void unregisterCacheListeners() {
    }
}

