/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.common;

import com.liferay.portal.dao.shard.advice.ShardAdvice;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.util.PropsValues;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.map.LRUMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

@DoPrivileged
public class EntityCacheImpl
implements BeanFactoryAware,
CacheRegistryItem,
EntityCache {
    public static final String CACHE_NAME = EntityCache.class.getName();
    private static final String _GROUP_KEY_PREFIX = CACHE_NAME.concat(".");
    private static Log _log = LogFactoryUtil.getLog(EntityCacheImpl.class);
    private static ThreadLocal<LRUMap> _localCache;
    private static boolean _localCacheAvailable;
    private MultiVMPool _multiVMPool;
    private ConcurrentMap<String, PortalCache<Serializable, Serializable>> _portalCaches = new ConcurrentHashMap<String, PortalCache<Serializable, Serializable>>();
    private boolean _shardEnabled;

    static {
        if (PropsValues.VALUE_OBJECT_ENTITY_THREAD_LOCAL_CACHE_MAX_SIZE > 0) {
            _localCache = new AutoResetThreadLocal(EntityCacheImpl.class + "._localCache", (Object)new LRUMap(PropsValues.VALUE_OBJECT_ENTITY_THREAD_LOCAL_CACHE_MAX_SIZE));
            _localCacheAvailable = true;
        }
    }

    public void afterPropertiesSet() {
        CacheRegistryUtil.register((CacheRegistryItem)this);
    }

    public void clearCache() {
        this.clearLocalCache();
        for (PortalCache portalCache : this._portalCaches.values()) {
            portalCache.removeAll();
        }
    }

    public void clearCache(String className) {
        this.clearLocalCache();
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(className, true);
        if (portalCache != null) {
            portalCache.removeAll();
        }
    }

    public void clearLocalCache() {
        if (_localCacheAvailable) {
            _localCache.remove();
        }
    }

    public PortalCache<Serializable, Serializable> getPortalCache(Class<?> clazz) {
        return this._getPortalCache(clazz.getName(), true);
    }

    public String getRegistryName() {
        return CACHE_NAME;
    }

    public Serializable getResult(boolean entityCacheEnabled, Class<?> clazz, Serializable primaryKey) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistryUtil.isActive())) {
            return null;
        }
        Object result = null;
        Map localCache = null;
        Serializable localCacheKey = null;
        if (_localCacheAvailable) {
            localCache = (Map)_localCache.get();
            localCacheKey = this._encodeLocalCacheKey(clazz, primaryKey);
            result = (Serializable)localCache.get(localCacheKey);
        }
        if (result == null) {
            Serializable cacheKey;
            PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(clazz.getName(), true);
            result = (Serializable)portalCache.get(cacheKey = this._encodeCacheKey(primaryKey));
            if (result == null) {
                result = "";
            }
            if (_localCacheAvailable) {
                localCache.put(localCacheKey, result);
            }
        }
        return this._toEntityModel((Serializable)result);
    }

    public void invalidate() {
        this.clearCache();
    }

    public Serializable loadResult(boolean entityCacheEnabled, Class<?> clazz, Serializable primaryKey, SessionFactory sessionFactory) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistryUtil.isActive())) {
            Session session = null;
            try {
                session = sessionFactory.openSession();
                Serializable serializable = (Serializable)session.load(clazz, primaryKey);
                return serializable;
            }
            finally {
                sessionFactory.closeSession(session);
            }
        }
        Object result = null;
        Map localCache = null;
        Serializable localCacheKey = null;
        if (_localCacheAvailable) {
            localCache = (Map)_localCache.get();
            localCacheKey = this._encodeLocalCacheKey(clazz, primaryKey);
            result = (Serializable)localCache.get(localCacheKey);
        }
        Serializable loadResult = null;
        if (result == null) {
            Serializable cacheKey;
            PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(clazz.getName(), true);
            result = (Serializable)portalCache.get(cacheKey = this._encodeCacheKey(primaryKey));
            if (result == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Load " + clazz + " " + primaryKey + " from session"));
                }
                Session session = null;
                try {
                    session = sessionFactory.openSession();
                    loadResult = (Serializable)session.load(clazz, primaryKey);
                }
                finally {
                    result = loadResult == null ? "" : ((BaseModel)loadResult).toCacheModel();
                    portalCache.put(cacheKey, result);
                    sessionFactory.closeSession(session);
                }
            }
            if (_localCacheAvailable) {
                localCache.put(localCacheKey, result);
            }
        }
        if (loadResult != null) {
            return loadResult;
        }
        return this._toEntityModel((Serializable)result);
    }

    public void putResult(boolean entityCacheEnabled, Class<?> clazz, Serializable primaryKey, Serializable result) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistryUtil.isActive() && result != null)) {
            return;
        }
        result = ((BaseModel)result).toCacheModel();
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            Serializable localCacheKey = this._encodeLocalCacheKey(clazz, primaryKey);
            localCache.put(localCacheKey, result);
        }
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(clazz.getName(), true);
        Serializable cacheKey = this._encodeCacheKey(primaryKey);
        portalCache.put(cacheKey, (Object)result);
    }

    public void removeCache(String className) {
        this._portalCaches.remove(className);
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        this._multiVMPool.removeCache(groupKey);
    }

    public void removeResult(boolean entityCacheEnabled, Class<?> clazz, Serializable primaryKey) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistryUtil.isActive())) {
            return;
        }
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            Serializable localCacheKey = this._encodeLocalCacheKey(clazz, primaryKey);
            localCache.remove(localCacheKey);
        }
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(clazz.getName(), true);
        Serializable cacheKey = this._encodeCacheKey(primaryKey);
        portalCache.remove(cacheKey);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory.containsBean(ShardAdvice.class.getName())) {
            this._shardEnabled = true;
        }
    }

    public void setMultiVMPool(MultiVMPool multiVMPool) {
        this._multiVMPool = multiVMPool;
    }

    private Serializable _encodeCacheKey(Serializable primaryKey) {
        if (this._shardEnabled) {
            return new CacheKey(ShardUtil.getCurrentShardName(), primaryKey);
        }
        return primaryKey;
    }

    private Serializable _encodeLocalCacheKey(Class<?> clazz, Serializable primaryKey) {
        if (this._shardEnabled) {
            return new ShardLocalCacheKey(ShardUtil.getCurrentShardName(), clazz.getName(), primaryKey);
        }
        return new LocalCacheKey(clazz.getName(), primaryKey);
    }

    private PortalCache<Serializable, Serializable> _getPortalCache(String className, boolean createIfAbsent) {
        String groupKey;
        PortalCache<Serializable, Serializable> previousPortalCache;
        PortalCache<Serializable, Serializable> portalCache = (PortalCache<Serializable, Serializable>)this._portalCaches.get(className);
        if (portalCache == null && createIfAbsent && (previousPortalCache = this._portalCaches.putIfAbsent(className, portalCache = this._multiVMPool.getCache(groupKey = _GROUP_KEY_PREFIX.concat(className), PropsValues.VALUE_OBJECT_ENTITY_BLOCKING_CACHE))) != null) {
            portalCache = previousPortalCache;
        }
        return portalCache;
    }

    private Serializable _toEntityModel(Serializable result) {
        if (result == "") {
            return null;
        }
        CacheModel cacheModel = (CacheModel)result;
        BaseModel entityModel = (BaseModel)cacheModel.toEntityModel();
        entityModel.setCachedModel(true);
        return entityModel;
    }

    private static class CacheKey
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private Serializable _primaryKey;
        private String _shardName;

        public CacheKey() {
        }

        public CacheKey(String shardName, Serializable primaryKey) {
            this._shardName = shardName;
            this._primaryKey = primaryKey;
        }

        public boolean equals(Object obj) {
            CacheKey cacheKey = (CacheKey)obj;
            return cacheKey._shardName.equals(this._shardName) && cacheKey._primaryKey.equals(this._primaryKey);
        }

        public int hashCode() {
            return this._shardName.hashCode() * 11 + this._primaryKey.hashCode();
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
            this._primaryKey = (Serializable)objectInput.readObject();
            this._shardName = objectInput.readUTF();
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this._primaryKey);
            objectOutput.writeUTF(this._shardName);
        }
    }

    private static class LocalCacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _className;
        private final Serializable _primaryKey;

        public LocalCacheKey(String className, Serializable primaryKey) {
            this._className = className;
            this._primaryKey = primaryKey;
        }

        public boolean equals(Object obj) {
            LocalCacheKey localCacheKey = (LocalCacheKey)obj;
            return localCacheKey._className.equals(this._className) && localCacheKey._primaryKey.equals(this._primaryKey);
        }

        public int hashCode() {
            return this._className.hashCode() * 11 + this._primaryKey.hashCode();
        }
    }

    private static class ShardLocalCacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _className;
        private final Serializable _primaryKey;
        private final String _shardName;

        public ShardLocalCacheKey(String shardName, String className, Serializable primaryKey) {
            this._shardName = shardName;
            this._className = className;
            this._primaryKey = primaryKey;
        }

        public boolean equals(Object obj) {
            ShardLocalCacheKey shardLocalCacheKey = (ShardLocalCacheKey)obj;
            return shardLocalCacheKey._shardName.equals(this._shardName) && shardLocalCacheKey._className.equals(this._className) && shardLocalCacheKey._primaryKey.equals(this._primaryKey);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (Object)this._shardName);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._className);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._primaryKey);
            return hashCode;
        }
    }
}

