/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.SessionFactoryImpl;
import com.liferay.portal.dao.shard.ShardDataSourceTargetSource;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.spring.hibernate.PortletHibernateConfiguration;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.impl.SessionImpl;

public class PortletSessionFactoryImpl
extends SessionFactoryImpl {
    private static Log _log = LogFactoryUtil.getLog(PortletSessionFactoryImpl.class);
    private DataSource _dataSource;
    private Map<DataSource, SessionFactory> _sessionFactories = new HashMap<DataSource, SessionFactory>();

    public void afterPropertiesSet() {
        if (this._dataSource == InfrastructureUtil.getDataSource()) {
            portletSessionFactories.add(this);
        }
    }

    @Override
    public void closeSession(Session session) throws ORMException {
        if (session != null) {
            session.flush();
            if (!PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED) {
                session.close();
            }
        }
    }

    @Override
    public void destroy() {
        portletSessionFactories.remove(this);
    }

    public DataSource getDataSource() {
        ShardDataSourceTargetSource shardDataSourceTargetSource = (ShardDataSourceTargetSource)InfrastructureUtil.getShardDataSourceTargetSource();
        if (shardDataSourceTargetSource != null) {
            return shardDataSourceTargetSource.getDataSource();
        }
        return this._dataSource;
    }

    @Override
    public Session openSession() throws ORMException {
        Connection connection;
        SessionFactory sessionFactory = this.getSessionFactory();
        org.hibernate.classic.Session session = null;
        session = PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED ? ((connection = CurrentConnectionUtil.getConnection((DataSource)this.getDataSource())) == null ? sessionFactory.getCurrentSession() : sessionFactory.openSession(connection)) : sessionFactory.openSession();
        if (_log.isDebugEnabled()) {
            SessionImpl sessionImpl = (SessionImpl)session;
            _log.debug((Object)("Session is using connection release mode " + sessionImpl.getConnectionReleaseMode()));
        }
        return this.wrapSession((org.hibernate.Session)session);
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    protected SessionFactory getSessionFactory() {
        ShardDataSourceTargetSource shardDataSourceTargetSource = (ShardDataSourceTargetSource)InfrastructureUtil.getShardDataSourceTargetSource();
        if (shardDataSourceTargetSource == null) {
            return this.getSessionFactoryImplementor();
        }
        DataSource dataSource = shardDataSourceTargetSource.getDataSource();
        SessionFactory sessionFactory = this._sessionFactories.get(dataSource);
        if (sessionFactory != null) {
            return sessionFactory;
        }
        ClassLoader classLoader = PortletClassLoaderUtil.getClassLoader();
        try {
            PortletClassLoaderUtil.setClassLoader((ClassLoader)this.getSessionFactoryClassLoader());
            PortletHibernateConfiguration portletHibernateConfiguration = new PortletHibernateConfiguration();
            portletHibernateConfiguration.setDataSource(dataSource);
            try {
                sessionFactory = portletHibernateConfiguration.buildSessionFactory();
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
                PortletClassLoaderUtil.setClassLoader((ClassLoader)classLoader);
                return null;
            }
            this._sessionFactories.put(dataSource, sessionFactory);
            SessionFactory sessionFactory2 = sessionFactory;
            return sessionFactory2;
        }
        finally {
            PortletClassLoaderUtil.setClassLoader((ClassLoader)classLoader);
        }
    }

    @Override
    protected Session wrapSession(org.hibernate.Session session) {
        return DoPrivilegedUtil.wrapWhenActive(super.wrapSession(session));
    }
}

