/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jericho;

import com.liferay.portal.kernel.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Logger;
import net.htmlparser.jericho.LoggerProvider;

public class CachedLoggerProvider
implements LoggerProvider {
    private LoggerProvider _loggerProvider;
    private Map<String, Logger> _loggers = new ConcurrentHashMap<String, Logger>();

    public static void install() throws Exception {
        Class<?> clazz = Class.forName("net.htmlparser.jericho.LoggerFactory");
        Method method = ReflectionUtil.getDeclaredMethod(clazz, (String)"getDefaultLoggerProvider", (Class[])new Class[0]);
        LoggerProvider loggerProvider = (LoggerProvider)method.invoke(null, new Object[0]);
        CachedLoggerProvider cachedLoggerProvider = new CachedLoggerProvider(loggerProvider);
        Config.LoggerProvider = cachedLoggerProvider;
    }

    public CachedLoggerProvider(LoggerProvider loggerProvider) {
        this._loggerProvider = loggerProvider;
    }

    public Logger getLogger(String name) {
        Logger logger = this._loggers.get(name);
        if (logger == null) {
            logger = this._loggerProvider.getLogger(name);
            this._loggers.put(name, logger);
        }
        return logger;
    }
}

