/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.impl.OrganizationModelImpl;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import java.util.ArrayList;

public abstract class OrganizationBaseImpl
extends OrganizationModelImpl
implements Organization {
    public void persist() throws SystemException {
        if (this.isNew()) {
            OrganizationLocalServiceUtil.addOrganization((Organization)this);
        } else {
            OrganizationLocalServiceUtil.updateOrganization((Organization)this);
        }
    }

    public String buildTreePath() throws PortalException, SystemException {
        ArrayList<OrganizationBaseImpl> organizations = new ArrayList<OrganizationBaseImpl>();
        OrganizationBaseImpl organization = this;
        while (organization != null) {
            organizations.add(organization);
            organization = OrganizationLocalServiceUtil.fetchOrganization((long)organization.getParentOrganizationId());
        }
        StringBundler sb = new StringBundler(organizations.size() * 2 + 1);
        sb.append("/");
        int i2 = organizations.size() - 1;
        while (i2 >= 0) {
            organization = (Organization)organizations.get(i2);
            sb.append(organization.getOrganizationId());
            sb.append("/");
            --i2;
        }
        return sb.toString();
    }

    public void updateTreePath(String treePath) throws SystemException {
        OrganizationBaseImpl organization = this;
        organization.setTreePath(treePath);
        OrganizationLocalServiceUtil.updateOrganization((Organization)organization);
    }
}

