/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.spi.search;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.nio.intraband.messaging.IntrabandBridgeMessageListener;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import java.rmi.RemoteException;
import java.util.Set;

public class SPISearchEngineConfigurator {
    private MessageBus _messageBus;

    public void afterPropertiesSet() throws RemoteException {
        if (!SPIUtil.isSPI()) {
            return;
        }
        Set searchEngineIds = SearchEngineUtil.getSearchEngineIds();
        for (String searchEngineId : searchEngineIds) {
            String destinationName = SearchEngineUtil.getSearchWriterDestinationName((String)searchEngineId);
            Destination destination = this._messageBus.getDestination(destinationName);
            destination.unregisterMessageListeners();
            SPI spi = SPIUtil.getSPI();
            destination.register((MessageListener)new IntrabandBridgeMessageListener(spi.getRegistrationReference()));
        }
    }

    public void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }
}

