/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutPrototypeServiceBaseImpl;
import com.liferay.portal.service.permission.LayoutPrototypePermissionUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutPrototypeServiceImpl
extends LayoutPrototypeServiceBaseImpl {
    public LayoutPrototype addLayoutPrototype(Map<Locale, String> nameMap, String description, boolean active) throws PortalException, SystemException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_LAYOUT_PROTOTYPE");
        User user = this.getUser();
        return this.layoutPrototypeLocalService.addLayoutPrototype(user.getUserId(), user.getCompanyId(), nameMap, description, active);
    }

    public LayoutPrototype addLayoutPrototype(Map<Locale, String> nameMap, String description, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_LAYOUT_PROTOTYPE");
        User user = this.getUser();
        return this.layoutPrototypeLocalService.addLayoutPrototype(user.getUserId(), user.getCompanyId(), nameMap, description, active, serviceContext);
    }

    public void deleteLayoutPrototype(long layoutPrototypeId) throws PortalException, SystemException {
        LayoutPrototypePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutPrototypeId, (String)"DELETE");
        this.layoutPrototypeLocalService.deleteLayoutPrototype(layoutPrototypeId);
    }

    public LayoutPrototype getLayoutPrototype(long layoutPrototypeId) throws PortalException, SystemException {
        LayoutPrototypePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutPrototypeId, (String)"VIEW");
        return this.layoutPrototypeLocalService.getLayoutPrototype(layoutPrototypeId);
    }

    public List<LayoutPrototype> search(long companyId, Boolean active, OrderByComparator obc) throws PortalException, SystemException {
        ArrayList<LayoutPrototype> filteredLayoutPrototypes = new ArrayList<LayoutPrototype>();
        List layoutPrototypes = this.layoutPrototypeLocalService.search(companyId, active, -1, -1, obc);
        for (LayoutPrototype layoutPrototype : layoutPrototypes) {
            if (!LayoutPrototypePermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)layoutPrototype.getLayoutPrototypeId(), (String)"VIEW")) continue;
            filteredLayoutPrototypes.add(layoutPrototype);
        }
        return filteredLayoutPrototypes;
    }

    public LayoutPrototype updateLayoutPrototype(long layoutPrototypeId, Map<Locale, String> nameMap, String description, boolean active) throws PortalException, SystemException {
        LayoutPrototypePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutPrototypeId, (String)"UPDATE");
        return this.layoutPrototypeLocalService.updateLayoutPrototype(layoutPrototypeId, nameMap, description, active);
    }

    public LayoutPrototype updateLayoutPrototype(long layoutPrototypeId, Map<Locale, String> nameMap, String description, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutPrototypePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutPrototypeId, (String)"UPDATE");
        return this.layoutPrototypeLocalService.updateLayoutPrototype(layoutPrototypeId, nameMap, description, active, serviceContext);
    }
}

