/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.LayoutSetVirtualHostException;
import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.NoSuchVirtualHostException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThemeFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutSetLocalServiceBaseImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class LayoutSetLocalServiceImpl
extends LayoutSetLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(LayoutSetLocalServiceImpl.class);

    public LayoutSet addLayoutSet(long groupId, boolean privateLayout) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        Date now = new Date();
        long layoutSetId = this.counterLocalService.increment();
        LayoutSet layoutSet = this.layoutSetPersistence.create(layoutSetId);
        layoutSet.setGroupId(groupId);
        layoutSet.setCompanyId(group.getCompanyId());
        layoutSet.setCreateDate(now);
        layoutSet.setModifiedDate(now);
        layoutSet.setPrivateLayout(privateLayout);
        layoutSet = this.initLayoutSet(layoutSet);
        this.layoutSetPersistence.update((BaseModel)layoutSet);
        return layoutSet;
    }

    public void deleteLayoutSet(long groupId, boolean privateLayout, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutSet layoutSet;
        Group group;
        block7: {
            group = this.groupPersistence.findByPrimaryKey(groupId);
            layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
            serviceContext.setAttribute("updatePageCount", (Serializable)Boolean.FALSE);
            this.layoutLocalService.deleteLayouts(groupId, privateLayout, serviceContext);
            if (group.isStagingGroup() || !group.isOrganization() || !group.isSite()) {
                try {
                    this.imageLocalService.deleteImage(layoutSet.getLogoId());
                }
                catch (NoSuchImageException noSuchImageException) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Object)("Unable to delete image " + layoutSet.getLogoId()));
                }
            }
        }
        if (!group.isStagingGroup() && group.isOrganization() && group.isSite()) {
            layoutSet = this.initLayoutSet(layoutSet);
            layoutSet.setLogoId(layoutSet.getLogoId());
            this.layoutSetPersistence.update((BaseModel)layoutSet);
        } else {
            this.layoutSetPersistence.removeByG_P(groupId, privateLayout);
        }
        try {
            this.virtualHostPersistence.removeByC_L(layoutSet.getCompanyId(), layoutSet.getLayoutSetId());
        }
        catch (NoSuchVirtualHostException noSuchVirtualHostException) {}
    }

    public LayoutSet fetchLayoutSet(String virtualHostname) throws SystemException {
        VirtualHost virtualHost = this.virtualHostPersistence.fetchByHostname(virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim()));
        if (virtualHost == null || virtualHost.getLayoutSetId() == 0L) {
            return null;
        }
        return this.layoutSetPersistence.fetchByPrimaryKey(virtualHost.getLayoutSetId());
    }

    public LayoutSet getLayoutSet(long groupId, boolean privateLayout) throws PortalException, SystemException {
        return this.layoutSetPersistence.findByG_P(groupId, privateLayout);
    }

    public LayoutSet getLayoutSet(String virtualHostname) throws PortalException, SystemException {
        VirtualHost virtualHost = this.virtualHostPersistence.findByHostname(virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim()));
        if (virtualHost.getLayoutSetId() == 0L) {
            throw new LayoutSetVirtualHostException("Virtual host is associated with company " + virtualHost.getCompanyId());
        }
        return this.layoutSetPersistence.findByPrimaryKey(virtualHost.getLayoutSetId());
    }

    public List<LayoutSet> getLayoutSetsByLayoutSetPrototypeUuid(String layoutSetPrototypeUuid) throws SystemException {
        return this.layoutSetPersistence.findByLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
    }

    public void updateLayoutSetPrototypeLinkEnabled(long groupId, boolean privateLayout, boolean layoutSetPrototypeLinkEnabled) throws PortalException, SystemException {
        this.updateLayoutSetPrototypeLinkEnabled(groupId, privateLayout, layoutSetPrototypeLinkEnabled, null);
    }

    public void updateLayoutSetPrototypeLinkEnabled(long groupId, boolean privateLayout, boolean layoutSetPrototypeLinkEnabled, String layoutSetPrototypeUuid) throws PortalException, SystemException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        if (Validator.isNull((String)layoutSetPrototypeUuid)) {
            layoutSetPrototypeUuid = layoutSet.getLayoutSetPrototypeUuid();
        }
        if (Validator.isNull((String)layoutSetPrototypeUuid)) {
            layoutSetPrototypeLinkEnabled = false;
        }
        layoutSet.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
        layoutSet.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
        this.layoutSetPersistence.update((BaseModel)layoutSet);
    }

    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean logo, byte[] bytes) throws PortalException, SystemException {
        ByteArrayInputStream is = null;
        if (logo) {
            is = new ByteArrayInputStream(bytes);
        }
        return this.updateLogo(groupId, privateLayout, logo, is);
    }

    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean logo, File file) throws PortalException, SystemException {
        FileInputStream is = null;
        if (logo) {
            try {
                is = new FileInputStream(file);
            }
            catch (IOException ioe) {
                throw new SystemException((Throwable)ioe);
            }
        }
        return this.updateLogo(groupId, privateLayout, logo, is);
    }

    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean logo, InputStream is) throws PortalException, SystemException {
        return this.updateLogo(groupId, privateLayout, logo, is, true);
    }

    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean logo, InputStream is, boolean cleanUpStream) throws PortalException, SystemException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        layoutSet.setModifiedDate(new Date());
        layoutSet.setLogo(logo);
        if (logo) {
            long logoId = layoutSet.getLogoId();
            if (logoId <= 0L) {
                logoId = this.counterLocalService.increment();
                layoutSet.setLogoId(logoId);
            }
        } else {
            layoutSet.setLogoId(0L);
        }
        if (logo) {
            this.imageLocalService.updateImage(layoutSet.getLogoId(), is, cleanUpStream);
        } else {
            this.imageLocalService.deleteImage(layoutSet.getLogoId());
        }
        return (LayoutSet)this.layoutSetPersistence.update((BaseModel)layoutSet);
    }

    public LayoutSet updateLookAndFeel(long groupId, boolean privateLayout, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        layoutSet.setModifiedDate(new Date());
        if (Validator.isNull((String)themeId)) {
            themeId = ThemeFactoryUtil.getDefaultRegularThemeId((long)layoutSet.getCompanyId());
        }
        if (Validator.isNull((String)colorSchemeId)) {
            colorSchemeId = ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId();
        }
        if (wapTheme) {
            layoutSet.setWapThemeId(themeId);
            layoutSet.setWapColorSchemeId(colorSchemeId);
        } else {
            layoutSet.setThemeId(themeId);
            layoutSet.setColorSchemeId(colorSchemeId);
            layoutSet.setCss(css);
        }
        this.layoutSetPersistence.update((BaseModel)layoutSet);
        if (PrefsPropsUtil.getBoolean("theme.sync.on.group", PropsValues.THEME_SYNC_ON_GROUP)) {
            LayoutSet otherLayoutSet = this.layoutSetPersistence.findByG_P(layoutSet.getGroupId(), layoutSet.isPrivateLayout());
            if (wapTheme) {
                otherLayoutSet.setWapThemeId(themeId);
                otherLayoutSet.setWapColorSchemeId(colorSchemeId);
            } else {
                otherLayoutSet.setThemeId(themeId);
                otherLayoutSet.setColorSchemeId(colorSchemeId);
            }
            this.layoutSetPersistence.update((BaseModel)otherLayoutSet);
        }
        return layoutSet;
    }

    public void updateLookAndFeel(long groupId, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        this.updateLookAndFeel(groupId, false, themeId, colorSchemeId, css, wapTheme);
        this.updateLookAndFeel(groupId, true, themeId, colorSchemeId, css, wapTheme);
    }

    public LayoutSet updatePageCount(long groupId, boolean privateLayout) throws PortalException, SystemException {
        int pageCount = this.layoutPersistence.countByG_P(groupId, privateLayout);
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        layoutSet.setModifiedDate(new Date());
        layoutSet.setPageCount(pageCount);
        this.layoutSetPersistence.update((BaseModel)layoutSet);
        return layoutSet;
    }

    public LayoutSet updateSettings(long groupId, boolean privateLayout, String settings) throws PortalException, SystemException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        layoutSet.setModifiedDate(new Date());
        layoutSet.setSettings(settings);
        this.layoutSetPersistence.update((BaseModel)layoutSet);
        return layoutSet;
    }

    public LayoutSet updateVirtualHost(long groupId, boolean privateLayout, String virtualHostname) throws PortalException, SystemException {
        if (Validator.isNotNull((String)(virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim()))) && !Validator.isDomain((String)virtualHostname)) {
            throw new LayoutSetVirtualHostException();
        }
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        if (Validator.isNotNull((String)virtualHostname)) {
            VirtualHost virtualHost = this.virtualHostPersistence.fetchByHostname(virtualHostname);
            if (virtualHost == null) {
                this.virtualHostLocalService.updateVirtualHost(layoutSet.getCompanyId(), layoutSet.getLayoutSetId(), virtualHostname);
            } else if (virtualHost.getCompanyId() != layoutSet.getCompanyId() || virtualHost.getLayoutSetId() != layoutSet.getLayoutSetId()) {
                throw new LayoutSetVirtualHostException();
            }
        } else {
            try {
                this.virtualHostPersistence.removeByC_L(layoutSet.getCompanyId(), layoutSet.getLayoutSetId());
            }
            catch (NoSuchVirtualHostException noSuchVirtualHostException) {}
        }
        return layoutSet;
    }

    protected LayoutSet initLayoutSet(LayoutSet layoutSet) throws PortalException, SystemException {
        Group group = layoutSet.getGroup();
        boolean privateLayout = layoutSet.isPrivateLayout();
        if (group.isStagingGroup()) {
            LayoutSet liveLayoutSet = null;
            Group liveGroup = group.getLiveGroup();
            liveLayoutSet = privateLayout ? liveGroup.getPrivateLayoutSet() : liveGroup.getPublicLayoutSet();
            layoutSet.setLogo(liveLayoutSet.getLogo());
            layoutSet.setLogoId(liveLayoutSet.getLogoId());
            if (liveLayoutSet.isLogo()) {
                Image logoImage = this.imageLocalService.getImage(liveLayoutSet.getLogoId());
                long logoId = this.counterLocalService.increment();
                this.imageLocalService.updateImage(logoId, logoImage.getTextObj(), logoImage.getType(), logoImage.getHeight(), logoImage.getWidth(), logoImage.getSize());
                layoutSet.setLogoId(logoId);
            }
            layoutSet.setThemeId(liveLayoutSet.getThemeId());
            layoutSet.setColorSchemeId(liveLayoutSet.getColorSchemeId());
            layoutSet.setWapThemeId(liveLayoutSet.getWapThemeId());
            layoutSet.setWapColorSchemeId(liveLayoutSet.getWapColorSchemeId());
            layoutSet.setCss(liveLayoutSet.getCss());
            layoutSet.setSettings(liveLayoutSet.getSettings());
        } else {
            layoutSet.setThemeId(ThemeFactoryUtil.getDefaultRegularThemeId((long)group.getCompanyId()));
            layoutSet.setColorSchemeId(ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId());
            layoutSet.setWapThemeId(ThemeFactoryUtil.getDefaultWapThemeId((long)group.getCompanyId()));
            layoutSet.setWapColorSchemeId(ColorSchemeFactoryUtil.getDefaultWapColorSchemeId());
            layoutSet.setCss("");
            layoutSet.setSettings("");
        }
        return layoutSet;
    }
}

