/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.ResourceAction;
import com.liferay.portal.model.impl.GroupImpl;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.service.persistence.GroupFinder;
import com.liferay.portal.service.persistence.GroupUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.comparator.GroupNameComparator;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GroupFinderImpl
extends BasePersistenceImpl<Group>
implements GroupFinder {
    public static final String COUNT_BY_LAYOUTS = String.valueOf(GroupFinder.class.getName()) + ".countByLayouts";
    public static final String COUNT_BY_GROUP_ID = String.valueOf(GroupFinder.class.getName()) + ".countByGroupId";
    public static final String COUNT_BY_C_C_PG_N_D = String.valueOf(GroupFinder.class.getName()) + ".countByC_C_PG_N_D";
    public static final String FIND_BY_LAYOUTS = String.valueOf(GroupFinder.class.getName()) + ".findByLayouts";
    public static final String FIND_BY_LIVE_GROUPS = String.valueOf(GroupFinder.class.getName()) + ".findByLiveGroups";
    public static final String FIND_BY_NO_LAYOUTS = String.valueOf(GroupFinder.class.getName()) + ".findByNoLayouts";
    public static final String FIND_BY_NULL_FRIENDLY_URL = String.valueOf(GroupFinder.class.getName()) + ".findByNullFriendlyURL";
    public static final String FIND_BY_SYSTEM = String.valueOf(GroupFinder.class.getName()) + ".findBySystem";
    public static final String FIND_BY_C_C = String.valueOf(GroupFinder.class.getName()) + ".findByC_C";
    public static final String FIND_BY_C_P = String.valueOf(GroupFinder.class.getName()) + ".findByC_P";
    public static final String FIND_BY_C_N = String.valueOf(GroupFinder.class.getName()) + ".findByC_N";
    public static final String FIND_BY_C_C_PG_N_D = String.valueOf(GroupFinder.class.getName()) + ".findByC_C_PG_N_D";
    public static final String JOIN_BY_ACTIVE = String.valueOf(GroupFinder.class.getName()) + ".joinByActive";
    public static final String JOIN_BY_CREATOR_USER_ID = String.valueOf(GroupFinder.class.getName()) + ".joinByCreatorUserId";
    public static final String JOIN_BY_GROUP_ORG = String.valueOf(GroupFinder.class.getName()) + ".joinByGroupOrg";
    public static final String JOIN_BY_GROUPS_ORGS = String.valueOf(GroupFinder.class.getName()) + ".joinByGroupsOrgs";
    public static final String JOIN_BY_GROUPS_ROLES = String.valueOf(GroupFinder.class.getName()) + ".joinByGroupsRoles";
    public static final String JOIN_BY_GROUPS_USER_GROUPS = String.valueOf(GroupFinder.class.getName()) + ".joinByGroupsUserGroups";
    public static final String JOIN_BY_LAYOUT_SET = String.valueOf(GroupFinder.class.getName()) + ".joinByLayoutSet";
    public static final String JOIN_BY_MANUAL_MEMBERSHIP = String.valueOf(GroupFinder.class.getName()) + ".joinByManualMembership";
    public static final String JOIN_BY_MEMBERSHIP_RESTRICTION = String.valueOf(GroupFinder.class.getName()) + ".joinByMembershipRestriction";
    public static final String JOIN_BY_PAGE_COUNT = String.valueOf(GroupFinder.class.getName()) + ".joinByPageCount";
    public static final String JOIN_BY_ROLE_RESOURCE_PERMISSIONS = String.valueOf(GroupFinder.class.getName()) + ".joinByRoleResourcePermissions";
    public static final String JOIN_BY_ROLE_RESOURCE_TYPE_PERMISSIONS = String.valueOf(GroupFinder.class.getName()) + ".joinByRoleResourceTypePermissions";
    public static final String JOIN_BY_SITE = String.valueOf(GroupFinder.class.getName()) + ".joinBySite";
    public static final String JOIN_BY_TYPE = String.valueOf(GroupFinder.class.getName()) + ".joinByType";
    public static final String JOIN_BY_USER_GROUP_ROLE = String.valueOf(GroupFinder.class.getName()) + ".joinByUserGroupRole";
    public static final String JOIN_BY_USERS_GROUPS = String.valueOf(GroupFinder.class.getName()) + ".joinByUsersGroups";
    private LinkedHashMap<String, Object> _emptyLinkedHashMap = new LinkedHashMap(0);
    private Map<String, String> _findByC_C_PG_N_DSQLCache = new ConcurrentHashMap<String, String>();
    private Map<String, String> _findByCompanyIdSQLCache = new ConcurrentHashMap<String, String>();
    private volatile long[] _groupOrganizationClassNameIds;
    private volatile Map<String, String> _joinMap;
    private Map<String, String> _replaceJoinAndWhereSQLCache = new ConcurrentHashMap<String, String>();
    private volatile Map<String, String> _whereMap;

    public int countByLayouts(long companyId, long parentGroupId, boolean site) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_LAYOUTS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(parentGroupId);
            qPos.add(site);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_U(long groupId, long userId, boolean inherit) throws SystemException {
        LinkedHashMap<String, Object> params1 = new LinkedHashMap<String, Object>();
        params1.put("usersGroups", userId);
        LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
        params2.put("groupOrg", userId);
        LinkedHashMap<String, Object> params3 = new LinkedHashMap<String, Object>();
        params3.put("groupsOrgs", userId);
        LinkedHashMap<String, Object> params4 = new LinkedHashMap<String, Object>();
        params4.put("groupsUserGroups", userId);
        Session session = null;
        try {
            session = this.openSession();
            int count = this.countByGroupId(session, groupId, params1);
            if (inherit) {
                count += this.countByGroupId(session, groupId, params2);
                count += this.countByGroupId(session, groupId, params3);
                count += this.countByGroupId(session, groupId, params4);
            }
            int n = count;
            return n;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByC_C_PG_N_D(long companyId, long[] classNameIds, long parentGroupId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        String parentGroupIdComparator = "=";
        if (parentGroupId == -1L) {
            parentGroupIdComparator = "!=";
        }
        names = CustomSQLUtil.keywords((String[])names);
        descriptions = CustomSQLUtil.keywords((String[])descriptions);
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = null;
        LinkedHashMap<String, Object> params3 = null;
        LinkedHashMap<String, Object> params4 = null;
        Long userId = (Long)params.get("usersGroups");
        boolean doUnion = Validator.isNotNull((Long)userId);
        if (doUnion) {
            params2 = new LinkedHashMap<String, Object>(params1);
            params2.remove("usersGroups");
            params2.put("groupOrg", userId);
            params3 = new LinkedHashMap<String, Object>(params1);
            params3.remove("usersGroups");
            params3.put("groupsOrgs", userId);
            params4 = new LinkedHashMap<String, Object>(params1);
            params4.remove("usersGroups");
            params4.put("groupsUserGroups", userId);
        }
        Session session = null;
        try {
            session = this.openSession();
            HashSet<Long> groupIds = new HashSet<Long>();
            groupIds.addAll(this.countByC_C_PG_N_D(session, companyId, classNameIds, parentGroupId, parentGroupIdComparator, names, descriptions, params1, andOperator));
            if (doUnion) {
                groupIds.addAll(this.countByC_C_PG_N_D(session, companyId, classNameIds, parentGroupId, parentGroupIdComparator, names, descriptions, params2, andOperator));
                groupIds.addAll(this.countByC_C_PG_N_D(session, companyId, classNameIds, parentGroupId, parentGroupIdComparator, names, descriptions, params3, andOperator));
                groupIds.addAll(this.countByC_C_PG_N_D(session, companyId, classNameIds, parentGroupId, parentGroupIdComparator, names, descriptions, params4, andOperator));
            }
            int n = groupIds.size();
            return n;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Deprecated
    public List<Group> findByLayouts(long companyId, long parentGroupId, boolean site, int start, int end) throws SystemException {
        return this.findByLayouts(companyId, parentGroupId, site, start, end, null);
    }

    public List<Group> findByLayouts(long companyId, long parentGroupId, boolean site, int start, int end, OrderByComparator obc) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_LAYOUTS);
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(parentGroupId);
            qPos.add(site);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByLiveGroups() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_LIVE_GROUPS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByNoLayouts(long classNameId, boolean privateLayout, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_LAYOUTS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(classNameId);
            qPos.add(privateLayout);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByNullFriendlyURL() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NULL_FRIENDLY_URL);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findBySystem(long companyId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_SYSTEM);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByCompanyId(long companyId, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        boolean doUnion;
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = null;
        LinkedHashMap<String, Object> params3 = null;
        LinkedHashMap<String, Object> params4 = null;
        Long userId = (Long)params.get("usersGroups");
        boolean inherit = GetterUtil.getBoolean((Object)params.get("inherit"), (boolean)true);
        boolean bl = doUnion = Validator.isNotNull((Long)userId) && inherit;
        if (doUnion) {
            params2 = new LinkedHashMap<String, Object>(params1);
            params2.remove("usersGroups");
            params2.put("groupOrg", userId);
            params3 = new LinkedHashMap<String, Object>(params1);
            params3.remove("usersGroups");
            params3.put("groupsOrgs", userId);
            params4 = new LinkedHashMap<String, Object>(params1);
            params4.remove("usersGroups");
            params4.put("groupsUserGroups", userId);
        }
        String sql = null;
        String sqlKey = this._buildSQLKey(params1, params2, params3, params4, obc, doUnion);
        sql = this._findByCompanyIdSQLCache.get(sqlKey);
        if (sql == null) {
            String findByC_C_SQL = CustomSQLUtil.get((String)FIND_BY_C_C);
            if (params.get("active") == Boolean.TRUE) {
                findByC_C_SQL = StringUtil.replace((String)findByC_C_SQL, (String)"(Group_.liveGroupId = 0) AND", (String)"");
            }
            findByC_C_SQL = StringUtil.replace((String)findByC_C_SQL, (String)"Group_.classNameId = ?", (String)"Group_.classNameId = ".concat(StringUtil.merge((long[])this._getGroupOrganizationClassNameIds(), (String)" OR Group_.classNameId = ")));
            findByC_C_SQL = this.replaceOrderBy(findByC_C_SQL, obc);
            StringBundler sb = new StringBundler();
            sb.append("(");
            sb.append(this.replaceJoinAndWhere(findByC_C_SQL, params1));
            sb.append(")");
            if (doUnion) {
                sb.append(" UNION (");
                sb.append(this.replaceJoinAndWhere(findByC_C_SQL, params2));
                sb.append(") UNION (");
                sb.append(this.replaceJoinAndWhere(findByC_C_SQL, params3));
                sb.append(") UNION (");
                sb.append(this.replaceJoinAndWhere(findByC_C_SQL, params4));
                sb.append(")");
            }
            if (obc != null) {
                sb.append(" ORDER BY ");
                sb.append(obc.toString());
            }
            sql = sb.toString();
            this._findByCompanyIdSQLCache.put(sqlKey, sql);
        }
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("groupId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params1);
            qPos.add(companyId);
            if (doUnion) {
                this.setJoin(qPos, params2);
                qPos.add(companyId);
                this.setJoin(qPos, params3);
                qPos.add(companyId);
                this.setJoin(qPos, params4);
                qPos.add(companyId);
            }
            List groupIds = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            ArrayList<Group> groups = new ArrayList<Group>(groupIds.size());
            for (Long groupId : groupIds) {
                Group group = GroupUtil.findByPrimaryKey((long)groupId);
                groups.add(group);
            }
            ArrayList<Group> arrayList = groups;
            return arrayList;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Long> findByC_P(long companyId, long parentGroupId, long previousGroupId, int size) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_P);
            if (previousGroupId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)"(groupId > ?) AND", (String)"");
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("groupId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (previousGroupId > 0L) {
                qPos.add(previousGroupId);
            }
            qPos.add(companyId);
            qPos.add(parentGroupId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)0, (int)size);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public Group findByC_N(long companyId, String name) throws NoSuchGroupException, SystemException {
        name = StringUtil.lowerCase((String)name);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_N);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(name);
            List groups = q.list();
            if (!groups.isEmpty()) {
                Group group = (Group)groups.get(0);
                return group;
            }
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
        StringBundler sb = new StringBundler(5);
        sb.append("No Group exists with the key {companyId=");
        sb.append(companyId);
        sb.append(", name=");
        sb.append(name);
        sb.append("}");
        throw new NoSuchGroupException(sb.toString());
    }

    public List<Group> findByC_C_PG_N_D(long companyId, long[] classNameIds, long parentGroupId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        boolean doUnion;
        String parentGroupIdComparator = "=";
        if (parentGroupId == -1L) {
            parentGroupIdComparator = "!=";
        }
        names = CustomSQLUtil.keywords((String[])names);
        descriptions = CustomSQLUtil.keywords((String[])descriptions);
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = null;
        LinkedHashMap<String, Object> params3 = null;
        LinkedHashMap<String, Object> params4 = null;
        Long userId = (Long)params.get("usersGroups");
        boolean inherit = GetterUtil.getBoolean((Object)params.get("inherit"), (boolean)true);
        boolean bl = doUnion = Validator.isNotNull((Long)userId) && inherit;
        if (doUnion) {
            params2 = new LinkedHashMap<String, Object>(params1);
            params2.remove("usersGroups");
            params2.put("groupOrg", userId);
            params3 = new LinkedHashMap<String, Object>(params1);
            params3.remove("usersGroups");
            params3.put("groupsOrgs", userId);
            params4 = new LinkedHashMap<String, Object>(params1);
            params4.remove("usersGroups");
            params4.put("groupsUserGroups", userId);
        }
        if (obc == null) {
            obc = new GroupNameComparator(true);
        }
        String sql = null;
        if (classNameIds == this._getGroupOrganizationClassNameIds()) {
            String sqlKey = this._buildSQLKey(params1, params2, params3, params4, obc, doUnion);
            sql = this._findByC_C_PG_N_DSQLCache.get(sqlKey);
        }
        if (sql == null) {
            String findByC_PG_N_D_SQL = CustomSQLUtil.get((String)FIND_BY_C_C_PG_N_D);
            findByC_PG_N_D_SQL = classNameIds == null ? StringUtil.replace((String)findByC_PG_N_D_SQL, (String)"AND (Group_.classNameId = ?)", (String)"") : StringUtil.replace((String)findByC_PG_N_D_SQL, (String)"Group_.classNameId = ?", (String)"Group_.classNameId = ".concat(StringUtil.merge((long[])classNameIds, (String)" OR Group_.classNameId = ")));
            findByC_PG_N_D_SQL = this.replaceOrderBy(findByC_PG_N_D_SQL, obc);
            StringBundler sb = new StringBundler();
            sb.append("(");
            sb.append(this.replaceJoinAndWhere(findByC_PG_N_D_SQL, params1));
            sb.append(")");
            if (doUnion) {
                sb.append(" UNION (");
                sb.append(this.replaceJoinAndWhere(findByC_PG_N_D_SQL, params2));
                sb.append(") UNION (");
                sb.append(this.replaceJoinAndWhere(findByC_PG_N_D_SQL, params3));
                sb.append(") UNION (");
                sb.append(this.replaceJoinAndWhere(findByC_PG_N_D_SQL, params4));
                sb.append(")");
            }
            if (obc != null) {
                sb.append(" ORDER BY ");
                sb.append(obc.toString());
            }
            sql = sb.toString();
            if (classNameIds == this._getGroupOrganizationClassNameIds()) {
                String sqlKey = this._buildSQLKey(params1, params2, params3, params4, obc, doUnion);
                this._findByC_C_PG_N_DSQLCache.put(sqlKey, sql);
            }
        }
        sql = StringUtil.replace(sql, (String)"[$PARENT_GROUP_ID_COMPARATOR$]", (String)(parentGroupIdComparator.equals("=") ? "=" : "!="));
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Group_.name)", (String)"LIKE", (boolean)false, (String[])names);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Group_.description)", (String)"LIKE", (boolean)true, (String[])descriptions);
        sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("groupId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params1);
            qPos.add(companyId);
            qPos.add(parentGroupId);
            qPos.add(names, 2);
            qPos.add(descriptions, 2);
            if (doUnion) {
                this.setJoin(qPos, params2);
                qPos.add(companyId);
                qPos.add(parentGroupId);
                qPos.add(names, 2);
                qPos.add(descriptions, 2);
                this.setJoin(qPos, params3);
                qPos.add(companyId);
                qPos.add(parentGroupId);
                qPos.add(names, 2);
                qPos.add(descriptions, 2);
                this.setJoin(qPos, params4);
                qPos.add(companyId);
                qPos.add(parentGroupId);
                qPos.add(names, 2);
                qPos.add(descriptions, 2);
            }
            List groupIds = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            ArrayList<Group> groups = new ArrayList<Group>(groupIds.size());
            for (Long groupId : groupIds) {
                Group group = GroupUtil.findByPrimaryKey((long)groupId);
                groups.add(group);
            }
            ArrayList<Group> arrayList = groups;
            return arrayList;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int countByGroupId(Session session, long groupId, LinkedHashMap<String, Object> params) throws Exception {
        Long count;
        String sql = CustomSQLUtil.get((String)COUNT_BY_GROUP_ID);
        sql = this.replaceJoinAndWhere(sql, params);
        SQLQuery q = session.createSQLQuery(sql);
        q.addScalar("COUNT_VALUE", Type.LONG);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        this.setJoin(qPos, params);
        qPos.add(groupId);
        Iterator itr = q.iterate();
        if (itr.hasNext() && (count = (Long)itr.next()) != null) {
            return count.intValue();
        }
        return 0;
    }

    protected List<Long> countByC_C_PG_N_D(Session session, long companyId, long[] classNameIds, long parentGroupId, String parentGroupIdComparator, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator) throws Exception {
        String sql = CustomSQLUtil.get((String)COUNT_BY_C_C_PG_N_D);
        sql = classNameIds == null ? StringUtil.replace((String)sql, (String)"AND (Group_.classNameId = ?)", (String)"") : StringUtil.replace((String)sql, (String)"Group_.classNameId = ?", (String)"Group_.classNameId = ".concat(StringUtil.merge((long[])classNameIds, (String)" OR Group_.classNameId = ")));
        sql = StringUtil.replace((String)sql, (String)"[$PARENT_GROUP_ID_COMPARATOR$]", (String)(parentGroupIdComparator.equals("=") ? "=" : "!="));
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Group_.name)", (String)"LIKE", (boolean)false, (String[])names);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Group_.description)", (String)"LIKE", (boolean)true, (String[])descriptions);
        sql = this.replaceJoinAndWhere(sql, params);
        sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
        SQLQuery q = session.createSQLQuery(sql);
        q.addScalar("groupId", Type.LONG);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        this.setJoin(qPos, params);
        qPos.add(companyId);
        qPos.add(parentGroupId);
        qPos.add(names, 2);
        qPos.add(descriptions, 2);
        return q.list(true);
    }

    protected String getJoin(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Map<String, String> joinMap;
            String joinValue;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (Validator.isNull((Object)value)) continue;
            if (key.equals("rolePermissions")) {
                List values = (List)value;
                String name = (String)values.get(0);
                key = ResourceBlockLocalServiceUtil.isSupported((String)name) ? "rolePermissions_6_block" : "rolePermissions_6";
            }
            if (!Validator.isNotNull((String)(joinValue = (joinMap = this._getJoinMap()).get(key)))) continue;
            sb.append(joinValue);
        }
        return sb.toString();
    }

    protected String getWhere(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Map<String, String> whereMap;
            String whereValue;
            String key = entry.getKey();
            if (key.equals("excludedGroupIds")) {
                List excludedGroupIds = (List)entry.getValue();
                if (excludedGroupIds.isEmpty()) continue;
                sb.append("(");
                int i2 = 0;
                while (i2 < excludedGroupIds.size()) {
                    sb.append("(Group_.groupId != ?)");
                    if (i2 + 1 < excludedGroupIds.size()) {
                        sb.append(" AND ");
                    }
                    ++i2;
                }
                sb.append(") AND ");
                continue;
            }
            if (key.equals("groupsTree")) {
                List groupsTree = (List)entry.getValue();
                if (groupsTree.isEmpty()) continue;
                sb.append("(");
                int i3 = 0;
                while (i3 < groupsTree.size()) {
                    sb.append("(Group_.treePath LIKE ?) ");
                    if (i3 + 1 < groupsTree.size()) {
                        sb.append("OR ");
                    }
                    ++i3;
                }
                sb.append(") AND ");
                continue;
            }
            if (key.equals("types")) {
                List types = (List)entry.getValue();
                if (types.isEmpty()) continue;
                sb.append("(");
                int i4 = 0;
                while (i4 < types.size()) {
                    sb.append("(Group_.type_ = ?) ");
                    if (i4 + 1 < types.size()) {
                        sb.append("OR ");
                    }
                    ++i4;
                }
                sb.append(") AND ");
                continue;
            }
            if (key.equals("rolePermissions")) {
                List values = (List)entry.getValue();
                String name = (String)values.get(0);
                key = ResourceBlockLocalServiceUtil.isSupported((String)name) ? "rolePermissions_6_block" : "rolePermissions_6";
            }
            if (!Validator.isNotNull((String)(whereValue = (whereMap = this._getWhereMap()).get(key)))) continue;
            sb.append(whereValue);
        }
        return sb.toString();
    }

    protected String replaceJoinAndWhere(String sql, LinkedHashMap<String, Object> params) {
        if (params.isEmpty()) {
            return StringUtil.replace((String)sql, (String[])new String[]{"[$JOIN$]", "[$WHERE$]"}, (String[])new String[]{"", ""});
        }
        String cacheKey = this._getCacheKey(sql, params);
        String resultSQL = this._replaceJoinAndWhereSQLCache.get(cacheKey);
        if (resultSQL == null) {
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            resultSQL = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            this._replaceJoinAndWhereSQLCache.put(cacheKey, resultSQL);
        }
        return resultSQL;
    }

    protected String replaceOrderBy(String sql, OrderByComparator obc) {
        if (obc instanceof GroupNameComparator) {
            sql = StringUtil.replace((String)sql, (String)"Group_.name AS groupName", (String)"REPLACE(Group_.name, ' LFR_ORGANIZATION', '') AS groupName");
        }
        return sql;
    }

    protected void setJoin(QueryPos qPos, LinkedHashMap<String, Object> params) throws Exception {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String valueString;
            List values;
            Object value;
            String key = entry.getKey();
            if (key.equals("active") || key.equals("layoutSet") || key.equals("manualMembership") || key.equals("site")) {
                value = (Boolean)entry.getValue();
                qPos.add((Boolean)value);
                continue;
            }
            if (key.equals("excludedGroupIds")) {
                List excludedGroupIds = (List)entry.getValue();
                if (excludedGroupIds.isEmpty()) continue;
                Iterator iterator = excludedGroupIds.iterator();
                while (iterator.hasNext()) {
                    long excludedGroupId = (Long)iterator.next();
                    qPos.add(excludedGroupId);
                }
                continue;
            }
            if (key.equals("groupsTree")) {
                List groupsTree = (List)entry.getValue();
                if (groupsTree.isEmpty()) continue;
                for (Group group : groupsTree) {
                    StringBundler sb = new StringBundler(5);
                    sb.append("%");
                    sb.append("/");
                    sb.append(group.getGroupId());
                    sb.append("/");
                    sb.append("%");
                    qPos.add(sb.toString());
                }
                continue;
            }
            if (key.equals("pageCount")) continue;
            if (key.equals("rolePermissions")) {
                values = (List)entry.getValue();
                String name = (String)values.get(0);
                Integer scope = (Integer)values.get(1);
                String actionId = (String)values.get(2);
                Long roleId = (Long)values.get(3);
                ResourceAction resourceAction = ResourceActionLocalServiceUtil.getResourceAction((String)name, (String)actionId);
                if (ResourceBlockLocalServiceUtil.isSupported((String)name)) {
                    qPos.add(name);
                    qPos.add(roleId);
                    qPos.add(resourceAction.getBitwiseValue());
                    continue;
                }
                qPos.add(name);
                qPos.add(scope);
                qPos.add(roleId);
                qPos.add(resourceAction.getBitwiseValue());
                continue;
            }
            if (key.equals("types")) {
                values = (List)entry.getValue();
                int i2 = 0;
                while (i2 < values.size()) {
                    Integer value2 = (Integer)values.get(i2);
                    qPos.add(value2);
                    ++i2;
                }
                continue;
            }
            if (key.equals("userGroupRole")) {
                values = (List)entry.getValue();
                Long userId = (Long)values.get(0);
                Long roleId = (Long)values.get(1);
                qPos.add(userId);
                qPos.add(roleId);
                continue;
            }
            value = entry.getValue();
            if (value instanceof Integer) {
                Integer valueInteger = (Integer)value;
                if (!Validator.isNotNull((Object)valueInteger)) continue;
                qPos.add(valueInteger);
                continue;
            }
            if (value instanceof Long) {
                Long valueLong = (Long)value;
                if (!Validator.isNotNull((Long)valueLong)) continue;
                qPos.add(valueLong);
                continue;
            }
            if (!(value instanceof String) || !Validator.isNotNull((String)(valueString = (String)value))) continue;
            qPos.add(valueString);
        }
    }

    private String _buildSQLKey(LinkedHashMap<String, Object> param1, LinkedHashMap<String, Object> param2, LinkedHashMap<String, Object> param3, LinkedHashMap<String, Object> param4, OrderByComparator obc, boolean doUnion) {
        StringBundler sb = null;
        if (doUnion) {
            sb = new StringBundler(param1.size() + param2.size() + param3.size() + param4.size() + 1);
            for (String key : param1.keySet()) {
                sb.append(key);
            }
            for (String key : param2.keySet()) {
                sb.append(key);
            }
            for (String key : param3.keySet()) {
                sb.append(key);
            }
            for (String key : param4.keySet()) {
                sb.append(key);
            }
        } else {
            sb = new StringBundler(param1.size() + 1);
            for (String key : param1.keySet()) {
                sb.append(key);
            }
        }
        sb.append(obc.getOrderBy());
        return sb.toString();
    }

    private String _getCacheKey(String sql, LinkedHashMap<String, Object> params) {
        StringBundler sb = new StringBundler();
        sb.append(sql);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            if (key.equals("rolePermissions")) {
                List values = (List)entry.getValue();
                String name = (String)values.get(0);
                key = ResourceBlockLocalServiceUtil.isSupported((String)name) ? "rolePermissions_6_block" : "rolePermissions_6";
            } else {
                List values;
                Object value = entry.getValue();
                if (value instanceof List && !(values = (List)value).isEmpty()) {
                    int i2 = 0;
                    while (i2 < values.size()) {
                        sb.append(key);
                        sb.append("-");
                        sb.append(i2);
                        ++i2;
                    }
                }
            }
            sb.append(key);
        }
        return sb.toString();
    }

    private String _getCondition(String join) {
        if (Validator.isNotNull((String)join)) {
            int pos = join.indexOf("WHERE");
            join = pos != -1 ? join.substring(pos + 5, join.length()).concat(" AND ") : "";
        }
        return join;
    }

    private long[] _getGroupOrganizationClassNameIds() {
        if (this._groupOrganizationClassNameIds == null) {
            this._groupOrganizationClassNameIds = new long[]{ClassNameLocalServiceUtil.getClassNameId(Group.class), ClassNameLocalServiceUtil.getClassNameId(Organization.class)};
        }
        return this._groupOrganizationClassNameIds;
    }

    private Map<String, String> _getJoinMap() {
        if (this._joinMap != null) {
            return this._joinMap;
        }
        HashMap<String, String> joinMap = new HashMap<String, String>();
        joinMap.put("active", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_ACTIVE)));
        joinMap.put("groupOrg", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUP_ORG)));
        joinMap.put("groupsOrgs", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ORGS)));
        joinMap.put("groupsRoles", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ROLES)));
        joinMap.put("groupsUserGroups", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUPS_USER_GROUPS)));
        joinMap.put("layoutSet", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_LAYOUT_SET)));
        joinMap.put("pageCount", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_PAGE_COUNT)));
        joinMap.put("membershipRestriction", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_MEMBERSHIP_RESTRICTION)));
        joinMap.put("rolePermissions_6", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_PERMISSIONS)));
        joinMap.put("rolePermissions_6_block", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_TYPE_PERMISSIONS)));
        joinMap.put("site", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_SITE)));
        joinMap.put("type", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_TYPE)));
        joinMap.put("userGroupRole", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_USER_GROUP_ROLE)));
        joinMap.put("usersGroups", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_USERS_GROUPS)));
        this._joinMap = joinMap;
        return this._joinMap;
    }

    private Map<String, String> _getWhereMap() {
        if (this._whereMap != null) {
            return this._whereMap;
        }
        HashMap<String, String> whereMap = new HashMap<String, String>();
        whereMap.put("active", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_ACTIVE)));
        whereMap.put("creatorUserId", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_CREATOR_USER_ID)));
        whereMap.put("groupOrg", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUP_ORG)));
        whereMap.put("groupsOrgs", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ORGS)));
        whereMap.put("groupsRoles", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ROLES)));
        whereMap.put("groupsUserGroups", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUPS_USER_GROUPS)));
        whereMap.put("layoutSet", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_LAYOUT_SET)));
        whereMap.put("manualMembership", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_MANUAL_MEMBERSHIP)));
        whereMap.put("membershipRestriction", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_MEMBERSHIP_RESTRICTION)));
        whereMap.put("pageCount", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_PAGE_COUNT)));
        whereMap.put("rolePermissions_6", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_PERMISSIONS)));
        whereMap.put("rolePermissions_6_block", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_TYPE_PERMISSIONS)));
        whereMap.put("site", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_SITE)));
        whereMap.put("type", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_TYPE)));
        whereMap.put("userGroupRole", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_USER_GROUP_ROLE)));
        whereMap.put("usersGroups", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_USERS_GROUPS)));
        this._whereMap = whereMap;
        return this._whereMap;
    }

    private String _removeWhere(String join) {
        int pos;
        if (Validator.isNotNull((String)join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }
}

