/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.servlet.BrowserSniffer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class BrowserSnifferImpl
implements BrowserSniffer {
    protected static String[] revisionLeadings = new String[]{"rv", "it", "ra", "ie"};
    protected static char[] revisionSeparators = new char[]{'\\', ':', '/', ' '};
    protected static String[] versionLeadings = new String[]{"version", "firefox", "minefield", "chrome"};
    protected static char[] versionSeparators = new char[]{'\\', '/'};
    private static final String[] _FIREFOX_ALIASES = new String[]{"firefox", "minefield", "granparadiso", "bonecho", "firebird", "phoenix", "camino"};
    private static final String[] _WEBKIT_ALIASES = new String[]{"khtml", "applewebkit"};
    private static final String[] _WINDOWS_ALIASES = new String[]{"windows", "win32", "16bit"};

    public boolean acceptsGzip(HttpServletRequest request) {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.contains("gzip");
    }

    public String getBrowserId(HttpServletRequest request) {
        if (this.isIe(request)) {
            return "ie";
        }
        if (this.isFirefox(request)) {
            return "firefox";
        }
        return "other";
    }

    public float getMajorVersion(HttpServletRequest request) {
        return GetterUtil.getFloat((String)this.getVersion(request));
    }

    public String getRevision(HttpServletRequest request) {
        String revision = (String)request.getAttribute("BROWSER_SNIFFER_REVISION");
        if (revision != null) {
            return revision;
        }
        revision = BrowserSnifferImpl.parseVersion(this.getUserAgent(request), revisionLeadings, revisionSeparators);
        request.setAttribute("BROWSER_SNIFFER_REVISION", (Object)revision);
        return revision;
    }

    public String getVersion(HttpServletRequest request) {
        String version = (String)request.getAttribute("BROWSER_SNIFFER_VERSION");
        if (version != null) {
            return version;
        }
        String userAgent = this.getUserAgent(request);
        version = BrowserSnifferImpl.parseVersion(userAgent, versionLeadings, versionSeparators);
        if (version.isEmpty()) {
            version = BrowserSnifferImpl.parseVersion(userAgent, revisionLeadings, revisionSeparators);
        }
        request.setAttribute("BROWSER_SNIFFER_VERSION", (Object)version);
        return version;
    }

    public boolean isAir(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("adobeair");
    }

    public boolean isAndroid(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("android");
    }

    public boolean isChrome(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("chrome");
    }

    public boolean isFirefox(HttpServletRequest request) {
        if (!this.isMozilla(request)) {
            return false;
        }
        String userAgent = this.getUserAgent(request);
        String[] stringArray = _FIREFOX_ALIASES;
        int n = _FIREFOX_ALIASES.length;
        int n2 = 0;
        while (n2 < n) {
            String firefoxAlias = stringArray[n2];
            if (userAgent.contains(firefoxAlias)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isGecko(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("gecko");
    }

    public boolean isIe(HttpServletRequest request) {
        return this.isIe(this.getUserAgent(request));
    }

    public boolean isIeOnWin32(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return this.isIe(userAgent) && !userAgent.contains("wow64") && !userAgent.contains("win64");
    }

    public boolean isIeOnWin64(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return this.isIe(userAgent) && (userAgent.contains("wow64") || userAgent.contains("win64"));
    }

    public boolean isIphone(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("iphone");
    }

    public boolean isLinux(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("linux");
    }

    public boolean isMac(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("mac");
    }

    public boolean isMobile(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("mobile") || this.isAndroid(request) && userAgent.contains("nexus");
    }

    public boolean isMozilla(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("mozilla") && !userAgent.contains("compatible") && !userAgent.contains("webkit");
    }

    public boolean isOpera(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("opera");
    }

    public boolean isRtf(HttpServletRequest request) {
        if (this.isAndroid(request)) {
            return true;
        }
        if (this.isChrome(request)) {
            return true;
        }
        float majorVersion = this.getMajorVersion(request);
        if (this.isIe(request) && (double)majorVersion >= 5.5) {
            return true;
        }
        if (this.isMozilla(request) && (double)majorVersion >= 1.3) {
            return true;
        }
        if (this.isOpera(request)) {
            if (this.isMobile(request) && (double)majorVersion >= 10.0) {
                return true;
            }
            if (!this.isMobile(request)) {
                return true;
            }
        }
        if (this.isSafari(request)) {
            if (this.isMobile(request) && (double)majorVersion >= 5.0) {
                return true;
            }
            if (!this.isMobile(request) && (double)majorVersion >= 3.0) {
                return true;
            }
        }
        return false;
    }

    public boolean isSafari(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return this.isWebKit(request) && userAgent.contains("safari");
    }

    public boolean isSun(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("sunos");
    }

    public boolean isWap(HttpServletRequest request) {
        return this.isWapXhtml(request);
    }

    public boolean isWapXhtml(HttpServletRequest request) {
        String accept = this.getAccept(request);
        return PropsValues.MOBILE_DEVICE_STYLING_WAP_ENABLED && accept.contains("wap.xhtml");
    }

    public boolean isWebKit(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        String[] stringArray = _WEBKIT_ALIASES;
        int n = _WEBKIT_ALIASES.length;
        int n2 = 0;
        while (n2 < n) {
            String webKitAlias = stringArray[n2];
            if (userAgent.contains(webKitAlias)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isWindows(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        String[] stringArray = _WINDOWS_ALIASES;
        int n = _WINDOWS_ALIASES.length;
        int n2 = 0;
        while (n2 < n) {
            String windowsAlias = stringArray[n2];
            if (userAgent.contains(windowsAlias)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isWml(HttpServletRequest request) {
        String accept = this.getAccept(request);
        return accept.contains("wap.wml");
    }

    protected static String parseVersion(String userAgent, String[] leadings, char[] separators) {
        String[] stringArray = leadings;
        int n = leadings.length;
        int n2 = 0;
        while (n2 < n) {
            String leading = stringArray[n2];
            int index = 0;
            while ((index = userAgent.indexOf(leading, index)) >= 0 && (index += leading.length()) + 2 <= userAgent.length()) {
                char c2;
                char c1 = userAgent.charAt(index);
                if (((c2 = userAgent.charAt(++index)) < '0' || c2 > '9') && c2 != '.') continue;
                char[] cArray = separators;
                int n3 = separators.length;
                int n4 = 0;
                while (n4 < n3) {
                    char separator = cArray[n4];
                    if (c1 != separator) {
                        ++n4;
                        continue;
                    }
                    int majorStart = index;
                    int majorEnd = index + 1;
                    int i2 = majorStart;
                    while (i2 < userAgent.length()) {
                        char c3 = userAgent.charAt(i2);
                        if (c3 < '0' || c3 > '9') {
                            majorEnd = i2;
                            break;
                        }
                        ++i2;
                    }
                    String major = userAgent.substring(majorStart, majorEnd);
                    if (userAgent.charAt(majorEnd) != '.') {
                        return major;
                    }
                    int minorStart = majorEnd + 1;
                    int minorEnd = userAgent.length();
                    int i3 = minorStart;
                    while (i3 < userAgent.length()) {
                        char c4 = userAgent.charAt(i3);
                        if (c4 < '0' || c4 > '9') {
                            minorEnd = i3;
                            break;
                        }
                        ++i3;
                    }
                    String minor = userAgent.substring(minorStart, minorEnd);
                    return major.concat(".").concat(minor);
                }
            }
            ++n2;
        }
        return "";
    }

    protected String getAccept(HttpServletRequest request) {
        String accept = "";
        if (request == null) {
            return accept;
        }
        accept = String.valueOf(request.getAttribute("ACCEPT"));
        if (Validator.isNotNull((String)accept)) {
            return accept;
        }
        accept = request.getHeader("ACCEPT");
        accept = accept != null ? StringUtil.toLowerCase((String)accept) : "";
        request.setAttribute("ACCEPT", (Object)accept);
        return accept;
    }

    protected String getUserAgent(HttpServletRequest request) {
        String userAgent = "";
        if (request == null) {
            return userAgent;
        }
        userAgent = String.valueOf(request.getAttribute("User-Agent"));
        if (Validator.isNotNull((String)userAgent)) {
            return userAgent;
        }
        userAgent = request.getHeader("User-Agent");
        userAgent = userAgent != null ? StringUtil.toLowerCase((String)userAgent) : "";
        request.setAttribute("User-Agent", (Object)userAgent);
        return userAgent;
    }

    protected boolean isIe(String userAgent) {
        return (userAgent.contains("msie") || userAgent.contains("trident")) && !userAgent.contains("opera");
    }
}

