/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.servlet.DirectRequestDispatcherFactory;
import com.liferay.portal.kernel.servlet.DirectServletRegistryUtil;
import com.liferay.portal.kernel.util.ContextPathUtil;
import com.liferay.portal.servlet.ClassLoaderRequestDispatcherWrapper;
import com.liferay.portal.servlet.DirectRequestDispatcher;
import com.liferay.portal.servlet.DirectServletPathRegisterDispatcher;
import com.liferay.portal.util.PropsValues;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;

@DoPrivileged
public class DirectRequestDispatcherFactoryImpl
implements DirectRequestDispatcherFactory {
    private static Log _log = LogFactoryUtil.getLog(DirectRequestDispatcherFactoryImpl.class);
    private static PACL _pacl = new NoPACL();

    public RequestDispatcher getRequestDispatcher(ServletContext servletContext, String path) {
        RequestDispatcher requestDispatcher = this.doGetRequestDispatcher(servletContext, path);
        return new ClassLoaderRequestDispatcherWrapper(servletContext, requestDispatcher);
    }

    public RequestDispatcher getRequestDispatcher(ServletRequest servletRequest, String path) {
        ServletContext servletContext = (ServletContext)servletRequest.getAttribute("CTX");
        if (servletContext == null) {
            return servletRequest.getRequestDispatcher(path);
        }
        return this.getRequestDispatcher(servletContext, path);
    }

    protected RequestDispatcher doGetRequestDispatcher(ServletContext servletContext, String path) {
        if (!PropsValues.DIRECT_SERVLET_CONTEXT_ENABLED) {
            return servletContext.getRequestDispatcher(path);
        }
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path " + path + " is not relative to context root");
        }
        String contextPath = ContextPathUtil.getContextPath((ServletContext)servletContext);
        String fullPath = contextPath.concat(path);
        String queryString = null;
        int pos = fullPath.indexOf(63);
        if (pos != -1) {
            queryString = fullPath.substring(pos + 1);
            fullPath = fullPath.substring(0, pos);
        }
        Servlet servlet = DirectServletRegistryUtil.getServlet((String)fullPath);
        RequestDispatcher requestDispatcher = null;
        if (servlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No servlet found for " + fullPath));
            }
            requestDispatcher = servletContext.getRequestDispatcher(path);
            requestDispatcher = new DirectServletPathRegisterDispatcher(path, requestDispatcher);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Servlet found for " + fullPath));
            }
            requestDispatcher = new DirectRequestDispatcher(servlet, queryString);
        }
        return _pacl.getRequestDispatcher(servletContext, requestDispatcher);
    }

    private static class NoPACL
    implements PACL {
        private NoPACL() {
        }

        @Override
        public RequestDispatcher getRequestDispatcher(ServletContext servletContext, RequestDispatcher requestDispatcher) {
            return requestDispatcher;
        }
    }

    public static interface PACL {
        public RequestDispatcher getRequestDispatcher(ServletContext var1, RequestDispatcher var2);
    }
}

