/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.audit;

import com.liferay.portal.kernel.audit.AuditRequestThreadLocal;
import com.liferay.portal.kernel.servlet.TryFilter;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuditFilter
extends BasePortalFilter
implements TryFilter {
    public Object doFilterTry(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditRequestThreadLocal auditRequestThreadLocal = AuditRequestThreadLocal.getAuditThreadLocal();
        auditRequestThreadLocal.setClientHost(request.getRemoteHost());
        auditRequestThreadLocal.setClientIP(this.getRemoteAddr(request));
        auditRequestThreadLocal.setQueryString(request.getQueryString());
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("USER_ID");
        if (userId != null) {
            auditRequestThreadLocal.setRealUserId(userId.longValue());
        }
        auditRequestThreadLocal.setRequestURL(request.getRequestURL().toString());
        auditRequestThreadLocal.setServerName(request.getServerName());
        auditRequestThreadLocal.setServerPort(request.getServerPort());
        auditRequestThreadLocal.setSessionID(session.getId());
        return null;
    }

    protected String getRemoteAddr(HttpServletRequest request) {
        String remoteAddr = request.getHeader("X-Forwarded-For");
        if (remoteAddr != null) {
            return remoteAddr;
        }
        return request.getRemoteAddr();
    }
}

