/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.util.Converter;
import com.liferay.portal.kernel.util.PreloadClassLoader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javassist.util.proxy.ProxyFactory;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class PortalHibernateConfiguration
extends LocalSessionFactoryBean {
    private static final String[] _PRELOAD_CLASS_NAMES = PropsValues.SPRING_HIBERNATE_CONFIGURATION_PROXY_FACTORY_PRELOAD_CLASSLOADER_CLASSES;
    private static Log _log = LogFactoryUtil.getLog(PortalHibernateConfiguration.class);
    private static Map<ProxyFactory, ClassLoader> _proxyFactoryClassLoaders = new WeakHashMap<ProxyFactory, ClassLoader>();
    private Converter<String> _hibernateConfigurationConverter;

    static {
        ProxyFactory.classLoaderProvider = new ProxyFactory.ClassLoaderProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ClassLoader get(ProxyFactory proxyFactory) {
                Map map = _proxyFactoryClassLoaders;
                synchronized (map) {
                    ClassLoader contextClassLoader;
                    ClassLoader classLoader = (ClassLoader)_proxyFactoryClassLoaders.get(proxyFactory);
                    if (classLoader != null) {
                        return classLoader;
                    }
                    classLoader = ClassLoaderUtil.getPortalClassLoader();
                    if (classLoader != (contextClassLoader = ClassLoaderUtil.getContextClassLoader())) {
                        classLoader = new PreloadClassLoader(contextClassLoader, PortalHibernateConfiguration.getPreloadClassLoaderClasses());
                    }
                    _proxyFactoryClassLoaders.put(proxyFactory, classLoader);
                    return classLoader;
                }
            }
        };
    }

    public SessionFactory buildSessionFactory() throws Exception {
        this.setBeanClassLoader(this.getConfigurationClassLoader());
        return super.buildSessionFactory();
    }

    public void destroy() throws HibernateException {
        this.setBeanClassLoader(null);
        super.destroy();
    }

    public void setHibernateConfigurationConverter(Converter<String> hibernateConfigurationConverter) {
        this._hibernateConfigurationConverter = hibernateConfigurationConverter;
    }

    protected static Map<String, Class<?>> getPreloadClassLoaderClasses() {
        try {
            HashMap classes = new HashMap();
            String[] stringArray = _PRELOAD_CLASS_NAMES;
            int n = _PRELOAD_CLASS_NAMES.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                ClassLoader portalClassLoader = ClassLoaderUtil.getPortalClassLoader();
                Class<?> clazz = portalClassLoader.loadClass(className);
                classes.put(className, clazz);
                ++n2;
            }
            return classes;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    protected Dialect determineDialect() {
        return DialectDetector.getDialect(this.getDataSource());
    }

    protected ClassLoader getConfigurationClassLoader() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return clazz.getClassLoader();
    }

    protected String[] getConfigurationResources() {
        return PropsUtil.getArray("hibernate.configs");
    }

    protected Configuration newConfiguration() {
        Configuration configuration = new Configuration();
        try {
            String[] resources;
            String[] stringArray = resources = this.getConfigurationResources();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    String resource = stringArray[n2];
                    try {
                        this.readResource(configuration, resource);
                    }
                    catch (Exception e2) {
                        if (!_log.isWarnEnabled()) break block9;
                        _log.warn((Object)e2, (Throwable)e2);
                    }
                }
                ++n2;
            }
            Properties properties = PropsUtil.getProperties();
            if (SPIUtil.isSPI()) {
                properties.put("hibernate.cache.use_query_cache", Boolean.FALSE.toString());
                properties.put("hibernate.cache.use_second_level_cache", Boolean.FALSE.toString());
            }
            configuration.setProperties(properties);
            if (Validator.isNull((String)PropsValues.HIBERNATE_DIALECT)) {
                Dialect dialect = this.determineDialect();
                this.setDB(dialect);
                Class<?> clazz = dialect.getClass();
                configuration.setProperty("hibernate.dialect", clazz.getName());
            }
            DB db = DBFactoryUtil.getDB();
            String dbType = db.getType();
            dbType.equals("hypersonic");
        }
        catch (Exception e1) {
            _log.error((Object)e1, (Throwable)e1);
        }
        Properties hibernateProperties = this.getHibernateProperties();
        if (hibernateProperties != null) {
            for (Map.Entry<Object, Object> entry : hibernateProperties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                configuration.setProperty(key, value);
            }
        }
        return configuration;
    }

    protected void postProcessConfiguration(Configuration configuration) {
        String connectionReleaseMode = PropsUtil.get("hibernate.connection.release_mode");
        if (Validator.isNotNull((String)connectionReleaseMode)) {
            configuration.setProperty("hibernate.connection.release_mode", connectionReleaseMode);
        }
    }

    protected void readResource(Configuration configuration, InputStream inputStream) throws Exception {
        if (inputStream == null) {
            return;
        }
        if (this._hibernateConfigurationConverter != null) {
            String configurationString = StringUtil.read((InputStream)inputStream);
            configurationString = (String)this._hibernateConfigurationConverter.convert((Object)configurationString);
            inputStream = new UnsyncByteArrayInputStream(configurationString.getBytes());
        }
        configuration = configuration.addInputStream(inputStream);
        inputStream.close();
    }

    protected void readResource(Configuration configuration, String resource) throws Exception {
        ClassLoader classLoader = this.getConfigurationClassLoader();
        if (resource.startsWith("classpath*:")) {
            String name = resource.substring("classpath*:".length());
            Enumeration<URL> enu = classLoader.getResources(name);
            if (_log.isDebugEnabled() && !enu.hasMoreElements()) {
                _log.debug((Object)("No resources found for " + name));
            }
            while (enu.hasMoreElements()) {
                URL url = enu.nextElement();
                InputStream inputStream = url.openStream();
                this.readResource(configuration, inputStream);
            }
        } else {
            InputStream inputStream = classLoader.getResourceAsStream(resource);
            this.readResource(configuration, inputStream);
        }
    }

    protected void setDB(Dialect dialect) {
        DBFactoryUtil.setDB((Object)dialect);
    }
}

