/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.concurrent.ThrowableAwareRunnable;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class VerifyGroupId
extends VerifyProcess {
    private static final String[][] _MODELS = new String[][]{{"MBDiscussion", "discussionId", "MBThread", "threadId"}, {"MBThreadFlag", "threadFlagId", "MBThread", "threadId"}, {"PollsChoice", "choiceId", "PollsQuestion", "questionId"}, {"PollsVote", "voteId", "PollsQuestion", "questionId"}};
    private static Log _log = LogFactoryUtil.getLog(VerifyGroupId.class);

    @Override
    protected void doVerify() throws Exception {
        ArrayList<String> pendingModels = new ArrayList<String>();
        String[][] stringArray = _MODELS;
        int n = _MODELS.length;
        int n2 = 0;
        while (n2 < n) {
            String[] model = stringArray[n2];
            pendingModels.add(model[0]);
            ++n2;
        }
        ArrayList<VerifiableGroupedModelRunnable> verifiableGroupedModelRunnables = new ArrayList<VerifiableGroupedModelRunnable>(_MODELS.length);
        while (!pendingModels.isEmpty()) {
            int count = pendingModels.size();
            String[][] stringArray2 = _MODELS;
            int n3 = _MODELS.length;
            int n4 = 0;
            while (n4 < n3) {
                String[] model = stringArray2[n4];
                if (!pendingModels.contains(model[2]) && pendingModels.contains(model[0])) {
                    VerifiableGroupedModelRunnable verifyAuditedModelRunnable = new VerifiableGroupedModelRunnable(model[0], model[1], model[2], model[3]);
                    verifiableGroupedModelRunnables.add(verifyAuditedModelRunnable);
                    this.verifyModel(model[0], model[1], model[2], model[3]);
                    pendingModels.remove(model[0]);
                }
                ++n4;
            }
            if (pendingModels.size() != count) continue;
            throw new VerifyException("Circular dependency detected " + pendingModels);
        }
        this.doVerify(verifiableGroupedModelRunnables);
    }

    protected long getGroupId(String modelName, String pkColumnName, long primKey) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block4: {
            block3: {
                long l;
                con = null;
                ps = null;
                rs = null;
                try {
                    con = DataAccess.getUpgradeOptimizedConnection();
                    ps = con.prepareStatement("select groupId from " + modelName + " where " + pkColumnName + " = ?");
                    ps.setLong(1, primKey);
                    rs = ps.executeQuery();
                    if (!rs.next()) break block3;
                    l = rs.getLong("groupId");
                }
                catch (Throwable throwable) {
                    DataAccess.cleanUp((Connection)con, ps, rs);
                    throw throwable;
                }
                DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
                return l;
            }
            if (!_log.isDebugEnabled()) break block4;
            _log.debug((Object)("Unable to find " + modelName + " " + primKey));
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return 0L;
    }

    protected void verifyModel(String modelName, String pkColumnName, String relatedModelName, String relatedPKColumnName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select " + pkColumnName + ", " + relatedPKColumnName + " from " + modelName + " where " + "groupId is null");
            rs = ps.executeQuery();
            while (rs.next()) {
                long primKey = rs.getLong(pkColumnName);
                long relatedPrimKey = rs.getLong(relatedPKColumnName);
                long groupId = this.getGroupId(relatedModelName, relatedPKColumnName, relatedPrimKey);
                if (groupId <= 0L) continue;
                this.runSQL("update " + modelName + " set groupId = " + groupId + " where " + pkColumnName + " = " + primKey);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    private class VerifiableGroupedModelRunnable
    extends ThrowableAwareRunnable {
        private final String _modelName;
        private final String _pkColumnName;
        private final String _relatedModelName;
        private final String _relatedPKColumnName;

        private VerifiableGroupedModelRunnable(String modelName, String pkColumnName, String relatedModelName, String relatedPKColumnName) {
            this._modelName = modelName;
            this._pkColumnName = pkColumnName;
            this._relatedModelName = relatedModelName;
            this._relatedPKColumnName = relatedPKColumnName;
        }

        protected void doRun() throws Exception {
            VerifyGroupId.this.verifyModel(this._modelName, this._pkColumnName, this._relatedModelName, this._relatedPKColumnName);
        }
    }
}

