/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.base.BookmarksEntryServiceBaseImpl;
import com.liferay.portlet.bookmarks.service.permission.BookmarksEntryPermission;
import com.liferay.portlet.bookmarks.service.permission.BookmarksFolderPermission;
import com.liferay.portlet.bookmarks.util.comparator.EntryModifiedDateComparator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BookmarksEntryServiceImpl
extends BookmarksEntryServiceBaseImpl {
    public BookmarksEntry addEntry(long groupId, long folderId, String name, String url, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_ENTRY");
        return this.bookmarksEntryLocalService.addEntry(this.getUserId(), groupId, folderId, name, url, description, serviceContext);
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "DELETE");
        this.bookmarksEntryLocalService.deleteEntry(entryId);
    }

    public List<BookmarksEntry> getEntries(long groupId, long folderId, int start, int end) throws SystemException {
        return this.bookmarksEntryPersistence.filterFindByG_F_S(groupId, folderId, 0, start, end);
    }

    public List<BookmarksEntry> getEntries(long groupId, long folderId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.bookmarksEntryPersistence.filterFindByG_F_S(groupId, folderId, 0, start, end, orderByComparator);
    }

    public int getEntriesCount(long groupId, long folderId) throws SystemException {
        return this.getEntriesCount(groupId, folderId, 0);
    }

    public int getEntriesCount(long groupId, long folderId, int status) throws SystemException {
        if (status == -1) {
            return this.bookmarksEntryPersistence.filterCountByG_F_NotS(groupId, folderId, 8);
        }
        return this.bookmarksEntryPersistence.filterCountByG_F_S(groupId, folderId, status);
    }

    public BookmarksEntry getEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "VIEW");
        return this.bookmarksEntryLocalService.getEntry(entryId);
    }

    public int getFoldersEntriesCount(long groupId, List<Long> folderIds) throws SystemException {
        return this.bookmarksEntryPersistence.filterCountByG_F_S(groupId, ArrayUtil.toArray((Long[])folderIds.toArray(new Long[folderIds.size()])), 0);
    }

    public List<BookmarksEntry> getGroupEntries(long groupId, int start, int end) throws PortalException, SystemException {
        return this.getGroupEntries(groupId, 0L, 0L, start, end);
    }

    public List<BookmarksEntry> getGroupEntries(long groupId, long userId, int start, int end) throws PortalException, SystemException {
        return this.getGroupEntries(groupId, userId, 0L, start, end);
    }

    public List<BookmarksEntry> getGroupEntries(long groupId, long userId, long rootFolderId, int start, int end) throws PortalException, SystemException {
        if (rootFolderId == 0L) {
            if (userId <= 0L) {
                return this.bookmarksEntryPersistence.filterFindByG_NotS(groupId, 8, start, end, (OrderByComparator)new EntryModifiedDateComparator());
            }
            return this.bookmarksEntryPersistence.filterFindByG_U_NotS(groupId, userId, 8, start, end, (OrderByComparator)new EntryModifiedDateComparator());
        }
        List folderIds = this.bookmarksFolderService.getFolderIds(groupId, rootFolderId);
        if (folderIds.size() == 0) {
            return Collections.emptyList();
        }
        if (userId <= 0L) {
            return this.bookmarksEntryPersistence.filterFindByG_F_S(groupId, ArrayUtil.toLongArray((Collection)folderIds), 0, start, end, (OrderByComparator)new EntryModifiedDateComparator());
        }
        return this.bookmarksEntryPersistence.filterFindByG_U_F_S(groupId, userId, ArrayUtil.toLongArray((Collection)folderIds), 0, start, end, (OrderByComparator)new EntryModifiedDateComparator());
    }

    public int getGroupEntriesCount(long groupId) throws PortalException, SystemException {
        return this.getGroupEntriesCount(groupId, 0L);
    }

    public int getGroupEntriesCount(long groupId, long userId) throws PortalException, SystemException {
        return this.getGroupEntriesCount(groupId, userId, 0L);
    }

    public int getGroupEntriesCount(long groupId, long userId, long rootFolderId) throws PortalException, SystemException {
        if (rootFolderId == 0L) {
            if (userId <= 0L) {
                return this.bookmarksEntryPersistence.filterCountByG_NotS(groupId, 8);
            }
            return this.bookmarksEntryPersistence.filterCountByG_U_NotS(groupId, userId, 8);
        }
        List folderIds = this.bookmarksFolderService.getFolderIds(groupId, rootFolderId);
        if (folderIds.size() == 0) {
            return 0;
        }
        if (userId <= 0L) {
            return this.bookmarksEntryPersistence.filterCountByG_F_S(groupId, ArrayUtil.toLongArray((Collection)folderIds), 0);
        }
        return this.bookmarksEntryPersistence.filterCountByG_U_F_S(groupId, userId, ArrayUtil.toLongArray((Collection)folderIds), 0);
    }

    public BookmarksEntry moveEntry(long entryId, long parentFolderId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "UPDATE");
        return this.bookmarksEntryLocalService.moveEntry(entryId, parentFolderId);
    }

    public BookmarksEntry moveEntryFromTrash(long entryId, long parentFolderId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "UPDATE");
        return this.bookmarksEntryLocalService.moveEntryFromTrash(this.getUserId(), entryId, parentFolderId);
    }

    public BookmarksEntry moveEntryToTrash(long entryId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "DELETE");
        return this.bookmarksEntryLocalService.moveEntryToTrash(this.getUserId(), entryId);
    }

    public BookmarksEntry openEntry(BookmarksEntry entry) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entry, "VIEW");
        return this.bookmarksEntryLocalService.openEntry(this.getGuestOrUserId(), entry);
    }

    public BookmarksEntry openEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "VIEW");
        return this.bookmarksEntryLocalService.openEntry(this.getGuestOrUserId(), entryId);
    }

    public void restoreEntryFromTrash(long entryId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "UPDATE");
        this.bookmarksEntryLocalService.restoreEntryFromTrash(this.getUserId(), entryId);
    }

    public Hits search(long groupId, long creatorUserId, int status, int start, int end) throws PortalException, SystemException {
        return this.bookmarksEntryLocalService.search(groupId, this.getUserId(), creatorUserId, status, start, end);
    }

    public void subscribeEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "SUBSCRIBE");
        this.bookmarksEntryLocalService.subscribeEntry(this.getUserId(), entryId);
    }

    public void unsubscribeEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "SUBSCRIBE");
        this.bookmarksEntryLocalService.unsubscribeEntry(this.getUserId(), entryId);
    }

    public BookmarksEntry updateEntry(long entryId, long groupId, long folderId, String name, String url, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "UPDATE");
        return this.bookmarksEntryLocalService.updateEntry(this.getUserId(), entryId, groupId, folderId, name, url, description, serviceContext);
    }
}

