/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.lar;

import com.liferay.portal.kernel.lar.DataLevel;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.model.StagedModel;
import com.liferay.portlet.dynamicdatalists.lar.DDLPortletDataHandler;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DDLDisplayPortletDataHandler
extends DDLPortletDataHandler {
    private static Log _log = LogFactoryUtil.getLog(DDLDisplayPortletDataHandler.class);

    public DDLDisplayPortletDataHandler() {
        this.setDataLevel(DataLevel.PORTLET_INSTANCE);
        this.setDataPortletPreferences(new String[]{"displayDDMTemplateId", "formDDMTemplateId", "recordSetId"});
        this.setExportControls(new PortletDataHandlerControl[0]);
    }

    @Override
    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletPreferences == null) {
            return portletPreferences;
        }
        portletPreferences.setValue("displayDDMTemplateId", "");
        portletPreferences.setValue("editable", Boolean.TRUE.toString());
        portletPreferences.setValue("formDDMTemplateId", "");
        portletPreferences.setValue("recordSetId", "");
        portletPreferences.setValue("spreadsheet", Boolean.FALSE.toString());
        return portletPreferences;
    }

    protected PortletPreferences doProcessExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortletPermissions("com.liferay.portlet.dynamicdatalists");
        long recordSetId = GetterUtil.getLong((String)portletPreferences.getValue("recordSetId", null), (long)0L);
        if (recordSetId == 0L) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get record set with ID " + portletId));
            }
            return portletPreferences;
        }
        DDLRecordSet recordSet = DDLRecordSetLocalServiceUtil.fetchRecordSet((long)recordSetId);
        if (recordSet == null) {
            return portletPreferences;
        }
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)recordSet);
        return portletPreferences;
    }

    protected PortletPreferences doProcessImportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.portlet.dynamicdatalists");
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, DDLRecordSet.class);
        long importedRecordSetId = GetterUtil.getLong((String)portletPreferences.getValue("recordSetId", null));
        long importedDisplayDDMTemplateId = GetterUtil.getLong((String)portletPreferences.getValue("displayDDMTemplateId", null));
        long importedFormDDMTemplateId = GetterUtil.getLong((String)portletPreferences.getValue("formDDMTemplateId", null));
        Map recordSetIds = portletDataContext.getNewPrimaryKeysMap(DDLRecordSet.class);
        long recordSetId = MapUtil.getLong((Map)recordSetIds, (long)importedRecordSetId, (long)importedRecordSetId);
        Map templateIds = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class);
        long displayDDMTemplateId = MapUtil.getLong((Map)templateIds, (long)importedDisplayDDMTemplateId, (long)importedDisplayDDMTemplateId);
        long formDDMTemplateId = MapUtil.getLong((Map)templateIds, (long)importedFormDDMTemplateId, (long)importedFormDDMTemplateId);
        portletPreferences.setValue("recordSetId", String.valueOf(recordSetId));
        portletPreferences.setValue("displayDDMTemplateId", String.valueOf(displayDDMTemplateId));
        portletPreferences.setValue("formDDMTemplateId", String.valueOf(formDDMTemplateId));
        return portletPreferences;
    }
}

