/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.service.JournalFeedLocalServiceUtil;

public class JournalFeedPermission {
    public static void check(PermissionChecker permissionChecker, JournalFeed feed, String actionId) throws PortalException {
        if (!JournalFeedPermission.contains(permissionChecker, feed, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long id, String actionId) throws PortalException, SystemException {
        if (!JournalFeedPermission.contains(permissionChecker, id, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String feedId, String actionId) throws PortalException, SystemException {
        if (!JournalFeedPermission.contains(permissionChecker, groupId, feedId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, JournalFeed feed, String actionId) {
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)feed.getGroupId(), (String)JournalFeed.class.getName(), (long)feed.getPrimaryKey(), (String)"15", (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(feed.getCompanyId(), JournalFeed.class.getName(), feed.getId(), feed.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(feed.getGroupId(), JournalFeed.class.getName(), feed.getId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long feedId, String actionId) throws PortalException, SystemException {
        JournalFeed feed = JournalFeedLocalServiceUtil.getFeed((long)feedId);
        return JournalFeedPermission.contains(permissionChecker, feed, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String feedId, String actionId) throws PortalException, SystemException {
        JournalFeed feed = JournalFeedLocalServiceUtil.getFeed((long)groupId, (String)feedId);
        return JournalFeedPermission.contains(permissionChecker, feed, actionId);
    }
}

