/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journalcontent.util;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journalcontent.util.JournalContent;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.StopWatch;

@DoPrivileged
public class JournalContentImpl
implements JournalContent {
    protected static final String CACHE_NAME = JournalContent.class.getName();
    protected static Pattern lifecycleRenderPhasePattern = Pattern.compile("<lifecycle>\\s*RENDER_PHASE\\s*</lifecycle>");
    protected static PortalCache<String, JournalArticleDisplay> portalCache = MultiVMPoolUtil.getCache((String)CACHE_NAME);
    private static Log _log = LogFactoryUtil.getLog(JournalContentImpl.class);

    public void clearCache() {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        portalCache.removeAll();
    }

    public void clearCache(long groupId, String articleId, String ddmTemplateKey) {
        this.clearCache();
    }

    public String getContent(long groupId, String articleId, String viewMode, String languageId, String xmlRequest) {
        return this.getContent(groupId, articleId, null, viewMode, languageId, null, xmlRequest);
    }

    public String getContent(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, String xmlRequest) {
        return this.getContent(groupId, articleId, ddmTemplateKey, viewMode, languageId, null, xmlRequest);
    }

    public String getContent(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getContent(groupId, articleId, ddmTemplateKey, viewMode, languageId, themeDisplay, null);
    }

    public String getContent(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay, String xmlRequest) {
        JournalArticleDisplay articleDisplay = this.getDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, themeDisplay, 1, xmlRequest);
        if (articleDisplay != null) {
            return articleDisplay.getContent();
        }
        return null;
    }

    public String getContent(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getContent(groupId, articleId, null, viewMode, languageId, themeDisplay);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, double version, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay, int page, String xmlRequest) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        articleId = StringUtil.toUpperCase((String)GetterUtil.getString((String)articleId));
        ddmTemplateKey = StringUtil.toUpperCase((String)GetterUtil.getString((String)ddmTemplateKey));
        long layoutSetId = 0L;
        boolean secure = false;
        if (themeDisplay != null) {
            block6: {
                try {
                    if (JournalArticlePermission.contains(themeDisplay.getPermissionChecker(), groupId, articleId, "VIEW")) break block6;
                    return null;
                }
                catch (Exception exception) {}
            }
            Layout layout = themeDisplay.getLayout();
            LayoutSet layoutSet = layout.getLayoutSet();
            layoutSetId = layoutSet.getLayoutSetId();
            secure = themeDisplay.isSecure();
        }
        String key = this.encodeKey(groupId, articleId, version, ddmTemplateKey, layoutSetId, viewMode, languageId, page, secure);
        JournalArticleDisplay articleDisplay = (JournalArticleDisplay)portalCache.get((Serializable)((Object)key));
        boolean lifecycleRender = this.isLifecycleRender(themeDisplay, xmlRequest);
        if ((articleDisplay == null || !lifecycleRender) && (articleDisplay = this.getArticleDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, page, xmlRequest, themeDisplay)) != null && articleDisplay.isCacheable() && lifecycleRender) {
            portalCache.put((Serializable)((Object)key), (Object)articleDisplay);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("getDisplay for {" + groupId + ", " + articleId + ", " + ddmTemplateKey + ", " + viewMode + ", " + languageId + ", " + page + "} takes " + stopWatch.getTime() + " ms"));
        }
        return articleDisplay;
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, String xmlRequest) {
        return this.getDisplay(groupId, articleId, null, viewMode, languageId, null, 1, xmlRequest);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, String xmlRequest) {
        return this.getDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, null, 1, xmlRequest);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, themeDisplay, 1, null);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay, int page, String xmlRequest) {
        return this.getDisplay(groupId, articleId, 0.0, ddmTemplateKey, viewMode, languageId, themeDisplay, 1, xmlRequest);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, viewMode, languageId, themeDisplay, 1);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay, int page) {
        return this.getDisplay(groupId, articleId, null, viewMode, languageId, themeDisplay, page, null);
    }

    protected String encodeKey(long groupId, String articleId, double version, String ddmTemplateKey, long layoutSetId, String viewMode, String languageId, int page, boolean secure) {
        StringBundler sb = new StringBundler();
        sb.append(StringUtil.toHexString((long)groupId));
        sb.append("_ARTICLE_");
        sb.append(articleId);
        sb.append("_VERSION_");
        sb.append(version);
        sb.append("_TEMPLATE_");
        sb.append(ddmTemplateKey);
        if (layoutSetId > 0L) {
            sb.append("_LAYOUT_SET_");
            sb.append(StringUtil.toHexString((long)layoutSetId));
        }
        if (Validator.isNotNull((String)viewMode)) {
            sb.append("_VIEW_MODE_");
            sb.append(viewMode);
        }
        if (Validator.isNotNull((String)languageId)) {
            sb.append("_LANGUAGE_");
            sb.append(languageId);
        }
        if (page > 0) {
            sb.append("_PAGE_");
            sb.append(StringUtil.toHexString((int)page));
        }
        sb.append("_SECURE_");
        sb.append(secure);
        return sb.toString();
    }

    protected JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, int page, String xmlRequest, ThemeDisplay themeDisplay) {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Get article display {" + groupId + ", " + articleId + ", " + ddmTemplateKey + "}"));
            }
            return JournalArticleLocalServiceUtil.getArticleDisplay((long)groupId, (String)articleId, (String)ddmTemplateKey, (String)viewMode, (String)languageId, (int)page, (String)xmlRequest, (ThemeDisplay)themeDisplay);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get display for " + groupId + " " + articleId + " " + languageId));
            }
            return null;
        }
    }

    protected boolean isLifecycleRender(ThemeDisplay themeDisplay, String xmlRequest) {
        if (themeDisplay != null) {
            return themeDisplay.isLifecycleRender();
        }
        if (Validator.isNotNull((String)xmlRequest)) {
            Matcher matcher = lifecycleRenderPhasePattern.matcher(xmlRequest);
            return matcher.find();
        }
        return false;
    }
}

