/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.permission.MBDiscussionPermission;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public class MBMessageAssetRenderer
extends BaseAssetRenderer
implements TrashRenderer {
    private MBMessage _message;

    public MBMessageAssetRenderer(MBMessage message) {
        this._message = message;
    }

    public String getClassName() {
        return MBMessage.class.getName();
    }

    public long getClassPK() {
        return this._message.getMessageId();
    }

    public Date getDisplayDate() {
        return this._message.getModifiedDate();
    }

    public long getGroupId() {
        return this._message.getGroupId();
    }

    public String getPortletId() {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getPortletId();
    }

    public String getSearchSummary(Locale locale) {
        if (this._message.isFormatBBCode()) {
            return HtmlUtil.extractText((String)BBCodeTranslatorUtil.getHTML((String)this._message.getBody()));
        }
        return this.getSummary(locale);
    }

    public String getSummary(Locale locale) {
        return HtmlUtil.extractText((String)this._message.getBody());
    }

    public String getThumbnailPath(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/file_system/large/message.png";
    }

    public String getTitle(Locale locale) {
        return this._message.getSubject();
    }

    public String getType() {
        return "message";
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "19", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/message_boards/edit_message");
        portletURL.setParameter("messageId", String.valueOf(this._message.getMessageId()));
        return portletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        PortletURL portletURL = assetRendererFactory.getURLView(liferayPortletResponse, windowState);
        portletURL.setParameter("struts_action", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(this._message.getMessageId()));
        portletURL.setWindowState(windowState);
        return portletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/message_boards/find_message", "messageId", this._message.getMessageId());
    }

    public long getUserId() {
        return this._message.getUserId();
    }

    public String getUserName() {
        return this._message.getUserName();
    }

    public String getUuid() {
        return this._message.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException, SystemException {
        if (this._message.isDiscussion()) {
            return MBDiscussionPermission.contains(permissionChecker, this._message.getCompanyId(), this._message.getGroupId(), this._message.getClassName(), this._message.getClassPK(), this._message.getMessageId(), this._message.getUserId(), "UPDATE");
        }
        return MBMessagePermission.contains(permissionChecker, this._message, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException, SystemException {
        if (this._message.isDiscussion()) {
            return MBDiscussionPermission.contains(permissionChecker, this._message.getCompanyId(), this._message.getGroupId(), this._message.getClassName(), this._message.getClassPK(), this._message.getMessageId(), this._message.getUserId(), "VIEW");
        }
        return MBMessagePermission.contains(permissionChecker, this._message, "VIEW");
    }

    public boolean isPrintable() {
        return true;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("MESSAGE_BOARDS_MESSAGE", (Object)this._message);
            return "/html/portlet/message_boards/asset/" + template + ".jsp";
        }
        return null;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/message.png";
    }
}

