/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import java.util.Map;

public class WikiNodeStagedModelDataHandler
extends BaseStagedModelDataHandler<WikiNode> {
    public static final String[] CLASS_NAMES = new String[]{WikiNode.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        WikiNode wikiNode = WikiNodeLocalServiceUtil.fetchWikiNodeByUuidAndGroupId((String)uuid, (long)groupId);
        if (wikiNode != null) {
            WikiNodeLocalServiceUtil.deleteNode((WikiNode)wikiNode);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, WikiNode node) throws Exception {
        Element nodeElement = portletDataContext.getExportDataElement((ClassedModel)node);
        portletDataContext.addClassedModel(nodeElement, ExportImportPathUtil.getModelPath((StagedModel)node), (ClassedModel)node);
    }

    protected void doImportCompanyStagedModel(PortletDataContext portletDataContext, String uuid, long nodeId) throws Exception {
        WikiNode existingNode = WikiNodeLocalServiceUtil.fetchNodeByUuidAndGroupId((String)uuid, (long)portletDataContext.getCompanyGroupId());
        Map nodeIds = portletDataContext.getNewPrimaryKeysMap(WikiNode.class);
        nodeIds.put(nodeId, existingNode.getNodeId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, WikiNode node) throws Exception {
        long userId = portletDataContext.getUserId(node.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)node);
        WikiNode importedNode = null;
        if (portletDataContext.isDataStrategyMirror()) {
            WikiNode initialNode;
            WikiNode existingNode = WikiNodeLocalServiceUtil.fetchNodeByUuidAndGroupId((String)node.getUuid(), (long)portletDataContext.getScopeGroupId());
            String initialNodeName = PropsValues.WIKI_INITIAL_NODE_NAME;
            if (existingNode == null && initialNodeName.equals(node.getName()) && (initialNode = WikiNodeLocalServiceUtil.fetchNode((long)portletDataContext.getScopeGroupId(), (String)node.getName())) != null) {
                WikiNodeLocalServiceUtil.deleteWikiNode((WikiNode)initialNode);
            }
            if (existingNode == null) {
                serviceContext.setUuid(node.getUuid());
                importedNode = WikiNodeLocalServiceUtil.addNode((long)userId, (String)node.getName(), (String)node.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedNode = WikiNodeLocalServiceUtil.updateNode((long)existingNode.getNodeId(), (String)node.getName(), (String)node.getDescription(), (ServiceContext)serviceContext);
            }
        } else {
            WikiNode initialNode;
            String initialNodeName = PropsValues.WIKI_INITIAL_NODE_NAME;
            if (initialNodeName.equals(node.getName()) && (initialNode = WikiNodeLocalServiceUtil.fetchNode((long)portletDataContext.getScopeGroupId(), (String)node.getName())) != null) {
                WikiNodeLocalServiceUtil.deleteWikiNode((WikiNode)initialNode);
            }
            String nodeName = this.getNodeName(portletDataContext, node, node.getName(), 2);
            importedNode = WikiNodeLocalServiceUtil.addNode((long)userId, (String)nodeName, (String)node.getDescription(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)node, (ClassedModel)importedNode);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, WikiNode node) throws Exception {
        long userId = portletDataContext.getUserId(node.getUserUuid());
        WikiNode existingNode = WikiNodeLocalServiceUtil.fetchNodeByUuidAndGroupId((String)node.getUuid(), (long)portletDataContext.getScopeGroupId());
        if (existingNode == null || !existingNode.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingNode.getTrashHandler();
        if (trashHandler.isRestorable(existingNode.getNodeId())) {
            trashHandler.restoreTrashEntry(userId, existingNode.getNodeId());
        }
    }

    protected String getNodeName(PortletDataContext portletDataContext, WikiNode node, String name, int count) throws Exception {
        WikiNode existingNode = WikiNodeLocalServiceUtil.fetchNode((long)portletDataContext.getScopeGroupId(), (String)name);
        if (existingNode == null) {
            return name;
        }
        String nodeName = node.getName();
        return this.getNodeName(portletDataContext, node, nodeName.concat(" ").concat(String.valueOf(count)), ++count);
    }

    protected boolean validateMissingReference(String uuid, long companyId, long groupId) throws Exception {
        WikiNode node = WikiNodeLocalServiceUtil.fetchNodeByUuidAndGroupId((String)uuid, (long)groupId);
        return node != null;
    }
}

