/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client.security;

import java.rmi.RemoteException;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.rmi.client.ClientObject;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.client.security.ClientAccessControlList;
import org.apache.jackrabbit.rmi.remote.security.RemoteAccessControlList;
import org.apache.jackrabbit.rmi.remote.security.RemoteAccessControlManager;

public class ClientAccessControlManager
extends ClientObject
implements AccessControlManager {
    private final RemoteAccessControlManager racm;

    public ClientAccessControlManager(RemoteAccessControlManager racm, LocalAdapterFactory factory) {
        super(factory);
        this.racm = racm;
    }

    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws RepositoryException {
        try {
            return this.getFactory().getAccessControlPolicyIterator(this.racm.getApplicablePolicies(absPath));
        }
        catch (RemoteException re) {
            throw new RemoteRepositoryException(re);
        }
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        try {
            return this.getFactory().getAccessControlPolicy(this.racm.getEffectivePolicies(absPath));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public AccessControlPolicy[] getPolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        try {
            return this.getFactory().getAccessControlPolicy(this.racm.getPolicies(absPath));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Privilege[] getPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        try {
            return this.getFactory().getPrivilege(this.racm.getPrivileges(absPath));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Privilege[] getSupportedPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        try {
            return this.getFactory().getPrivilege(this.racm.getSupportedPrivileges(absPath));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public boolean hasPrivileges(String absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        String[] privNames = new String[privileges.length];
        int i = 0;
        while (i < privNames.length) {
            privNames[i] = privileges[i].getName();
            ++i;
        }
        try {
            return this.racm.hasPrivileges(absPath, privNames);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Privilege privilegeFromName(String privilegeName) throws AccessControlException, RepositoryException {
        try {
            return this.getFactory().getPrivilege(this.racm.privilegeFromName(privilegeName));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void removePolicy(String absPath, AccessControlPolicy policy) throws UnsupportedRepositoryOperationException {
        throw new UnsupportedRepositoryOperationException("removePolicy");
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws AccessControlException, RepositoryException {
        try {
            if (!(policy instanceof ClientAccessControlList)) {
                throw new UnsupportedRepositoryOperationException("setPolicy for type " + policy.getClass().getName());
            }
            ClientAccessControlList acl = (ClientAccessControlList)policy;
            RemoteAccessControlList racl = (RemoteAccessControlList)acl.getRemoteAccessControlPolicy();
            racl.setPolicy(absPath);
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }
}

