/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import java.util.ArrayList;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Humidor;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.test.SigarTestCase;

public class TestHumidor
extends SigarTestCase {
    public TestHumidor(String name) {
        super(name);
    }

    private static void getProcCpu(SigarProxy sigar) throws Exception {
        long[] pids = sigar.getProcList();
        for (int j = 0; j < 10; ++j) {
            for (int i = 0; i < pids.length; ++i) {
                try {
                    double cpu = sigar.getProcCpu(pids[i]).getPercent();
                    if (!SigarTestCase.getVerbose()) continue;
                    System.out.println(Thread.currentThread().getName() + " " + pids[i] + "=" + CpuPerc.format(cpu));
                    continue;
                }
                catch (SigarException e) {
                    // empty catch block
                }
            }
        }
    }

    private void runTests(SigarProxy sigar) throws Exception {
        Thread t;
        int i;
        ArrayList<HumidorThread> threads = new ArrayList<HumidorThread>();
        for (i = 0; i < 3; ++i) {
            t = new HumidorThread(sigar);
            threads.add((HumidorThread)t);
            t.start();
        }
        for (i = 0; i < threads.size(); ++i) {
            t = (Thread)threads.get(i);
            t.join();
        }
    }

    public void testGlobalInstance() throws Exception {
        this.runTests(Humidor.getInstance().getSigar());
    }

    public void testInstance() throws Exception {
        Sigar sigar = new Sigar();
        this.runTests(new Humidor(sigar).getSigar());
        sigar.close();
    }

    private static class HumidorThread
    extends Thread {
        private SigarProxy sigar;

        private HumidorThread(SigarProxy sigar) {
            this.sigar = sigar;
        }

        public void run() {
            try {
                TestHumidor.getProcCpu(this.sigar);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }
}

