/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.jsonrpc;

import com.metaparadigm.jsonrpc.ArraySerializer;
import com.metaparadigm.jsonrpc.BeanSerializer;
import com.metaparadigm.jsonrpc.BooleanSerializer;
import com.metaparadigm.jsonrpc.DateSerializer;
import com.metaparadigm.jsonrpc.DictionarySerializer;
import com.metaparadigm.jsonrpc.ListSerializer;
import com.metaparadigm.jsonrpc.MapSerializer;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.NumberSerializer;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.PrimitiveSerializer;
import com.metaparadigm.jsonrpc.Serializer;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.SetSerializer;
import com.metaparadigm.jsonrpc.StringSerializer;
import com.metaparadigm.jsonrpc.UnmarshallException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONSerializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(JSONSerializer.class.getName());
    private boolean debug = false;
    private HashSet serializerSet = new HashSet();
    private transient HashMap serializableMap = new HashMap();
    private ArrayList serializerList = new ArrayList();
    private boolean marshallClassHints = true;
    private boolean marshallNullAttributes = true;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.serializableMap = new HashMap();
        Iterator i = this.serializerList.iterator();
        while (i.hasNext()) {
            Serializer s = (Serializer)i.next();
            Class[] classes = s.getSerializableClasses();
            for (int j = 0; j < classes.length; ++j) {
                this.serializableMap.put(classes[j], s);
            }
        }
    }

    public void registerDefaultSerializers() throws Exception {
        this.registerSerializer(new BeanSerializer());
        this.registerSerializer(new ArraySerializer());
        this.registerSerializer(new DictionarySerializer());
        this.registerSerializer(new MapSerializer());
        this.registerSerializer(new SetSerializer());
        this.registerSerializer(new ListSerializer());
        this.registerSerializer(new DateSerializer());
        this.registerSerializer(new StringSerializer());
        this.registerSerializer(new NumberSerializer());
        this.registerSerializer(new BooleanSerializer());
        this.registerSerializer(new PrimitiveSerializer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSerializer(Serializer s) throws Exception {
        Class[] classes = s.getSerializableClasses();
        HashSet hashSet = this.serializerSet;
        synchronized (hashSet) {
            int i;
            for (i = 0; i < classes.length; ++i) {
                Serializer exists = (Serializer)this.serializableMap.get(classes[i]);
                if (exists == null || exists.getClass() == s.getClass()) continue;
                throw new Exception("different serializer already registered for " + classes[i].getName());
            }
            if (!this.serializerSet.contains(s)) {
                if (this.isDebug()) {
                    log.info("registered serializer " + s.getClass().getName());
                }
                for (i = 0; i < classes.length; ++i) {
                    this.serializableMap.put(classes[i], s);
                }
                s.setOwner(this);
                this.serializerSet.add(s);
                this.serializerList.add(0, s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializer getSerializer(Class clazz, Class jsoClazz) {
        if (this.isDebug()) {
            log.fine("looking for serializer - java:" + (clazz == null ? "null" : clazz.getName()) + " json:" + (jsoClazz == null ? "null" : jsoClazz.getName()));
        }
        Serializer s = null;
        HashSet hashSet = this.serializerSet;
        synchronized (hashSet) {
            s = (Serializer)this.serializableMap.get(clazz);
            if (s != null && s.canSerialize(clazz, jsoClazz)) {
                if (this.isDebug()) {
                    log.fine("direct match serializer " + s.getClass().getName());
                }
                return s;
            }
            Iterator i = this.serializerList.iterator();
            while (i.hasNext()) {
                s = (Serializer)i.next();
                if (!s.canSerialize(clazz, jsoClazz)) continue;
                if (this.isDebug()) {
                    log.fine("search found serializer " + s.getClass().getName());
                }
                return s;
            }
        }
        return null;
    }

    private Class getClassFromHint(Object o) throws UnmarshallException {
        if (o == null) {
            return null;
        }
        if (o instanceof JSONObject) {
            try {
                String class_name = ((JSONObject)o).getString("javaClass");
                Class<?> clazz = Class.forName(class_name);
                return clazz;
            }
            catch (NoSuchElementException e) {
            }
            catch (Exception e) {
                throw new UnmarshallException("class in hint not found");
            }
        }
        if (o instanceof JSONArray) {
            JSONArray arr = (JSONArray)o;
            if (arr.length() == 0) {
                throw new UnmarshallException("no type for empty array");
            }
            Class compClazz = this.getClassFromHint(arr.get(0));
            try {
                if (compClazz.isArray()) {
                    return Class.forName("[" + compClazz.getName());
                }
                return Class.forName("[L" + compClazz.getName() + ";");
            }
            catch (ClassNotFoundException e) {
                throw new UnmarshallException("problem getting array type");
            }
        }
        return o.getClass();
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object json) throws UnmarshallException {
        if (clazz != null && json instanceof JSONObject && ((JSONObject)json).has("javaClass") && clazz.isAssignableFrom(this.getClassFromHint(json))) {
            clazz = this.getClassFromHint(json);
        }
        if (clazz == null) {
            clazz = this.getClassFromHint(json);
        }
        if (clazz == null) {
            throw new UnmarshallException("no class hint");
        }
        if (json == null || json == JSONObject.NULL) {
            if (!clazz.isPrimitive()) {
                return ObjectMatch.NULL;
            }
            throw new UnmarshallException("can't assign null primitive");
        }
        Serializer s = this.getSerializer(clazz, json.getClass());
        if (s != null) {
            return s.tryUnmarshall(state, clazz, json);
        }
        throw new UnmarshallException("no match");
    }

    public Object unmarshall(SerializerState state, Class clazz, Object json) throws UnmarshallException {
        if (clazz != null && json instanceof JSONObject && ((JSONObject)json).has("javaClass") && clazz.isAssignableFrom(this.getClassFromHint(json))) {
            clazz = this.getClassFromHint(json);
        }
        if (clazz == null) {
            clazz = this.getClassFromHint(json);
        }
        if (clazz == null) {
            throw new UnmarshallException("no class hint");
        }
        if (json == null || json == JSONObject.NULL) {
            if (!clazz.isPrimitive()) {
                return null;
            }
            throw new UnmarshallException("can't assign null primitive");
        }
        Serializer s = this.getSerializer(clazz, json.getClass());
        if (s != null) {
            return s.unmarshall(state, clazz, json);
        }
        throw new UnmarshallException("can't unmarshall");
    }

    public Object marshall(SerializerState state, Object o) throws MarshallException {
        Serializer s;
        if (o == null) {
            if (this.isDebug()) {
                log.fine("marshall null");
            }
            return JSONObject.NULL;
        }
        if (this.isDebug()) {
            log.fine("marshall class " + o.getClass().getName());
        }
        if ((s = this.getSerializer(o.getClass(), null)) != null) {
            return s.marshall(state, o);
        }
        throw new MarshallException("can't marshall " + o.getClass().getName());
    }

    public String toJSON(Object o) throws MarshallException {
        SerializerState state = new SerializerState();
        Object json = this.marshall(state, o);
        return json.toString();
    }

    public Object fromJSON(String s) throws UnmarshallException {
        Object json;
        JSONTokener tok = new JSONTokener(s);
        try {
            json = tok.nextValue();
        }
        catch (ParseException e) {
            throw new UnmarshallException("couldn't parse JSON");
        }
        SerializerState state = new SerializerState();
        return this.unmarshall(state, null, json);
    }

    public boolean getMarshallClassHints() {
        return this.marshallClassHints;
    }

    public void setMarshallClassHints(boolean marshallClassHints) {
        this.marshallClassHints = marshallClassHints;
    }

    public boolean getMarshallNullAttributes() {
        return this.marshallNullAttributes;
    }

    public void setMarshallNullAttributes(boolean marshallNullAttributes) {
        this.marshallNullAttributes = marshallNullAttributes;
    }
}

