/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html;

import org.outerj.daisy.diff.html.dom.ImageNode;
import org.outerj.daisy.diff.html.dom.Node;
import org.outerj.daisy.diff.html.dom.TagNode;
import org.outerj.daisy.diff.html.dom.TextNode;
import org.outerj.daisy.diff.html.modification.Modification;
import org.outerj.daisy.diff.html.modification.ModificationType;
import org.outerj.daisy.diff.output.DiffOutput;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HtmlSaxDiffOutput
implements DiffOutput {
    private ContentHandler handler;
    private String prefix;

    public HtmlSaxDiffOutput(ContentHandler contentHandler, String string) {
        this.handler = contentHandler;
        this.prefix = string;
    }

    public void generateOutput(TagNode tagNode) throws SAXException {
        if (!tagNode.getQName().equalsIgnoreCase("img") && !tagNode.getQName().equalsIgnoreCase("body")) {
            this.handler.startElement("", tagNode.getQName(), tagNode.getQName(), tagNode.getAttributes());
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = "";
        for (Node node : tagNode) {
            Object object;
            if (node instanceof TagNode) {
                if (bl) {
                    this.handler.endElement("", "span", "span");
                    bl = false;
                } else if (bl3) {
                    this.handler.endElement("", "span", "span");
                    bl3 = false;
                } else if (bl2) {
                    this.handler.endElement("", "span", "span");
                    bl2 = false;
                } else if (bl4) {
                    this.handler.endElement("", "span", "span");
                    bl4 = false;
                }
                this.generateOutput((TagNode)node);
                continue;
            }
            if (!(node instanceof TextNode)) continue;
            TextNode textNode = (TextNode)node;
            Modification modification = textNode.getModification();
            if (bl && (modification.getOutputType() != ModificationType.ADDED || modification.isFirstOfID())) {
                this.handler.endElement("", "span", "span");
                bl = false;
            } else if (bl3 && (modification.getOutputType() != ModificationType.CHANGED || !modification.getChanges().equals(string) || modification.isFirstOfID())) {
                this.handler.endElement("", "span", "span");
                bl3 = false;
            } else if (bl2 && (modification.getOutputType() != ModificationType.REMOVED || modification.isFirstOfID())) {
                this.handler.endElement("", "span", "span");
                bl2 = false;
            } else if (bl4 && (modification.getOutputType() != ModificationType.CONFLICT || modification.isFirstOfID())) {
                this.handler.endElement("", "span", "span");
                bl4 = false;
            }
            if (!bl && modification.getOutputType() == ModificationType.ADDED) {
                object = new AttributesImpl();
                ((AttributesImpl)object).addAttribute("", "class", "class", "CDATA", "diff-html-added");
                if (modification.isFirstOfID()) {
                    ((AttributesImpl)object).addAttribute("", "id", "id", "CDATA", (Object)((Object)modification.getOutputType()) + "-" + this.prefix + "-" + modification.getID());
                }
                this.addAttributes(modification, (AttributesImpl)object);
                this.handler.startElement("", "span", "span", (Attributes)object);
                bl = true;
            } else if (!bl3 && modification.getOutputType() == ModificationType.CHANGED) {
                object = new AttributesImpl();
                ((AttributesImpl)object).addAttribute("", "class", "class", "CDATA", "diff-html-changed");
                if (modification.isFirstOfID()) {
                    ((AttributesImpl)object).addAttribute("", "id", "id", "CDATA", (Object)((Object)modification.getOutputType()) + "-" + this.prefix + "-" + modification.getID());
                }
                this.addAttributes(modification, (AttributesImpl)object);
                this.handler.startElement("", "span", "span", (Attributes)object);
                bl3 = true;
                string = modification.getChanges();
            } else if (!bl2 && modification.getOutputType() == ModificationType.REMOVED) {
                object = new AttributesImpl();
                ((AttributesImpl)object).addAttribute("", "class", "class", "CDATA", "diff-html-removed");
                if (modification.isFirstOfID()) {
                    ((AttributesImpl)object).addAttribute("", "id", "id", "CDATA", (Object)((Object)modification.getOutputType()) + "-" + this.prefix + "-" + modification.getID());
                }
                this.addAttributes(modification, (AttributesImpl)object);
                this.handler.startElement("", "span", "span", (Attributes)object);
                bl2 = true;
            } else if (!bl4 && modification.getOutputType() == ModificationType.CONFLICT) {
                object = new AttributesImpl();
                ((AttributesImpl)object).addAttribute("", "class", "class", "CDATA", "diff-html-conflict");
                if (modification.isFirstOfID()) {
                    ((AttributesImpl)object).addAttribute("", "id", "id", "CDATA", (Object)((Object)modification.getOutputType()) + "-" + this.prefix + "-" + modification.getID());
                }
                this.addAttributes(modification, (AttributesImpl)object);
                this.handler.startElement("", "span", "span", (Attributes)object);
                bl4 = true;
            }
            object = textNode.getText().toCharArray();
            if (textNode instanceof ImageNode) {
                this.writeImage((ImageNode)textNode);
                continue;
            }
            this.handler.characters((char[])object, 0, ((Object)object).length);
        }
        if (bl) {
            this.handler.endElement("", "span", "span");
            bl = false;
        } else if (bl3) {
            this.handler.endElement("", "span", "span");
            bl3 = false;
        } else if (bl2) {
            this.handler.endElement("", "span", "span");
            bl2 = false;
        } else if (bl4) {
            this.handler.endElement("", "span", "span");
            bl4 = false;
        }
        if (!tagNode.getQName().equalsIgnoreCase("img") && !tagNode.getQName().equalsIgnoreCase("body")) {
            this.handler.endElement("", tagNode.getQName(), tagNode.getQName());
        }
    }

    private void writeImage(ImageNode imageNode) throws SAXException {
        AttributesImpl attributesImpl = imageNode.getAttributes();
        if (imageNode.getModification().getOutputType() == ModificationType.REMOVED) {
            attributesImpl.addAttribute("", "changeType", "changeType", "CDATA", "diff-removed-image");
        } else if (imageNode.getModification().getOutputType() == ModificationType.ADDED) {
            attributesImpl.addAttribute("", "changeType", "changeType", "CDATA", "diff-added-image");
        } else if (imageNode.getModification().getOutputType() == ModificationType.CONFLICT) {
            attributesImpl.addAttribute("", "changeType", "changeType", "CDATA", "diff-conflict-image");
        }
        this.handler.startElement("", "img", "img", attributesImpl);
        this.handler.endElement("", "img", "img");
    }

    private void addAttributes(Modification modification, AttributesImpl attributesImpl) {
        String string;
        if (modification.getOutputType() == ModificationType.CHANGED) {
            string = modification.getChanges();
            attributesImpl.addAttribute("", "changes", "changes", "CDATA", string);
        }
        string = modification.getPrevious() == null ? "first-" + this.prefix : (Object)((Object)modification.getPrevious().getOutputType()) + "-" + this.prefix + "-" + modification.getPrevious().getID();
        attributesImpl.addAttribute("", "previous", "previous", "CDATA", string);
        String string2 = (Object)((Object)modification.getOutputType()) + "-" + this.prefix + "-" + modification.getID();
        attributesImpl.addAttribute("", "changeId", "changeId", "CDATA", string2);
        String string3 = modification.getNext() == null ? "last-" + this.prefix : (Object)((Object)modification.getNext().getOutputType()) + "-" + this.prefix + "-" + modification.getNext().getID();
        attributesImpl.addAttribute("", "next", "next", "CDATA", string3);
    }
}

