/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.UserDataValue;

public class UserType
extends DataType
implements UserDataValue {
    private Object value;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(UserType.class);

    public int estimateMemoryUsage() {
        int n = BASE_MEMORY_USAGE;
        if (null != this.value) {
            n += ClassSize.estimateAndCatalogBase(this.value.getClass());
        }
        return n;
    }

    public String getString() {
        if (!this.isNull()) {
            return this.value.toString();
        }
        return null;
    }

    public boolean getBoolean() throws StandardException {
        if (!this.isNull() && this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return super.getBoolean();
    }

    public byte getByte() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).byteValue();
        }
        return super.getByte();
    }

    public short getShort() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).shortValue();
        }
        return super.getShort();
    }

    public int getInt() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        return super.getInt();
    }

    public long getLong() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        return super.getLong();
    }

    public float getFloat() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).floatValue();
        }
        return super.getFloat();
    }

    public double getDouble() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        return super.getDouble();
    }

    public byte[] getBytes() throws StandardException {
        if (!this.isNull() && this.value instanceof byte[]) {
            return (byte[])this.value;
        }
        return super.getBytes();
    }

    public Date getDate(Calendar calendar) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Date) {
                return (Date)this.value;
            }
            if (this.value instanceof Timestamp) {
                return new SQLTimestamp((Timestamp)this.value).getDate(calendar);
            }
        }
        return super.getDate(calendar);
    }

    public Time getTime(Calendar calendar) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Time) {
                return (Time)this.value;
            }
            if (this.value instanceof Timestamp) {
                return new SQLTimestamp((Timestamp)this.value).getTime(calendar);
            }
        }
        return super.getTime(calendar);
    }

    public Timestamp getTimestamp(Calendar calendar) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Timestamp) {
                return (Timestamp)this.value;
            }
            if (this.value instanceof Date) {
                return new SQLDate((Date)this.value).getTimestamp(calendar);
            }
            if (this.value instanceof Time) {
                return new SQLTime((Time)this.value).getTimestamp(calendar);
            }
        }
        return super.getTimestamp(calendar);
    }

    void setObject(Object object) {
        this.setValue(object);
    }

    public Object getObject() {
        return this.value;
    }

    public int getLength() {
        return -1;
    }

    public String getTypeName() {
        return this.isNull() ? "JAVA_OBJECT" : ClassInspector.readableClassName(this.value.getClass());
    }

    String getTypeName(String string) {
        return string;
    }

    public int getTypeFormatId() {
        return 266;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.value);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.value = objectInput.readObject();
    }

    public DataValueDescriptor cloneValue(boolean bl) {
        return new UserType(this.value);
    }

    public DataValueDescriptor getNewNull() {
        return new UserType();
    }

    public void restoreToNull() {
        this.value = null;
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        this.value = resultSet.getObject(n);
    }

    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n;
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        boolean bl = this.isNull();
        boolean bl2 = dataValueDescriptor.isNull();
        if (bl || bl2) {
            if (!bl) {
                return -1;
            }
            if (!bl2) {
                return 1;
            }
            return 0;
        }
        try {
            n = ((Comparable)this.value).compareTo(dataValueDescriptor.getObject());
        }
        catch (ClassCastException classCastException) {
            throw StandardException.newException("XCL15.S", (Object)this.getTypeName(), (Object)ClassInspector.readableClassName(dataValueDescriptor.getObject().getClass()));
        }
        if (n < 0) {
            n = -1;
        } else if (n > 0) {
            n = 1;
        }
        return n;
    }

    public boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        Object object;
        if (!bl && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl2;
        }
        if (!(n != 2 || this.isNull() || dataValueDescriptor.isNull() || (object = this.getObject()) instanceof Comparable)) {
            return object.equals(dataValueDescriptor.getObject());
        }
        return super.compare(n, dataValueDescriptor, bl, bl2);
    }

    public UserType() {
    }

    public UserType(Object object) {
        this.value = object;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor.getObject());
    }

    public void setBigDecimal(Number number) {
        this.setValue(number);
    }

    public void setValue(String string) {
        this.value = string == null ? null : string;
    }

    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.compare(2, dataValueDescriptor2, true, false));
    }

    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, !dataValueDescriptor.compare(2, dataValueDescriptor2, true, false));
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.value.toString();
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.value.hashCode();
    }

    public int typePrecedence() {
        return 1000;
    }

    public final boolean isNull() {
        return this.value == null;
    }
}

