/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;

public class AllocExtent
implements Externalizable {
    private long extentOffset;
    private long extentStart;
    private long extentEnd;
    private int extentLength;
    int extentStatus;
    private int preAllocLength;
    private int reserved1;
    private long reserved2;
    private long reserved3;
    private static final int HAS_DEALLOCATED = 1;
    private static final int HAS_FREE = 2;
    private static final int ALL_FREE = 4;
    private static final int HAS_UNFILLED_PAGES = 16;
    private static final int KEEP_UNFILLED_PAGES = 0x10000000;
    private static final int NO_DEALLOC_PAGE_MAP = 0x20000000;
    private static final int RETIRED = 8;
    protected static final int ALLOCATED_PAGE = 0;
    protected static final int DEALLOCATED_PAGE = 1;
    protected static final int FREE_PAGE = 2;
    FormatableBitSet freePages;
    FormatableBitSet unFilledPages;

    protected static int MAX_RANGE(int n) {
        int n2 = 56;
        n -= n2;
        if ((n /= 3) <= 0) {
            return 0;
        }
        return FormatableBitSet.maxBitsForSpace(n);
    }

    protected AllocExtent(long l, long l2, int n, int n2, int n3) {
        this.extentOffset = l;
        this.extentStart = l2;
        this.extentEnd = l2 + (long)n3 - 1L;
        this.preAllocLength = this.extentLength = n;
        this.extentStatus = n > 0 ? 6 : 0;
        this.extentStatus |= 0x10000000;
        this.extentStatus |= 0x20000000;
        int n4 = (1 + n / 8) * 8;
        if (n4 > n3) {
            n4 = n3;
        }
        this.freePages = new FormatableBitSet(n4);
        this.unFilledPages = new FormatableBitSet(n4);
        for (int i = 0; i < n; ++i) {
            this.freePages.set(i);
        }
    }

    protected AllocExtent(AllocExtent allocExtent) {
        this.extentOffset = allocExtent.extentOffset;
        this.extentStart = allocExtent.extentStart;
        this.extentEnd = allocExtent.extentEnd;
        this.extentLength = allocExtent.extentLength;
        this.extentStatus = allocExtent.extentStatus;
        this.preAllocLength = allocExtent.preAllocLength;
        this.freePages = new FormatableBitSet(allocExtent.freePages);
        this.unFilledPages = new FormatableBitSet(allocExtent.unFilledPages);
    }

    public AllocExtent() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.extentOffset);
        objectOutput.writeLong(this.extentStart);
        objectOutput.writeLong(this.extentEnd);
        objectOutput.writeInt(this.extentLength);
        objectOutput.writeInt(this.extentStatus);
        objectOutput.writeInt(this.preAllocLength);
        objectOutput.writeInt(0);
        objectOutput.writeLong(0L);
        objectOutput.writeLong(0L);
        this.freePages.writeExternal(objectOutput);
        this.unFilledPages.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.extentOffset = objectInput.readLong();
        this.extentStart = objectInput.readLong();
        this.extentEnd = objectInput.readLong();
        this.extentLength = objectInput.readInt();
        this.extentStatus = objectInput.readInt();
        this.preAllocLength = objectInput.readInt();
        this.reserved1 = objectInput.readInt();
        this.reserved2 = objectInput.readLong();
        this.reserved3 = objectInput.readLong();
        this.freePages = new FormatableBitSet();
        this.freePages.readExternal(objectInput);
        if ((this.extentStatus & 0x20000000) == 0) {
            FormatableBitSet formatableBitSet = new FormatableBitSet();
            formatableBitSet.readExternal(objectInput);
            this.freePages.or(formatableBitSet);
            this.extentStatus |= 0x20000000;
        }
        if ((this.extentStatus & 0x10000000) == 0x10000000) {
            this.unFilledPages = new FormatableBitSet();
            this.unFilledPages.readExternal(objectInput);
        } else {
            this.unFilledPages = new FormatableBitSet(this.freePages.getLength());
            this.extentStatus |= 0x10000000;
        }
    }

    protected void allocPage(long l) throws StandardException {
        int n;
        int n2 = (int)(l - this.extentStart);
        if (n2 >= this.freePages.getLength()) {
            n = (1 + n2 / 8) * 8;
            if (n > (int)(this.extentEnd - this.extentStart + 1L)) {
                n = (int)(this.extentEnd - this.extentStart + 1L);
            }
            this.freePages.grow(n);
            this.unFilledPages.grow(n);
        }
        if ((n = (int)(l - this.extentStart + 1L)) > this.extentLength) {
            this.extentLength = n;
        }
        this.freePages.clear(n2);
    }

    protected void deallocPage(long l) throws StandardException {
        int n = (int)(l - this.extentStart);
        this.freePages.set(n);
        this.unFilledPages.clear(n);
        this.setExtentFreePageStatus(true);
    }

    protected int compress(BaseContainerHandle baseContainerHandle, RawTransaction rawTransaction, AllocPage allocPage) throws StandardException {
        int n = -1;
        int n2 = 0;
        int n3 = this.extentLength - 1;
        while (n3 >= 0 && this.freePages.isSet(n3)) {
            n = n3--;
            ++n2;
        }
        n3 = n - 1;
        if (n2 > 0) {
            baseContainerHandle.getAllocationActionSet().actionCompressSpaceOperation(rawTransaction, allocPage, n3, n2);
            return n;
        }
        return -1;
    }

    protected void compressPages(int n, int n2) {
        if (n + 1 >= 0) {
            this.freePages.shrink(n + 1);
            this.unFilledPages.shrink(n + 1);
            this.preAllocLength = this.extentLength = n + 1;
        }
    }

    protected void undoCompressPages(int n, int n2) {
        if (n >= 0) {
            this.freePages.shrink(n + 1);
            this.unFilledPages.shrink(n + 1);
            this.preAllocLength = this.extentLength = n + 1;
        }
    }

    protected long getExtentEnd() {
        return this.extentEnd;
    }

    protected long getFreePageNumber(long l) {
        if (this.mayHaveFreePage()) {
            int n;
            int n2 = n = l < this.extentStart ? this.freePages.anySetBit() : this.freePages.anySetBit((int)(l - this.extentStart));
            if (n != -1) {
                return (long)n + this.extentStart;
            }
            if (l < this.extentStart) {
                this.setExtentFreePageStatus(false);
            }
        }
        return this.extentStart + (long)this.extentLength;
    }

    protected long getPageOffset(long l, int n, boolean bl) throws StandardException {
        return l * (long)n;
    }

    protected boolean isRetired() {
        return (this.extentStatus & 8) != 0;
    }

    private boolean mayHaveFreePage() {
        return (this.extentStatus & 2) != 0;
    }

    private void setExtentFreePageStatus(boolean bl) {
        this.extentStatus = bl ? (this.extentStatus |= 2) : (this.extentStatus &= 0xFFFFFFFD);
    }

    protected boolean canAddFreePage(long l) {
        if (this.extentStart + (long)this.extentLength <= this.extentEnd) {
            return true;
        }
        if (!this.mayHaveFreePage()) {
            return false;
        }
        if (l < this.extentStart) {
            return this.freePages.anySetBit() != -1;
        }
        return this.freePages.anySetBit((int)(l - this.extentStart)) != -1;
    }

    protected int getPageStatus(long l) {
        int n = 0;
        int n2 = (int)(l - this.extentStart);
        n = this.freePages.isSet(n2) ? 2 : 0;
        return n;
    }

    protected long getFirstPagenum() {
        return this.extentStart;
    }

    protected long getLastPagenum() {
        return this.extentStart + (long)this.extentLength - 1L;
    }

    protected long getPagenum(int n) {
        return this.extentStart + (long)n;
    }

    protected long getLastPreallocPagenum() {
        if (this.extentLength > this.preAllocLength) {
            this.preAllocLength = this.extentLength;
        }
        return this.extentStart + (long)this.preAllocLength - 1L;
    }

    protected void setLastPreallocPagenum(long l) {
        if (l > this.extentEnd) {
            l = this.extentEnd;
        }
        this.preAllocLength = (int)(l - this.extentStart + 1L);
    }

    protected long getNextValidPageNumber(long l) {
        int n;
        long l2;
        long l3 = this.getLastPagenum();
        for (l2 = l < this.extentStart ? this.extentStart : l + 1L; l2 <= l3 && (n = this.getPageStatus(l2)) != 0; ++l2) {
        }
        if (l2 > l3) {
            l2 = -1L;
        }
        return l2;
    }

    protected long getLastValidPageNumber() {
        int n;
        long l;
        for (l = this.getLastPagenum(); l >= this.extentStart && (n = this.getPageStatus(l)) != 0; --l) {
        }
        if (l < this.extentStart) {
            l = -1L;
        }
        return l;
    }

    private void checkInRange(long l) {
    }

    protected void updateUnfilledPageInfo(AllocExtent allocExtent) {
        this.unFilledPages = allocExtent.unFilledPages;
        this.extentStatus = this.unFilledPages.anySetBit() >= 0 ? (this.extentStatus |= 0x10) : (this.extentStatus &= 0xFFFFFFEF);
    }

    protected boolean trackUnfilledPage(long l, boolean bl) {
        this.checkInRange(l);
        int n = (int)(l - this.extentStart);
        boolean bl2 = this.unFilledPages.isSet(n);
        if (bl != bl2) {
            if (bl) {
                this.unFilledPages.set(n);
                this.extentStatus |= 0x10;
            } else {
                this.unFilledPages.clear(n);
            }
            return true;
        }
        return false;
    }

    protected long getUnfilledPageNumber(long l) {
        if ((this.extentStatus & 0x10) == 0) {
            return -1L;
        }
        int n = this.unFilledPages.anySetBit();
        if (n != -1) {
            if ((long)n + this.extentStart != l) {
                return (long)n + this.extentStart;
            }
            if ((n = this.unFilledPages.anySetBit(n)) != -1) {
                return (long)n + this.extentStart;
            }
        }
        return -1L;
    }

    protected int getAllocatedPageCount() {
        int n = this.extentLength;
        if (!this.mayHaveFreePage()) {
            return n;
        }
        byte[] byArray = this.freePages.getByteArray();
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == 0) continue;
            for (int j = 0; j < 8; ++j) {
                if ((1 << j & byArray[i]) == 0) continue;
                --n;
            }
        }
        return n;
    }

    protected int getUnfilledPageCount() {
        int n = 0;
        int n2 = this.freePages.size();
        for (int i = 0; i < this.unFilledPages.size(); ++i) {
            if (!this.unFilledPages.isSet(i) || i < n2 && this.freePages.isSet(i)) continue;
            ++n;
        }
        return n;
    }

    protected int getTotalPageCount() {
        return this.extentLength;
    }

    protected String toDebugString() {
        return null;
    }
}

