/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.transform;

import java.util.Iterator;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.transform.Transformer;

public class PublishTransformer
extends Transformer {
    public final Calendar transform(Calendar calendar) {
        PropertyList calProps = calendar.getProperties();
        Property method = calProps.getProperty("METHOD");
        if (method != null) {
            calProps.remove(method);
        }
        calProps.add(Method.PUBLISH);
        Iterator i = calendar.getComponents().iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            PropertyList compProps = component.getProperties();
            Sequence sequence = (Sequence)compProps.getProperty("SEQUENCE");
            if (sequence == null) {
                compProps.add(new Sequence(0));
                continue;
            }
            compProps.remove(sequence);
            compProps.add(new Sequence(sequence.getSequenceNo() + 1));
        }
        return calendar;
    }
}

