/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar;

import java.util.ArrayList;
import org.walluck.oscar.AIMUtil;

public class CapabilityBlock {
    private int flag;
    private String uuid;
    private byte[] data;
    private static ArrayList capabilities = new ArrayList(20);

    public CapabilityBlock() {
    }

    public CapabilityBlock(int flag, String uuid) {
        this.flag = flag;
        this.uuid = uuid;
        this.data = AIMUtil.uuidToByteArray(uuid);
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public boolean equals(Object obj) {
        CapabilityBlock cap = (CapabilityBlock)obj;
        byte[] data1 = this.data;
        byte[] data2 = cap.getData();
        if (data1 != null && data2 == null || data1 == null && data2 != null) {
            return false;
        }
        int length1 = data1.length;
        int length2 = data2.length;
        if (length1 != 2 && length2 != 2) {
            if (length1 != 16 || length1 != length2) {
                return false;
            }
            for (int i = 0; i < length1; ++i) {
                if (data1[i] == data2[i]) continue;
                return false;
            }
        } else if (length1 == 2 ? data1[0] != data2[2] || data1[1] != data2[3] : length2 == 2 && (data2[0] != data1[2] || data2[1] != data1[3])) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return AIMUtil.byteArrayToHexString(this.data).hashCode();
    }

    public static CapabilityBlock getCapabilityBlock(int flag) {
        int size = capabilities.size();
        for (int i = 0; i < size; ++i) {
            CapabilityBlock cap = (CapabilityBlock)capabilities.get(i);
            if (cap.getFlag() != flag) continue;
            return cap;
        }
        return null;
    }

    public static CapabilityBlock getCapabilityBlock(byte[] b) {
        int size = capabilities.size();
        CapabilityBlock cap1 = new CapabilityBlock();
        cap1.setData(b);
        for (int i = 0; i < size; ++i) {
            CapabilityBlock cap2 = (CapabilityBlock)capabilities.get(i);
            if (!cap2.equals(cap1)) continue;
            return cap2;
        }
        return null;
    }

    public static ArrayList getCapabilities() {
        return capabilities;
    }

    static {
        capabilities.add(new CapabilityBlock(16384, "09461349-4c7f-11d1-8222444553540000"));
        capabilities.add(new CapabilityBlock(131072, "0946134e-4c7f-11d1-8222444553540000"));
        capabilities.add(new CapabilityBlock(4096, "97b12751-243c-4334-ad22-d6abf73f1492"));
        capabilities.add(new CapabilityBlock(32768, "2e7a6475-fadf-4dc8-886f-ea3595fdb6df"));
        capabilities.add(new CapabilityBlock(1024, "09461344-4c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(0x400000, "09461323-4c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(64, "0946134a-4c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(512, "0946134a-4c7f-11d1-2282-444553540000"));
        capabilities.add(new CapabilityBlock(256, "0946134b-4c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(2048, "0946134f-4c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(8, "748f2420-6287-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(262144, "0946134d4c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(2, "09461341-4c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(524288, "09460000-4c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(32, "09461343-4c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(0x100000, "094601ff-4c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(0x200000, "09460001-4c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(4, "09461345-4c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(1, "09461346-4c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(128, "094613474c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(16, "09461348-4c7f-11d1-8222-444553540000"));
        capabilities.add(new CapabilityBlock(65536, "f2e7c7f4-fead-4dfb-b235-36798bdf0000"));
        capabilities.add(new CapabilityBlock(8192, "00000000-0000-0000-0000-000000000000"));
    }
}

