/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers.filetransfer;

import java.io.File;
import java.io.IOException;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.handlers.filetransfer.FileTransfer;

public class FT {
    private AIMSession sess;
    private byte[] cookie;

    public FT(AIMSession sess, byte[] cookie) {
        this.sess = sess;
        this.cookie = cookie;
    }

    private long getDirSize(String dir) {
        return 0L;
    }

    private int getFileCount(String dir) {
        return 1;
    }

    public void sendFile(String screenname, String filename, int subtype, String message) throws IOException {
        int type = 0;
        int fileCount = 0;
        long dirSize = 0L;
        boolean send = false;
        boolean get = false;
        boolean list = false;
        if (subtype == 2 || subtype == 1) {
            send = true;
        } else if (subtype == 17) {
            get = true;
        } else if (subtype == 18) {
            list = true;
        } else {
            throw new IllegalArgumentException();
        }
        if (screenname == null) {
            throw new NullPointerException();
        }
        if (send) {
            if (filename == null) {
                throw new NullPointerException();
            }
            File file = new File(filename);
            if (!file.canRead()) {
                throw new IOException("Cannot read file " + filename);
            }
            if (file.isDirectory()) {
                fileCount = this.getFileCount(filename);
                dirSize = this.getDirSize(filename);
                type = 2;
            } else {
                fileCount = 1;
                dirSize = file.length();
                type = 1;
            }
        } else if (get) {
            if (filename == null) {
                throw new NullPointerException();
            }
            fileCount = 0;
            dirSize = 0L;
            type = 17;
        } else if (list) {
            fileCount = 0;
            dirSize = 0L;
            type = 18;
        }
        FileTransfer ft = new FileTransfer(this.sess);
        if (send) {
            ft.sendFileRequest(this.cookie, screenname, type, fileCount, (int)dirSize, filename, message);
        } else {
            ft.getFileRequest(this.cookie, screenname);
        }
    }
}

