/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool;

import com.xuggle.mediatool.IMediaCoder;
import com.xuggle.mediatool.IMediaDebugListener;
import com.xuggle.mediatool.IMediaGenerator;
import com.xuggle.mediatool.MediaListenerAdapter;
import com.xuggle.mediatool.event.IAddStreamEvent;
import com.xuggle.mediatool.event.IAudioSamplesEvent;
import com.xuggle.mediatool.event.ICloseCoderEvent;
import com.xuggle.mediatool.event.ICloseEvent;
import com.xuggle.mediatool.event.IFlushEvent;
import com.xuggle.mediatool.event.IOpenCoderEvent;
import com.xuggle.mediatool.event.IOpenEvent;
import com.xuggle.mediatool.event.IReadPacketEvent;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import com.xuggle.mediatool.event.IWriteHeaderEvent;
import com.xuggle.mediatool.event.IWritePacketEvent;
import com.xuggle.mediatool.event.IWriteTrailerEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MediaDebugListener
extends MediaListenerAdapter
implements IMediaDebugListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int mMaxNameLength;
    private volatile int mFlags;
    private volatile IMediaDebugListener.Mode mMode;
    private final ConcurrentMap<IMediaDebugListener.Event, AtomicLong> mEventCounts = new ConcurrentHashMap<IMediaDebugListener.Event, AtomicLong>();
    private final String mName;

    private static int getMaxNameLength() {
        return mMaxNameLength;
    }

    MediaDebugListener() {
        this(IMediaDebugListener.Mode.PARAMETERS, IMediaDebugListener.Event.ALL);
    }

    MediaDebugListener(IMediaDebugListener.Event ... events) {
        this(IMediaDebugListener.Mode.PARAMETERS, events);
    }

    MediaDebugListener(IMediaDebugListener.Mode mode, IMediaDebugListener.Event ... events) {
        this(null, mode, events);
    }

    MediaDebugListener(String name, IMediaDebugListener.Mode mode, IMediaDebugListener.Event ... events) {
        this.mName = name;
        this.mMode = mode;
        this.setLogEvents(events);
    }

    private void incrementCount(IMediaDebugListener.Event event) {
        for (IMediaDebugListener.Event candidate : IMediaDebugListener.Event.values()) {
            if ((candidate.getFlag() & event.getFlag()) == 0) continue;
            AtomicLong newValue = new AtomicLong(0L);
            AtomicLong count = this.mEventCounts.putIfAbsent(candidate, newValue);
            if (count == null) {
                count = newValue;
            }
            count.incrementAndGet();
        }
    }

    @Override
    public long getCount(IMediaDebugListener.Event event) {
        AtomicLong value = (AtomicLong)this.mEventCounts.get((Object)event);
        return null == value ? 0L : value.get();
    }

    @Override
    public void resetCounts() {
        this.mEventCounts.clear();
    }

    @Override
    public void setLogEvents(IMediaDebugListener.Event ... events) {
        this.mFlags = 0;
        for (IMediaDebugListener.Event event : events) {
            this.mFlags |= event.getFlag();
        }
    }

    @Override
    public int getFlags() {
        return this.mFlags;
    }

    private void handleEvent(IMediaDebugListener.Event event, IMediaGenerator tool, Object ... args) {
        this.incrementCount(event);
        if ((this.mFlags & event.getFlag()) != 0 && this.mMode != IMediaDebugListener.Mode.NOTHING) {
            StringBuilder string = new StringBuilder();
            if (this.mName != null) {
                string.append(this.mName + " ");
            }
            string.append(event.getMethod() + "(");
            switch (this.mMode) {
                case URL: {
                    if (!(tool instanceof IMediaCoder)) break;
                    string.append(((IMediaCoder)tool).getUrl());
                    break;
                }
                case PARAMETERS: {
                    for (Object arg : args) {
                        string.append(arg + (arg == args[args.length - 1] ? "" : ", "));
                    }
                    break;
                }
            }
            string.append(")");
            this.log.debug(string.toString());
        }
    }

    @Override
    public void onVideoPicture(IVideoPictureEvent event) {
        this.handleEvent(IMediaDebugListener.Event.VIDEO, event.getSource(), event.getPicture(), event.getImage(), event.getStreamIndex());
    }

    @Override
    public void onAudioSamples(IAudioSamplesEvent event) {
        this.handleEvent(IMediaDebugListener.Event.AUDIO, event.getSource(), event.getAudioSamples(), event.getStreamIndex());
    }

    @Override
    public void onOpen(IOpenEvent event) {
        this.handleEvent(IMediaDebugListener.Event.OPEN, event.getSource(), new Object[0]);
    }

    @Override
    public void onClose(ICloseEvent event) {
        this.handleEvent(IMediaDebugListener.Event.CLOSE, event.getSource(), new Object[0]);
    }

    @Override
    public void onAddStream(IAddStreamEvent event) {
        this.handleEvent(IMediaDebugListener.Event.ADD_STREAM, event.getSource(), event.getStreamIndex());
    }

    @Override
    public void onOpenCoder(IOpenCoderEvent event) {
        this.handleEvent(IMediaDebugListener.Event.OPEN_STREAM, event.getSource(), event.getStreamIndex());
    }

    @Override
    public void onCloseCoder(ICloseCoderEvent event) {
        this.handleEvent(IMediaDebugListener.Event.CLOSE_STREAM, event.getSource(), event.getStreamIndex());
    }

    @Override
    public void onReadPacket(IReadPacketEvent event) {
        this.handleEvent(IMediaDebugListener.Event.READ_PACKET, event.getSource(), event.getPacket());
    }

    @Override
    public void onWritePacket(IWritePacketEvent event) {
        this.handleEvent(IMediaDebugListener.Event.WRITE_PACKET, event.getSource(), event.getPacket());
    }

    @Override
    public void onWriteHeader(IWriteHeaderEvent event) {
        this.handleEvent(IMediaDebugListener.Event.HEADER, event.getSource(), new Object[0]);
    }

    @Override
    public void onFlush(IFlushEvent event) {
        this.handleEvent(IMediaDebugListener.Event.FLUSH, event.getSource(), new Object[0]);
    }

    @Override
    public void onWriteTrailer(IWriteTrailerEvent event) {
        this.handleEvent(IMediaDebugListener.Event.TRAILER, event.getSource(), new Object[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("event counts: ");
        for (IMediaDebugListener.Event event : IMediaDebugListener.Event.values()) {
            sb.append(String.format("\n  %" + MediaDebugListener.getMaxNameLength() + "s: %d", event.name(), this.getCount(event)));
        }
        return sb.toString();
    }

    static {
        int maxNameLen = 0;
        for (IMediaDebugListener.Event event : IMediaDebugListener.Event.values()) {
            maxNameLen = Math.max(event.name().length(), maxNameLen);
        }
        mMaxNameLength = maxNameLen;
    }
}

