/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.XugglerJNI;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class IContainerFormat
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IContainerFormat(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIContainerFormatUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected IContainerFormat(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(XugglerJNI.SWIGIContainerFormatUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IContainerFormat obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public IContainerFormat copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new IContainerFormat(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IContainerFormat) {
            equal = ((IContainerFormat)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        if (this.isInput()) {
            result.append("iname:" + this.getInputFormatShortName() + ";");
            result.append("ilongname:" + this.getInputFormatLongName() + ";");
        }
        if (this.isOutput()) {
            result.append("oname:" + this.getOutputFormatShortName() + ";");
            result.append("olongname:" + this.getOutputFormatLongName() + ";");
            result.append("omimetype:" + this.getOutputFormatMimeType() + ";");
            result.append("oextensions:" + this.getOutputExtensions() + ";");
        }
        result.append("]");
        return result.toString();
    }

    public List<ICodec.ID> getOutputCodecsSupported() {
        LinkedList<ICodec.ID> retval = new LinkedList<ICodec.ID>();
        HashSet<ICodec.ID> uniqueSet = new HashSet<ICodec.ID>();
        int numCodecs = this.getOutputNumCodecsSupported();
        for (int i = 0; i < numCodecs; ++i) {
            ICodec.ID id = this.getOutputCodecID(i);
            if (id != ICodec.ID.CODEC_ID_NONE && !uniqueSet.contains((Object)id)) {
                retval.add(id);
            }
            uniqueSet.add(id);
        }
        return retval;
    }

    public List<Integer> getOutputTagsSupported() {
        LinkedList<Integer> retval = new LinkedList<Integer>();
        HashSet<Integer> uniqueSet = new HashSet<Integer>();
        int numCodecs = this.getOutputNumCodecsSupported();
        for (int i = 0; i < numCodecs; ++i) {
            int tag = this.getOutputCodecTag(i);
            ICodec.ID id = this.getOutputCodecID(i);
            if (id != ICodec.ID.CODEC_ID_NONE && !uniqueSet.contains(tag)) {
                retval.add(tag);
            }
            uniqueSet.add(tag);
        }
        return retval;
    }

    public static Collection<IContainerFormat> getInstalledInputFormats() {
        HashSet<IContainerFormat> retval = new HashSet<IContainerFormat>();
        int count = IContainerFormat.getNumInstalledInputFormats();
        for (int i = 0; i < count; ++i) {
            IContainerFormat fmt = IContainerFormat.getInstalledInputFormat(i);
            if (fmt == null) continue;
            retval.add(fmt);
        }
        return retval;
    }

    public static Collection<IContainerFormat> getInstalledOutputFormats() {
        HashSet<IContainerFormat> retval = new HashSet<IContainerFormat>();
        int count = IContainerFormat.getNumInstalledOutputFormats();
        for (int i = 0; i < count; ++i) {
            IContainerFormat fmt = IContainerFormat.getInstalledOutputFormat(i);
            if (fmt == null) continue;
            retval.add(fmt);
        }
        return retval;
    }

    public ICodec.ID establishOutputCodecId(ICodec.Type type) {
        return this.establishOutputCodecId(type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodec.ID establishOutputCodecId(ICodec.ID inputCodecId) {
        RefCounted codec = null;
        try {
            if (inputCodecId == null || inputCodecId == ICodec.ID.CODEC_ID_NONE) {
                throw new IllegalArgumentException("null inputCodecId");
            }
            codec = ICodec.findDecodingCodec(inputCodecId);
            if (codec == null) {
                throw new UnsupportedOperationException("could not find decoding codec");
            }
            ICodec.ID iD = this.establishOutputCodecId((ICodec)codec);
            return iD;
        }
        finally {
            if (codec != null) {
                codec.delete();
            }
        }
    }

    public ICodec.ID establishOutputCodecId(ICodec inputCodec) {
        if (inputCodec == null) {
            throw new IllegalArgumentException();
        }
        return this.establishOutputCodecId(inputCodec.getType(), inputCodec.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodec.ID establishOutputCodecId(ICodec.Type type, ICodec.ID inputCodecId) {
        RefCounted codec = null;
        RefCounted inputCodec = null;
        try {
            if (type == null) {
                throw new IllegalArgumentException("null codec type");
            }
            if (!this.isOutput()) {
                throw new IllegalArgumentException("passed output container format, actally an input container format");
            }
            if (inputCodecId != null && inputCodecId != ICodec.ID.CODEC_ID_NONE) {
                inputCodec = ICodec.findDecodingCodec(inputCodecId);
                if (inputCodec == null) {
                    throw new IllegalArgumentException("could not find input codec id");
                }
                if (((ICodec)inputCodec).getType() != type) {
                    throw new IllegalArgumentException("inputCodecId of different type than expected");
                }
            }
            ICodec.ID outputCodecId = null;
            switch (type) {
                case CODEC_TYPE_AUDIO: {
                    outputCodecId = this.getOutputDefaultAudioCodec();
                    break;
                }
                case CODEC_TYPE_VIDEO: {
                    outputCodecId = this.getOutputDefaultVideoCodec();
                    break;
                }
                case CODEC_TYPE_SUBTITLE: {
                    outputCodecId = this.getOutputDefaultSubtitleCodec();
                }
            }
            if (outputCodecId != null && outputCodecId != ICodec.ID.CODEC_ID_NONE) {
                codec = ICodec.findEncodingCodec(outputCodecId);
            }
            if (codec != null) {
                ICodec.ID iD = outputCodecId;
                return iD;
            }
            if (inputCodec != null && (codec = ICodec.findEncodingCodec(inputCodecId)) != null && this.isCodecSupportedForOutput(((ICodec)codec).getID())) {
                ICodec.ID iD = ((ICodec)codec).getID();
                return iD;
            }
            for (ICodec.ID codecId : this.getOutputCodecsSupported()) {
                if (codec != null) {
                    codec.delete();
                }
                if ((codec = ICodec.findEncodingCodec(codecId)) == null || ((ICodec)codec).getType() != type) continue;
                outputCodecId = ((ICodec)codec).getID();
                if (!((ICodec)codec).canEncode()) continue;
                break;
            }
            if (outputCodecId == null || outputCodecId == ICodec.ID.CODEC_ID_NONE) {
                throw new UnsupportedOperationException("could not guess codec");
            }
            ICodec.ID iD = outputCodecId;
            return iD;
        }
        finally {
            if (codec != null) {
                codec.delete();
            }
            if (inputCodec != null) {
                inputCodec.delete();
            }
        }
    }

    public int setInputFormat(String shortName) {
        return XugglerJNI.IContainerFormat_setInputFormat(this.swigCPtr, this, shortName);
    }

    public int setOutputFormat(String shortName, String url, String mimeType) {
        return XugglerJNI.IContainerFormat_setOutputFormat(this.swigCPtr, this, shortName, url, mimeType);
    }

    public String getInputFormatShortName() {
        return XugglerJNI.IContainerFormat_getInputFormatShortName(this.swigCPtr, this);
    }

    public String getInputFormatLongName() {
        return XugglerJNI.IContainerFormat_getInputFormatLongName(this.swigCPtr, this);
    }

    public String getOutputFormatShortName() {
        return XugglerJNI.IContainerFormat_getOutputFormatShortName(this.swigCPtr, this);
    }

    public String getOutputFormatLongName() {
        return XugglerJNI.IContainerFormat_getOutputFormatLongName(this.swigCPtr, this);
    }

    public String getOutputFormatMimeType() {
        return XugglerJNI.IContainerFormat_getOutputFormatMimeType(this.swigCPtr, this);
    }

    public static IContainerFormat make() {
        long cPtr = XugglerJNI.IContainerFormat_make();
        return cPtr == 0L ? null : new IContainerFormat(cPtr, false);
    }

    public int getInputFlags() {
        return XugglerJNI.IContainerFormat_getInputFlags(this.swigCPtr, this);
    }

    public void setInputFlags(int newFlags) {
        XugglerJNI.IContainerFormat_setInputFlags(this.swigCPtr, this, newFlags);
    }

    public boolean getInputFlag(Flags flag) {
        return XugglerJNI.IContainerFormat_getInputFlag(this.swigCPtr, this, flag.swigValue());
    }

    public void setInputFlag(Flags flag, boolean value) {
        XugglerJNI.IContainerFormat_setInputFlag(this.swigCPtr, this, flag.swigValue(), value);
    }

    public int getOutputFlags() {
        return XugglerJNI.IContainerFormat_getOutputFlags(this.swigCPtr, this);
    }

    public void setOutputFlags(int newFlags) {
        XugglerJNI.IContainerFormat_setOutputFlags(this.swigCPtr, this, newFlags);
    }

    public boolean getOutputFlag(Flags flag) {
        return XugglerJNI.IContainerFormat_getOutputFlag(this.swigCPtr, this, flag.swigValue());
    }

    public void setOutputFlag(Flags flag, boolean value) {
        XugglerJNI.IContainerFormat_setOutputFlag(this.swigCPtr, this, flag.swigValue(), value);
    }

    public boolean isOutput() {
        return XugglerJNI.IContainerFormat_isOutput(this.swigCPtr, this);
    }

    public boolean isInput() {
        return XugglerJNI.IContainerFormat_isInput(this.swigCPtr, this);
    }

    public String getOutputExtensions() {
        return XugglerJNI.IContainerFormat_getOutputExtensions(this.swigCPtr, this);
    }

    public ICodec.ID getOutputDefaultAudioCodec() {
        return ICodec.ID.swigToEnum(XugglerJNI.IContainerFormat_getOutputDefaultAudioCodec(this.swigCPtr, this));
    }

    public ICodec.ID getOutputDefaultVideoCodec() {
        return ICodec.ID.swigToEnum(XugglerJNI.IContainerFormat_getOutputDefaultVideoCodec(this.swigCPtr, this));
    }

    public ICodec.ID getOutputDefaultSubtitleCodec() {
        return ICodec.ID.swigToEnum(XugglerJNI.IContainerFormat_getOutputDefaultSubtitleCodec(this.swigCPtr, this));
    }

    public int getOutputNumCodecsSupported() {
        return XugglerJNI.IContainerFormat_getOutputNumCodecsSupported(this.swigCPtr, this);
    }

    public ICodec.ID getOutputCodecID(int index) {
        return ICodec.ID.swigToEnum(XugglerJNI.IContainerFormat_getOutputCodecID(this.swigCPtr, this, index));
    }

    public int getOutputCodecTag(int index) {
        return XugglerJNI.IContainerFormat_getOutputCodecTag__SWIG_0(this.swigCPtr, this, index);
    }

    public int getOutputCodecTag(ICodec.ID id) {
        return XugglerJNI.IContainerFormat_getOutputCodecTag__SWIG_1(this.swigCPtr, this, id.swigValue());
    }

    public boolean isCodecSupportedForOutput(ICodec.ID id) {
        return XugglerJNI.IContainerFormat_isCodecSupportedForOutput(this.swigCPtr, this, id.swigValue());
    }

    public static int getNumInstalledInputFormats() {
        return XugglerJNI.IContainerFormat_getNumInstalledInputFormats();
    }

    public static IContainerFormat getInstalledInputFormat(int index) {
        long cPtr = XugglerJNI.IContainerFormat_getInstalledInputFormat(index);
        return cPtr == 0L ? null : new IContainerFormat(cPtr, false);
    }

    public static int getNumInstalledOutputFormats() {
        return XugglerJNI.IContainerFormat_getNumInstalledOutputFormats();
    }

    public static IContainerFormat getInstalledOutputFormat(int index) {
        long cPtr = XugglerJNI.IContainerFormat_getInstalledOutputFormat(index);
        return cPtr == 0L ? null : new IContainerFormat(cPtr, false);
    }

    public static enum Flags {
        FLAG_NOFILE(XugglerJNI.IContainerFormat_FLAG_NOFILE_get()),
        FLAG_NEEDNUMBER(XugglerJNI.IContainerFormat_FLAG_NEEDNUMBER_get()),
        FLAG_SHOW_IDS(XugglerJNI.IContainerFormat_FLAG_SHOW_IDS_get()),
        FLAG_RAWPICTURE(XugglerJNI.IContainerFormat_FLAG_RAWPICTURE_get()),
        FLAG_GLOBALHEADER(XugglerJNI.IContainerFormat_FLAG_GLOBALHEADER_get()),
        FLAG_NOTIMESTAMPS(XugglerJNI.IContainerFormat_FLAG_NOTIMESTAMPS_get()),
        FLAG_GENERIC_INDEX(XugglerJNI.IContainerFormat_FLAG_GENERIC_INDEX_get()),
        FLAG_TS_DISCONT(XugglerJNI.IContainerFormat_FLAG_TS_DISCONT_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Flags swigToEnum(int swigValue) {
            Flags[] swigValues = (Flags[])Flags.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Flags swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Flags.class + " with value " + swigValue);
        }

        private Flags() {
            this.swigValue = SwigNext.next++;
        }

        private Flags(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Flags(Flags swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

