/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.sun.jmx.trace.Trace;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;

public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration {
    private List observedObjects = new ArrayList();
    private String observedAttribute = null;
    private long granularityPeriod = 10000L;
    protected static final int capacityIncrement = 16;
    protected int elementCount = 0;
    protected int alreadyNotified = 0;
    protected int[] alreadyNotifieds = new int[16];
    protected MBeanServer server = null;
    protected static final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
    protected static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 1;
    protected static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 2;
    protected static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 4;
    protected static final int RUNTIME_ERROR_NOTIFIED = 8;
    protected String dbgTag = "Monitor";
    transient boolean isActive = false;
    transient long sequenceNumber = 0L;

    boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)4);
    }

    void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)4, (String)string, (String)string2, (String)string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)4);
    }

    void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)4, (String)string, (String)string2, (String)string3);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (this.isTraceOn()) {
            this.trace("preRegister", "initialize the reference on the MBean server");
        }
        this.server = mBeanServer;
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
        if (this.isTraceOn()) {
            this.trace("preDeregister", "stop the monitor");
        }
        this.stop();
    }

    public void postDeregister() {
    }

    public abstract void start();

    public abstract void stop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName getObservedObject() {
        Monitor monitor = this;
        synchronized (monitor) {
            if (this.observedObjects.isEmpty()) {
                return null;
            }
            return (ObjectName)this.observedObjects.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservedObject(ObjectName objectName) throws IllegalArgumentException {
        Monitor monitor = this;
        synchronized (monitor) {
            while (!this.observedObjects.isEmpty()) {
                this.removeObservedObject((ObjectName)this.observedObjects.get(0));
            }
            this.addObservedObject(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObservedObject(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            throw new IllegalArgumentException("The object to observe cannot be null.");
        }
        Monitor monitor = this;
        synchronized (monitor) {
            if (this.observedObjects.contains(objectName)) {
                return;
            }
            this.observedObjects.add(objectName);
            int n = 0;
            n &= 0xFFFFFFFE;
            n &= 0xFFFFFFFD;
            this.insertintElementAt(this.alreadyNotifieds, n &= 0xFFFFFFFB, this.elementCount);
            this.updateDeprecatedAlreadyNotified();
            this.insertSpecificElementAt(this.elementCount);
            ++this.elementCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObservedObject(ObjectName objectName) {
        Monitor monitor = this;
        synchronized (monitor) {
            int n = this.observedObjects.indexOf(objectName);
            if (n >= 0) {
                this.observedObjects.remove(n);
                this.removeintElementAt(this.alreadyNotifieds, n);
                this.updateDeprecatedAlreadyNotified();
                this.removeSpecificElementAt(n);
                --this.elementCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObservedObject(ObjectName objectName) {
        Monitor monitor = this;
        synchronized (monitor) {
            return this.observedObjects.contains(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getObservedObjects() {
        ObjectName[] objectNameArray;
        Monitor monitor = this;
        synchronized (monitor) {
            objectNameArray = new ObjectName[this.elementCount];
            for (int i = 0; i < this.elementCount; ++i) {
                objectNameArray[i] = (ObjectName)this.observedObjects.get(i);
            }
        }
        return objectNameArray;
    }

    public String getObservedAttribute() {
        return this.observedAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservedAttribute(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("The attribute to observe cannot be null.");
        }
        Monitor monitor = this;
        synchronized (monitor) {
            this.observedAttribute = string;
            for (int i = 0; i < this.elementCount; ++i) {
                this.resetAlreadyNotified(i, 6);
            }
        }
    }

    public long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public void setGranularityPeriod(long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException("The granularity period must be greater than zero.");
        }
        this.granularityPeriod = l;
    }

    public boolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObjectName getObservedObject(int n) throws ArrayIndexOutOfBoundsException {
        Monitor monitor = this;
        synchronized (monitor) {
            return (ObjectName)this.observedObjects.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDeprecatedAlreadyNotified() {
        Monitor monitor = this;
        synchronized (monitor) {
            this.alreadyNotified = this.elementCount > 0 ? this.alreadyNotifieds[0] : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAlreadyNotified(int n, int n2) {
        Monitor monitor = this;
        synchronized (monitor) {
            int n3 = n;
            this.alreadyNotifieds[n3] = this.alreadyNotifieds[n3] | n2;
            if (n == 0) {
                this.updateDeprecatedAlreadyNotified();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetAlreadyNotified(int n, int n2) {
        Monitor monitor = this;
        synchronized (monitor) {
            int n3 = n;
            this.alreadyNotifieds[n3] = this.alreadyNotifieds[n3] & ~n2;
            if (n == 0) {
                this.updateDeprecatedAlreadyNotified();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetAllAlreadyNotified(int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            this.alreadyNotifieds[n] = 0;
            if (n == 0) {
                this.updateDeprecatedAlreadyNotified();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertintElementAt(int[] nArray, int n, int n2) {
        Monitor monitor = this;
        synchronized (monitor) {
            this.ensureintCapacity(nArray, this.elementCount + 1);
            System.arraycopy(nArray, n2, nArray, n2 + 1, this.elementCount - n2);
            nArray[n2] = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertlongElementAt(long[] lArray, long l, int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            this.ensurelongCapacity(lArray, this.elementCount + 1);
            System.arraycopy(lArray, n, lArray, n + 1, this.elementCount - n);
            lArray[n] = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertbooleanElementAt(boolean[] blArray, boolean bl, int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            this.ensurebooleanCapacity(blArray, this.elementCount + 1);
            System.arraycopy(blArray, n, blArray, n + 1, this.elementCount - n);
            blArray[n] = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertNumberElementAt(Number[] numberArray, Number number, int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            this.ensureNumberCapacity(numberArray, this.elementCount + 1);
            System.arraycopy(numberArray, n, numberArray, n + 1, this.elementCount - n);
            numberArray[n] = number;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertStringElementAt(String[] stringArray, String string, int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            this.ensureStringCapacity(stringArray, this.elementCount + 1);
            System.arraycopy(stringArray, n, stringArray, n + 1, this.elementCount - n);
            stringArray[n] = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeintElementAt(int[] nArray, int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            if (n < 0 || n >= this.elementCount) {
                return;
            }
            int n2 = this.elementCount - n - 1;
            if (n2 > 0) {
                System.arraycopy(nArray, n + 1, nArray, n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removelongElementAt(long[] lArray, int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            if (n < 0 || n >= this.elementCount) {
                return;
            }
            int n2 = this.elementCount - n - 1;
            if (n2 > 0) {
                System.arraycopy(lArray, n + 1, lArray, n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removebooleanElementAt(boolean[] blArray, int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            if (n < 0 || n >= this.elementCount) {
                return;
            }
            int n2 = this.elementCount - n - 1;
            if (n2 > 0) {
                System.arraycopy(blArray, n + 1, blArray, n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNumberElementAt(Number[] numberArray, int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            if (n < 0 || n >= this.elementCount) {
                return;
            }
            int n2 = this.elementCount - n - 1;
            if (n2 > 0) {
                System.arraycopy(numberArray, n + 1, numberArray, n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStringElementAt(String[] stringArray, int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            if (n < 0 || n >= this.elementCount) {
                return;
            }
            int n2 = this.elementCount - n - 1;
            if (n2 > 0) {
                System.arraycopy(stringArray, n + 1, stringArray, n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureintCapacity(int[] nArray, int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            int n2 = nArray.length;
            if (n > n2) {
                int[] nArray2 = nArray;
                int n3 = n2 + 16;
                if (n3 < n) {
                    n3 = n;
                }
                nArray = new int[n3];
                System.arraycopy(nArray2, 0, nArray, 0, this.elementCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensurelongCapacity(long[] lArray, int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            int n2 = lArray.length;
            if (n > n2) {
                long[] lArray2 = lArray;
                int n3 = n2 + 16;
                if (n3 < n) {
                    n3 = n;
                }
                lArray = new long[n3];
                System.arraycopy(lArray2, 0, lArray, 0, this.elementCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensurebooleanCapacity(boolean[] blArray, int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            int n2 = blArray.length;
            if (n > n2) {
                boolean[] blArray2 = blArray;
                int n3 = n2 + 16;
                if (n3 < n) {
                    n3 = n;
                }
                blArray = new boolean[n3];
                System.arraycopy(blArray2, 0, blArray, 0, this.elementCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureNumberCapacity(Number[] numberArray, int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            int n2 = numberArray.length;
            if (n > n2) {
                Number[] numberArray2 = numberArray;
                int n3 = n2 + 16;
                if (n3 < n) {
                    n3 = n;
                }
                numberArray = new Number[n3];
                System.arraycopy(numberArray2, 0, numberArray, 0, this.elementCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureStringCapacity(String[] stringArray, int n) {
        Monitor monitor = this;
        synchronized (monitor) {
            int n2 = stringArray.length;
            if (n > n2) {
                String[] stringArray2 = stringArray;
                int n3 = n2 + 16;
                if (n3 < n) {
                    n3 = n;
                }
                stringArray = new String[n3];
                System.arraycopy(stringArray2, 0, stringArray, 0, this.elementCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int indexOf(ObjectName objectName) {
        Monitor monitor = this;
        synchronized (monitor) {
            return this.observedObjects.indexOf(objectName);
        }
    }

    abstract void insertSpecificElementAt(int var1);

    abstract void removeSpecificElementAt(int var1);

    void sendNotification(String string, long l, String string2, Object object, Object object2, int n) {
        if (this.isTraceOn()) {
            this.trace("sendNotification", "send notification:\n\tNotification observed object = " + this.getObservedObject(n) + "\n\tNotification observed attribute = " + this.observedAttribute + "\n\tNotification derived gauge = " + object);
        }
        this.sendNotification(new MonitorNotification(string, this, this.sequenceNumber++, l, string2, this.getObservedObject(n), this.observedAttribute, object, object2));
    }
}

