/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.jsontoken.discovery;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.security.PublicKey;
import java.util.Map;
import net.oauth.jsontoken.crypto.MagicRsaPublicKey;
import net.oauth.jsontoken.discovery.ServerInfo;

public class JsonServerInfo
implements ServerInfo {
    @SerializedName(value="verification_keys")
    private final Map<String, String> verificationKeys = Maps.newHashMap();

    public static JsonServerInfo getDocument(String json) {
        return (JsonServerInfo)new Gson().fromJson(json, JsonServerInfo.class);
    }

    @Override
    public PublicKey getVerificationKey(String keyId) {
        String magicKey = this.verificationKeys.get(keyId);
        if (magicKey == null) {
            return null;
        }
        return new MagicRsaPublicKey(magicKey).getKey();
    }
}

