/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.wrapper;

import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanager.storageclient.protocol.utils.Utils;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.Configuration;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageClient {
    private String clientID;
    private AccessType typeAccess;
    private MemoryType memoryType;
    private String serviceClass;
    private String serviceName;
    private String owner;
    private String server;
    private String scopeString;
    private String currentScope;
    private String backendType;
    private String volatileHost;
    private String RRScope;
    private static final Logger logger = LoggerFactory.getLogger(StorageClient.class);
    private static final String DEFAULT_SERVICE_CLASS = "ExternalApplication";
    private static final String DEFAULT_SERVICE_NAME = "Default";
    private static final MemoryType DEFAULT_MEMORY_TYPE = MemoryType.PERSISTENT;

    @Deprecated
    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope, boolean forceScope) {
        this.checkScopeProvider();
        if (forceScope) {
            this.currentScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set(scope);
            this.scopeString = ScopeProvider.instance.get();
        } else {
            this.RRScope = scope;
            this.scopeString = ScopeProvider.instance.get();
        }
        String id = owner;
        this.owner = owner;
        if (accessType == null) {
            throw new RuntimeException("AccessType parameter must be not null");
        }
        this.typeAccess = accessType;
        this.memoryType = MemoryType.BOTH;
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.setClientId(serviceClass, serviceName, id);
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType) {
        this.checkScopeProvider();
        String id = owner;
        this.owner = owner;
        this.scopeString = ScopeProvider.instance.get();
        if (accessType == null) {
            throw new RuntimeException("AccessType parameter must be not null");
        }
        this.typeAccess = accessType;
        this.memoryType = MemoryType.BOTH;
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.setClientId(serviceClass, serviceName, id);
    }

    public StorageClient(String owner, AccessType accessType, MemoryType memory) {
        this.checkScopeProvider();
        String id = owner;
        this.owner = owner;
        this.scopeString = ScopeProvider.instance.get();
        if (accessType == null) {
            throw new RuntimeException("AccessType parameter must be not null");
        }
        this.typeAccess = accessType;
        if (memory == null) {
            throw new RuntimeException("MemoryType parameter must be not null");
        }
        this.memoryType = memory;
        this.serviceClass = DEFAULT_SERVICE_CLASS;
        this.serviceName = DEFAULT_SERVICE_NAME;
        this.setClientId(this.serviceClass, this.serviceName, id);
    }

    public StorageClient(String serviceClass, String serviceName, String owner, String server, AccessType accessType) {
        this.checkScopeProvider();
        String id = owner;
        this.owner = owner;
        this.scopeString = ScopeProvider.instance.get();
        if (accessType == null) {
            throw new RuntimeException("AccessType parameter must be not null");
        }
        this.typeAccess = accessType;
        this.memoryType = MemoryType.BOTH;
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.server = server;
        this.memoryType = DEFAULT_MEMORY_TYPE;
        this.setClientId(serviceClass, serviceName, id);
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, MemoryType memory) {
        this.checkScopeProvider();
        String id = owner;
        this.owner = owner;
        this.scopeString = ScopeProvider.instance.get();
        if (accessType == null) {
            throw new RuntimeException("AccessType parameter must be not null");
        }
        this.typeAccess = accessType;
        if (memory == null) {
            throw new RuntimeException("MemoryType parameter must be not null");
        }
        this.memoryType = memory;
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.setClientId(serviceClass, serviceName, id);
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, MemoryType memory, String server) {
        this.checkScopeProvider();
        String id = owner;
        this.owner = owner;
        this.scopeString = ScopeProvider.instance.get();
        if (accessType == null) {
            throw new RuntimeException("AccessType parameter must be not null");
        }
        this.typeAccess = accessType;
        if (this.memoryType == null) {
            throw new RuntimeException("MemoryType parameter must be not null");
        }
        this.memoryType = memory;
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.server = server;
        this.setClientId(serviceClass, serviceName, id);
    }

    public IClient getClient() {
        Configuration cfg = new Configuration(this.serviceClass, this.serviceName, this.scopeString, this.owner, this.clientID, this.typeAccess.toString(), this.memoryType.toString());
        cfg.getConfiguration();
        ServiceEngine engine = new ServiceEngine(cfg.getPersistentHosts(), cfg.getVolatileHost(), cfg.getEnvironment(), cfg.getTypeAccess(), cfg.getOwner(), cfg.getMemoryType());
        engine.setServiceClass(this.serviceClass);
        engine.setServiceName(this.serviceName);
        engine.setGcubeAccessType(this.typeAccess.toString());
        engine.setBackendType(this.backendType);
        engine.setBackendUser(cfg.getUser());
        engine.setBackendPassword(cfg.getPassword());
        engine.setResolverHost(cfg.getResolverHost());
        if (cfg.getPassPhrase() != null) {
            engine.setPassPhrase(cfg.getPassPhrase());
        }
        if (this.memoryType != null) {
            engine.setGcubeMemoryType(this.memoryType.toString());
        }
        engine.setGcubeScope(ScopeProvider.instance.get());
        engine.setOwnerGcube(this.owner);
        cfg.readWRPropertiesFromRR(this.currentScope, engine);
        if (this.currentScope != null) {
            ScopeProvider.instance.set(this.currentScope);
        }
        return engine;
    }

    private void setClientId(String serviceClass, String serviceName, String id) {
        if (this.typeAccess == AccessType.PUBLIC) {
            this.clientID = "";
        } else if (this.typeAccess == AccessType.PRIVATE) {
            this.clientID = "/home/" + serviceClass + "/" + serviceName + "/" + id;
        } else if (this.typeAccess == AccessType.SHARED) {
            this.clientID = "/home/" + serviceClass + "/" + serviceName;
        } else {
            throw new IllegalArgumentException("type is not correctly: public, private or shared");
        }
    }

    private void checkScopeProvider() {
        String scopeProvided = ScopeProvider.instance.get();
        if (scopeProvided == null) {
            scopeProvided = Utils.checkVarEnv("SCOPE");
            if (scopeProvided != null) {
                ScopeProvider.instance.set(scopeProvided);
            } else {
                throw new RuntimeException("Scope not set ");
            }
        }
    }
}

