/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.apache.jackrabbit.core.util.db.ResultSetWrapper;
import org.apache.jackrabbit.core.util.db.StreamWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHelper {
    private static Logger log = LoggerFactory.getLogger(ConnectionHelper.class);
    private static final int RETRIES = 1;
    private static final int SLEEP_BETWEEN_RETRIES_MS = 100;
    private final boolean blockOnConnectionLoss;
    private final boolean checkTablesWithUserName;
    protected final DataSource dataSource;
    private boolean inBatchMode = false;
    private Connection batchConnection = null;

    public ConnectionHelper(DataSource dataSrc, boolean block) {
        this.dataSource = dataSrc;
        this.checkTablesWithUserName = false;
        this.blockOnConnectionLoss = block;
    }

    protected ConnectionHelper(DataSource dataSrc, boolean checkWithUserName, boolean block) {
        this.dataSource = dataSrc;
        this.checkTablesWithUserName = checkWithUserName;
        this.blockOnConnectionLoss = block;
    }

    public final String prepareDbIdentifier(String identifier) throws SQLException {
        if (identifier == null) {
            return null;
        }
        String legalChars = "ABCDEFGHIJKLMNOPQRSTUVWXZY0123456789_";
        legalChars = legalChars + this.getExtraNameCharacters();
        String id = identifier.toUpperCase();
        StringBuffer escaped = new StringBuffer();
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (legalChars.indexOf(c) == -1) {
                this.replaceCharacter(escaped, c);
                continue;
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    protected void replaceCharacter(StringBuffer escaped, char c) {
        escaped.append("_x");
        String hex = Integer.toHexString(c);
        escaped.append("0000".toCharArray(), 0, 4 - hex.length());
        escaped.append(hex);
        escaped.append("_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExtraNameCharacters() throws SQLException {
        Connection con = this.dataSource.getConnection();
        try {
            DatabaseMetaData metaData = con.getMetaData();
            String string = metaData.getExtraNameCharacters();
            return string;
        }
        finally {
            DbUtility.close(con, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tableExists(String tableName) throws SQLException {
        Connection con = this.dataSource.getConnection();
        ResultSet rs = null;
        boolean schemaExists = false;
        String name = tableName;
        try {
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData.storesLowerCaseIdentifiers()) {
                name = tableName.toLowerCase();
            } else if (metaData.storesUpperCaseIdentifiers()) {
                name = tableName.toUpperCase();
            }
            String userName = null;
            if (this.checkTablesWithUserName) {
                userName = metaData.getUserName();
            }
            rs = metaData.getTables(null, userName, name, null);
            schemaExists = rs.next();
        }
        catch (Throwable throwable) {
            DbUtility.close(con, null, rs);
            throw throwable;
        }
        DbUtility.close(con, null, rs);
        return schemaExists;
    }

    public final void startBatch() throws SQLException {
        if (this.inBatchMode) {
            throw new IllegalStateException("already in batch mode");
        }
        try {
            this.batchConnection = this.getConnection();
            this.batchConnection.setAutoCommit(false);
            this.inBatchMode = true;
        }
        catch (SQLException e) {
            if (this.batchConnection != null) {
                DbUtility.close(this.batchConnection, null, null);
            }
            this.batchConnection = null;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void endBatch(boolean commit) throws SQLException {
        if (!this.inBatchMode) {
            throw new IllegalStateException("not in batch mode");
        }
        try {
            if (commit) {
                this.batchConnection.commit();
            } else {
                this.batchConnection.rollback();
            }
        }
        finally {
            DbUtility.close(this.batchConnection, null, null);
            this.batchConnection = null;
            this.inBatchMode = false;
        }
    }

    public final void exec(final String sql, final Object ... params) throws SQLException {
        new RetryManager<Void>(){

            @Override
            protected Void call() throws SQLException {
                ConnectionHelper.this.reallyExec(sql, params);
                return null;
            }
        }.doTry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reallyExec(String sql, Object ... params) throws SQLException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            if (params == null || params.length == 0) {
                stmt = con.createStatement();
                stmt.execute(sql);
            } else {
                stmt = con.prepareStatement(sql);
                this.execute((PreparedStatement)stmt, params);
            }
            this.closeResources(con, stmt, null);
        }
        catch (Throwable throwable) {
            this.closeResources(con, stmt, null);
            throw throwable;
        }
    }

    public final int update(final String sql, final Object[] params) throws SQLException {
        return (Integer)new RetryManager<Integer>(){

            @Override
            protected Integer call() throws SQLException {
                return ConnectionHelper.this.reallyUpdate(sql, params);
            }
        }.doTry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reallyUpdate(String sql, Object[] params) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int n = this.execute(stmt, params).getUpdateCount();
            return n;
        }
        finally {
            this.closeResources(con, stmt, null);
        }
    }

    public final ResultSet exec(final String sql, final Object[] params, final boolean returnGeneratedKeys, final int maxRows) throws SQLException {
        return (ResultSet)new RetryManager<ResultSet>(){

            @Override
            protected ResultSet call() throws SQLException {
                return ConnectionHelper.this.reallyExec(sql, params, returnGeneratedKeys, maxRows);
            }
        }.doTry();
    }

    private ResultSet reallyExec(String sql, Object[] params, boolean returnGeneratedKeys, int maxRows) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = returnGeneratedKeys ? con.prepareStatement(sql, 1) : con.prepareStatement(sql);
            stmt.setMaxRows(maxRows);
            this.execute(stmt, params);
            rs = returnGeneratedKeys ? stmt.getGeneratedKeys() : stmt.getResultSet();
            if (rs == null) {
                return null;
            }
            if (this.inBatchMode) {
                return ResultSetWrapper.newInstance(null, stmt, rs);
            }
            return ResultSetWrapper.newInstance(con, stmt, rs);
        }
        catch (SQLException e) {
            this.closeResources(con, stmt, rs);
            throw e;
        }
    }

    protected final Connection getConnection() throws SQLException {
        if (this.inBatchMode) {
            return this.batchConnection;
        }
        Connection con = this.dataSource.getConnection();
        if (!con.getAutoCommit()) {
            con.setAutoCommit(true);
        }
        return con;
    }

    protected final void closeResources(Connection con, Statement stmt, ResultSet rs) {
        if (this.inBatchMode) {
            DbUtility.close(null, stmt, rs);
        } else {
            DbUtility.close(con, stmt, rs);
        }
    }

    protected PreparedStatement execute(PreparedStatement stmt, Object[] params) throws SQLException {
        for (int i = 0; params != null && i < params.length; ++i) {
            Object p = params[i];
            if (p instanceof StreamWrapper) {
                StreamWrapper wrapper = (StreamWrapper)p;
                stmt.setBinaryStream(i + 1, wrapper.getStream(), (int)wrapper.getSize());
                continue;
            }
            stmt.setObject(i + 1, p);
        }
        stmt.execute();
        return stmt;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class RetryManager<T> {
        public final T doTry() throws SQLException {
            if (ConnectionHelper.this.inBatchMode) {
                return this.call();
            }
            boolean sleepInterrupted = false;
            int failures = 0;
            SQLException lastException = null;
            while (!sleepInterrupted && (ConnectionHelper.this.blockOnConnectionLoss || failures <= 1)) {
                try {
                    return this.call();
                }
                catch (SQLException e) {
                    lastException = e;
                    log.error("Failed to execute SQL (stacktrace on DEBUG log level)", (Throwable)lastException);
                    log.debug("Failed to execute SQL", (Throwable)lastException);
                    if (!ConnectionHelper.this.blockOnConnectionLoss && ++failures > 1) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        sleepInterrupted = true;
                        log.error("Interrupted: canceling retry");
                    }
                }
            }
            throw lastException;
        }

        protected abstract T call() throws SQLException;
    }
}

